/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "blood.h"
#include "car.h"
#include "data.h"
#include "food.h"
#include "game.h"
#include "level.h"
#include "mymath.h"
#include "shit.h"



enum {
  FLY,
  DOWN,
  WALK,
  UP,
};

typedef struct PLAYER
{
  int lifes;
  int state;
  int time;
  int ani_time;
  int lock;
  float x, y, z;
  float angle;
  float speed;
  int food;
  int score;
} PLAYER;

static PLAYER player;



static void add_left_angle(float angle)
{
  player.angle -= angle;
  if (player.angle < -M_PI) {
    player.angle = M_PI - (-player.angle - M_PI);
  }
}



static void add_right_angle(float angle)
{
  player.angle += angle;
  if (player.angle > M_PI) {
    player.angle = (player.angle - M_PI) - M_PI;
  }
}



static void restart_player(void)
{
  player.state = FLY;
  player.time = 0;
  player.ani_time = 0;
  player.x = GSCREEN_W/2;
  player.y = GSCREEN_H+16;
  player.z = 1.0;
  player.angle = -M_PI/2;
  player.speed = 32.0;
  player.food = 100;
}



void init_player(void)
{
  player.lifes = 3;
  player.lock = FALSE;
  player.score = 0;

  restart_player();
}



void shutdown_player(void)
{
}



int update_player(void)
{
  if (key[KEY_ESC])
    return TRUE;

  if (player.lifes < 0)
    return FALSE;

  /* change the angle */
  if (key[KEY_LEFT]) {
    add_left_angle((M_PI) / FPS);
  }
  if (key[KEY_RIGHT]) {
    add_right_angle((M_PI) / FPS);
  }

  /* the bird is very close of the sides... */

  /* left */
  if (player.x < 0) {
    if (player.angle > 0)
      add_left_angle((M_PI*2) / FPS);
    else if (player.angle < 0)
      add_right_angle((M_PI*2) / FPS);
  }
  /* right */
  else if (player.x >= GSCREEN_W) {
    if (player.angle < 0)
      add_left_angle((M_PI*2) / FPS);
    else if (player.angle > 0)
      add_right_angle((M_PI*2) / FPS);
  }
  /* top */
  else if (player.y < 0) {
    if (player.angle < 0) {
      if (player.angle < -M_PI/2)
        add_left_angle((M_PI*2) / FPS);
      else
        add_right_angle((M_PI*2) / FPS);
    }
    else if (player.angle > 0) {
      if (player.angle > M_PI/2)
        add_left_angle((M_PI*2) / FPS);
      else
        add_right_angle((M_PI*2) / FPS);
    }
  }
  /* bottom */
  else if (player.y >= GSCREEN_H) {
    if (player.angle < 0) {
      if (player.angle > -M_PI/2)
        add_left_angle((M_PI*2) / FPS);
      else
        add_right_angle((M_PI*2) / FPS);
    }
    else if (player.angle > 0) {
      if (player.angle < M_PI/2)
        add_left_angle((M_PI*2) / FPS);
      else
        add_right_angle((M_PI*2) / FPS);
    }
  }

  /* animation control */
  player.ani_time++;
  if (player.ani_time > FPS/2)
    player.ani_time = 0;

  /* in the air */
  if (player.state != WALK) {
    /* speed up */
    if (key[KEY_UP]) {
      if (player.speed < 128.0) {
        player.speed += 64.0 / FPS;
        if (player.speed > 128.0)
          player.speed = 128.0;
      }
    }
    /* slow down */
    else {
      if (player.speed > 32.0) {
        player.speed -= 64.0 / FPS;
        if (player.speed < 32.0)
          player.speed = 32.0;
      }
      /* no animation */
      else if (player.state == FLY)
        player.ani_time = 0;
    }

    /* shoot the shit */
    if (player.state == FLY) {
      if (key[KEY_LCONTROL] || key[KEY_SPACE]) {
        if (!player.lock) {
          player.lock = TRUE;
          if (player.food > 0) {
            player.food = MAX(0, player.food-10);
            add_shit(player.x, player.y);
          }
        }
      }
      else {
        player.lock = FALSE;
      }
    }
  }
  /* in the street */
  else {
    if (key[KEY_UP])
      player.speed = 32.0;
    else {
      player.speed = 0.0;
      player.ani_time = 0;
    }
  }

  /* change of place */
  if (key[KEY_ALT] || key[KEY_ENTER]) {
    if (player.state == FLY) {
      player.time = 0;
      player.state = DOWN;
    }
    else if (player.state == WALK) {
      player.time = 0;
      player.state = UP;
      player.speed = 64.0;
    }
  }

  /* down to the street */
  if (player.state == DOWN) {
    player.z -= 0.25 / FPS;
    if (player.z < FLOOR_Z) {
      player.z = FLOOR_Z;

      player.time = 0;
      player.state = WALK;
    }
  }

  /* up to the air */
  if (player.state == UP) {
    player.z += 0.25 / FPS;
    if (player.z > 1.0) {
      player.z = 1.0;

      player.time = 0;
      player.state = FLY;
    }
  }

  /* move the bird */
  player.x += cos(player.angle) * player.speed/FPS;
  player.y += sin(player.angle) * player.speed/FPS;

  /* in the street */
  if (player.state == WALK) {
    int x, y;

    /* position of the bird */
    x = GSCREEN_W/2 + (player.x - GSCREEN_W/2) * player.z;
    y = GSCREEN_H/2 + (player.y - GSCREEN_H/2) * player.z;

    /* collision with the cars */
    if (hit_auto(x-4, y-4, x+4, y+4)) {
      /* add the blood */
      add_blood_squirt(x, y, 16.0);
      /* one life less */
      player.lifes--;
      /* kill the player */
      restart_player();
    }
    /* eat food in the street */
    else
      player.food += eat_food(x, y);
  }

  return FALSE;
}



void draw_player(BITMAP *bmp, int first)
{
  BITMAP *sprite, *shadow;
  int x, y;

  if (player.lifes < 0)
    return;

  if (player.state == WALK) {
    if (!first)
      return;
  }
  else {
    if (first)
      return;
  }

  /* sprite to draw */
  if (player.ani_time < FPS*1/8)
    sprite = the_bitmaps[BIRD1_PCX];
  else if (player.ani_time < FPS*2/8)
    sprite = the_bitmaps[BIRD2_PCX];
  else if (player.ani_time < FPS*3/8)
    sprite = the_bitmaps[BIRD1_PCX];
  else
    sprite = the_bitmaps[BIRD3_PCX];

  shadow = create_bitmap(sprite->w, sprite->h);
  text_mode(0);
  draw_character(shadow, sprite, 0, 0, makecol(0, 0, 0));

  /* draw the shadow */
  x = GSCREEN_W/2 + (player.x - GSCREEN_W/2) * FLOOR_Z;
  y = GSCREEN_H/2 + (player.y - GSCREEN_H/2) * FLOOR_Z;

  pivot_scaled_sprite(bmp, shadow, x, y, sprite->w/2, sprite->h/2,
    ftofix(64.0+128.0*player.angle/M_PI),
    ftofix(0.5));

  /* draw the bird */
  x = GSCREEN_W/2 + (player.x - GSCREEN_W/2) * player.z;
  y = GSCREEN_H/2 + (player.y - GSCREEN_H/2) * player.z;

  pivot_scaled_sprite(bmp, sprite, x, y, sprite->w/2, sprite->h/2,
    ftofix(64.0+128.0*player.angle/M_PI),
    ftofix(0.5 + 0.5 * (player.z - FLOOR_Z) / (1.0 - FLOOR_Z)));

  destroy_bitmap(shadow);
}



int get_player_lifes(void)
{
  return player.lifes;
}



int get_player_food(void)
{
  return player.food;
}



int get_player_score(void)
{
  return player.score;
}



void add_player_score(int score)
{
  player.score += score;
}


