/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "linklist.h"



/* gets the next item of some other */
#define NEXT(item, size) \
  ((void *)(*((int *)(((char *)(item))+((int)(size))))))



/* creates an empty linked-list */
LINKLIST *create_linklist(int itemsize)
{
  LINKLIST *list;

  list = malloc(sizeof(LINKLIST));
  if (list) {
    list->size = itemsize;
    list->used = NULL;
    list->free = NULL;
  }

  return list;
}



/* deletes all the items (used and frees) of the linked-list */
void delete_linklist(LINKLIST *list)
{
  void *iter, *next;

  /* remove the used items list */
  for (iter=list->used; iter; iter=next) {
    next = NEXT(iter, list->size);
    free(iter);
  }

  /* remove the free list */
  for (iter=list->free; iter; iter=next) {
    next = NEXT(iter, list->size);
    free(iter);
  }

  /* remove the list */
  free(list);
}



/* inserts a new item in the linked-list (will try to get some free item
   from the free list) */
void *insert_linkitem(LINKLIST *list)
{
  void *used = list->used;

  /* we can exchange one free item to the used items */
  if (list->free) {
    list->used = list->free;
    list->free = NEXT(list->free, list->size);
  }
  /* create a new one */
  else {
    list->used = malloc(list->size+sizeof(void *));
  }

  NEXT(list->used, list->size) = used;
  return list->used;
}



/* removes one item from the list, really, this function exchange the
   item to the free list */
void remove_linkitem(LINKLIST *list, void *item)
{
  void *iter, *prev = NULL;
  void *free;

  for (iter=list->used; iter; iter=NEXT(iter, list->size)) {
    if (iter == item) {
      iter = NEXT(iter, list->size);

      if (prev)
        NEXT(prev, list->size) = iter;
      else
        list->used = iter;

      /* exchange the item from the used items to the free list */
      free = list->free;
      list->free = item;
      NEXT(list->free, list->size) = free;
      break;
    }
    prev = iter;
  }
}



/* gets the first item in the linked-list */
void *getfirst_linkitem(LINKLIST *list)
{
  return list->used;
}



/* gets the next item */
void *getnext_linkitem(LINKLIST *list, void *item)
{
  return NEXT(item, list->size);
}




