/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LEVEL_H
#define __LEVEL_H



#define FLOOR_Z         0.75

#define TILE_W          24
#define TILE_H          24

#define LEVEL_W         10
#define LEVEL_H         10

#define IDLE_TILE       1
#define CROSS_TILE      2
#define STREET_TILE     4
#define SIDEWALK_TILE   8
#define HAS_PERSON      16

#define LEFT_CORNER     (GSCREEN_W/2 - GSCREEN_W/2*FLOOR_Z)
#define TOP_CORNER      (0)



void init_level(void);
void shutdown_level(void);
void update_level(void);
void draw_level(BITMAP *bmp);

int get_level_tile(int x, int y);
void set_level_tile(int x, int y, int state);



#endif /* !__LEVEL_H */

