/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "data.h"
#include "game.h"
#include "level.h"



#define I IDLE_TILE  | SIDEWALK_TILE
#define C CROSS_TILE | SIDEWALK_TILE
#define S STREET_TILE
#define W SIDEWALK_TILE

static int level[LEVEL_H][LEVEL_W] =
{
  { W, W, S, S, S,   S, S, S, W, W },
  { W, C, S, S, S,   S, S, S, C, W },
  { I, C, S, S, S,   S, S, S, C, I },
  { I, C, S, S, S,   S, S, S, C, I },
  { I, C, S, S, S,   S, S, S, C, I },

  { I, C, S, S, S,   S, S, S, C, I },
  { I, C, S, S, S,   S, S, S, C, I },
  { I, C, S, S, S,   S, S, S, C, I },
  { W, C, S, S, S,   S, S, S, C, W },
  { W, W, S, S, S,   S, S, S, W, W }
};



void init_level(void)
{
}



void shutdown_level(void)
{
}



void update_level(void)
{
}



void draw_level(BITMAP *bmp)
{
  int x, y, x1, y1, x2, y2;

  /* draw the two sides */

  blit(the_bitmaps[LFTSIDE1_PCX], bmp, 0, 0, 0, 0,
    the_bitmaps[LFTSIDE1_PCX]->w, the_bitmaps[LFTSIDE1_PCX]->h);

  blit(the_bitmaps[RGTSIDE1_PCX], bmp, 0, 0,
    GSCREEN_W - the_bitmaps[RGTSIDE1_PCX]->w, 0,
    the_bitmaps[RGTSIDE1_PCX]->w, the_bitmaps[RGTSIDE1_PCX]->h);

  /* draw the street */

  for (y=0; y<LEVEL_H; y+=2)
    blit(the_bitmaps[STREET1_PCX], bmp, 0, 0,
         GSCREEN_W/2 - GSCREEN_W/2*FLOOR_Z + 2*TILE_W,
         y*TILE_H,
         the_bitmaps[STREET1_PCX]->w,
         the_bitmaps[STREET1_PCX]->h);

  /* draw the sidewalk */

  for (y=0; y<LEVEL_H; y++)
    for (x=0; x<LEVEL_W; x++) {
      if ((x < 2) || (x > LEVEL_W-3))
        blit(the_bitmaps[FLOOR1_PCX], bmp, 0, 0,
          GSCREEN_W/2 - GSCREEN_W/2*FLOOR_Z + x*TILE_W,
          y*TILE_H, TILE_W, TILE_H);
    }
}



int get_level_tile(int x, int y)
{
  if ((x < 0) || (y < 0) || (x >= LEVEL_W) || (y >= LEVEL_H))
    return 0;
  else
    return level[y][x];
}



void set_level_tile(int x, int y, int state)
{
  if ((x < 0) || (y < 0) || (x >= LEVEL_W) || (y >= LEVEL_H))
    return;

  if (state)
    level[y][x] |= HAS_PERSON;
  else
    level[y][x] &= ~HAS_PERSON;
}


