/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include <allegro/internal/aintern.h>
#include "game.h"
#include "ilegal.h"
#include "mymath.h"

#include "intro1.c"
#include "intro2.c"
#include "intro3.c"
#include "logo1.c"
#include "peace1.c"



static void init_intro(void);
static void shutdown_intro(void);
static int update_intro(void);
static void draw_intro(BITMAP *bmp);



static int count = 0;

static void count_inc(void)
{
  count++;
}

END_OF_STATIC_FUNCTION(count_inc);



void play_intro(void)
{
  BITMAP *buffer = create_bitmap(GSCREEN_W, GSCREEN_H);
  int gameover = FALSE;

  /* initialise everything */
  init_intro();

  LOCK_VARIABLE(count);
  LOCK_FUNCTION(count_inc);

  count = 0;
  install_int_ex(count_inc, BPS_TO_TIMER(FPS));

  /* introduction loop */
  while (!gameover) {
    while ((count > 0) && (!gameover)) {
      poll_keyboard();
      gameover = update_intro();
      count--;
    }

    draw_intro(buffer);

    /* copy the `buffer' to the screen */
    if ((SCREEN_W == GSCREEN_W) && (SCREEN_H == GSCREEN_H))
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    else
      stretch_blit(buffer, screen,
        0, 0, GSCREEN_W, GSCREEN_H,
        0, 0, SCREEN_W, SCREEN_H);
  }

  shutdown_intro();
}



static BITMAP *face1, *face2, *bird, *logo, *peace;
static int intro_time, intro_done;

#define _1ST   0
#define _2ND   3

static int time_slide[] =
{
  /* 1st */
  FPS*2,
  FPS*2,
  FPS*2,
  /* 2nd */
  FPS*2,
  FPS*1,
  FPS*1,
  FPS/2,
  FPS*8,
  FPS*1,
  FPS*1,
  FPS*8,
  -1
};



static void init_intro(void)
{
  intro_time = 0;
  intro_done = FALSE;
  
  face1 = array_to_bmp(intro2_pcx);
  face2 = array_to_bmp(intro1_pcx);
  bird = array_to_bmp(intro3_pcx);
  logo = array_to_bmp(logo1_pcx);
  peace = array_to_bmp(peace1_pcx);

  clear_keybuf();
}



static void shutdown_intro(void)
{
  int c;

  destroy_bitmap(face1);
  destroy_bitmap(face2);
  destroy_bitmap(bird);
  destroy_bitmap(logo);
  destroy_bitmap(peace);

  clear_keybuf();

  for (c=0; c<KEY_MAX; c++) {
    key[c] = 0;
    _key[c] = 0;
  }
}



static int update_intro(void)
{
  if (keypressed())
    return TRUE;

  intro_time++;
  return FALSE;
}



static int draw_text(BITMAP *bmp, const char *text, int x, int y)
{
  text_mode(-1);
  textout(bmp, font, text, x+1, y, makecol(0, 0, 0));
  textout(bmp, font, text, x-1, y, makecol(0, 0, 0));
  textout(bmp, font, text, x, y-1, makecol(0, 0, 0));
  textout(bmp, font, text, x, y+1, makecol(0, 0, 0));
  textout(bmp, font, text, x, y, makecol(255, 255, 255));
  return text_height(font)+2;
}



static void draw_intro(BITMAP *bmp)
{
  int key, time, old_time;
  float scale;

  if (intro_done)
    return;

  time = 0;
  for (key=0; ; key++) {
    if (time_slide[key] < 0) {
      intro_done = TRUE;
      return;
    }

    old_time = time;
    time += time_slide[key];
    if (intro_time < time) {
      scale = (float)(intro_time - old_time)
            / (float)(time - old_time);
      break;
    }
  }

  clear_to_color(bmp, makecol(0, 224, 255));

  switch (key) {

    case _1ST+0:
    case _1ST+1:
    case _1ST+2:
      masked_blit(peace, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);

      if (key >= _1ST+1)
        draw_text(bmp, "Save the donkeys",
          GSCREEN_W/2 - 16*8/2, GSCREEN_H/2-32);

      if (key == _1ST+2)
        draw_text(bmp, "Don't play to Donkey Bolonkey",
          GSCREEN_W/2 - 29*8/2, GSCREEN_H/2+32);
      break;

    case _2ND+0:
      masked_blit(face1, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
      break;

    case _2ND+1:
      masked_blit(face1, bmp, 0, 0, GSCREEN_W*scale, 0, GSCREEN_W, GSCREEN_H);
      break;

    case _2ND+2:
      masked_blit(face2, bmp, 0, 0, -GSCREEN_W*(1.0-scale), 0, GSCREEN_W, GSCREEN_H);
      break;

    case _2ND+3:
      masked_blit(face2, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
      masked_blit(logo, bmp, 0, 0,
        GSCREEN_W*scale-logo->w, GSCREEN_H-logo->h, GSCREEN_W, GSCREEN_H);
      break;

    case _2ND+4:
      {
        float angle, length;
        int x, y;
        angle = scale*M_PI*2.0;
        length = 32.0;
        x = 48 + cos(angle)*length;
        y = 48 + sin(angle)*length;
        rotate_sprite(bmp, bird, x, y, ftofix(128.0*angle/M_PI));
      }

      masked_blit(face2, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
      masked_blit(logo, bmp, 0, 0, GSCREEN_W-logo->w, GSCREEN_H-logo->h, GSCREEN_W, GSCREEN_H);
      break;

    case _2ND+5:
      masked_blit(face2, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
      masked_blit(logo, bmp, 0, 0, GSCREEN_W-logo->w, GSCREEN_H-logo->h, GSCREEN_W, GSCREEN_H);
      draw_text(bmp, "S.F.H.", GSCREEN_W-256*scale, 4);
      break;

    case _2ND+6:
      masked_blit(face2, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
      masked_blit(logo, bmp, 0, 0, GSCREEN_W-logo->w, GSCREEN_H-logo->h, GSCREEN_W, GSCREEN_H);
      draw_text(bmp, "S.F.H.", GSCREEN_W-256, 4);
      draw_text(bmp, "- Shit From Heaven", GSCREEN_W+(-256+7*8)*scale, 4);
      break;

    case _2ND+7:
      {
        int y;

        masked_blit(face2, bmp, 0, 0, 0, 0, GSCREEN_W, GSCREEN_H);
        masked_blit(logo, bmp, 0, 0, GSCREEN_W-logo->w, GSCREEN_H-logo->h, GSCREEN_W, GSCREEN_H);
        draw_text(bmp, "S.F.H.", GSCREEN_W-256, 4);
        draw_text(bmp, "- Shit From Heaven", GSCREEN_W+(-256+7*8), 4);

        y = GSCREEN_H-(GSCREEN_H-32)*scale;
        y += draw_text(bmp, "Idea:", 2, y);
        y += draw_text(bmp, "Martin Capello", 32, y);

        y += 4;

        y += draw_text(bmp, "Graphics:", 2, y);
        y += draw_text(bmp, "David Capello", 32, y);
        y += draw_text(bmp, "Martin Capello made the bird", 32, y);
        y += draw_text(bmp, "and helps with the design of", 32, y);
        y += draw_text(bmp, "the other images", 32, y);

        y += 4;

        y += draw_text(bmp, "Programming:", 2, y);
        y += draw_text(bmp, "David Capello", 32, y);
        y += draw_text(bmp, "Martin Capello made the", 32, y);
        y += draw_text(bmp, "routines to convert graphics", 32, y);
      }
      break;
  }
}



