/* ilegal - routines to break SpeedHack rules :-)
 * Copyright (C) 2002 Martin Capello
 */

#include <stdio.h>
#include <string.h>
#include <allegro.h>

#define ADJ_OFFSET 32

int bmp_palette_to_array(const char *filebmp, const char *filename, const char *arrayname)
{
 FILE *file;
 BITMAP *bmp;
 PALETTE pal;
 int i, j;
 
 bmp = load_bitmap(filebmp, pal);
 if(!bmp) return -1;
 destroy_bitmap(bmp);
 
 file = fopen(filename, "w");
 if(!file) return -1;
 fprintf(file, "PALETTE %s =\n{\n", arrayname);

 for(i=0; i<64; i++){
  for(j=0; j<4; j++){
     fprintf(file, "  {%3d,%3d,%3d, 0 }%s%s",
       pal[i*4+j].r, pal[i*4+j].g, pal[i*4+j].b,
       (i*4+j != 255)? ",": "",
       (j == 3)? "\n": "");
  }
 }

 fprintf(file, "};\n");
 fclose(file);

 return 0;
}

int bmp_to_array(const char *filebmp, const char *filename, const char *arrayname)
{
 FILE *file;
 BITMAP *bmp;
 int x, y;
 
 bmp = load_bitmap(filebmp, NULL);
 if(!bmp) return -1;

 file = fopen(filename, "w");
 if(!file) return -1;

 fprintf(file, "static const char *%s[] =\n{\n", arrayname);
 fprintf(file, "  \"%d %d\"", bmp->w, bmp->h);

 for(y=0; y<bmp->h; y++){
  fprintf(file, ",\n  \"");
  for(x=0; x<bmp->w; x++) {
   if (bmp->line[y][x]+ADJ_OFFSET == '\"')
     fputs("\\\"", file);
   else if (bmp->line[y][x]+ADJ_OFFSET == '\\')
     fputs("\\\\", file);
   else
     fputc(bmp->line[y][x]+ADJ_OFFSET, file);
  }
  fprintf(file, "\"");
 }

 fprintf(file, "\n};\n");
 fclose(file);
 
 destroy_bitmap(bmp);
 return 0;
}

BITMAP *array_to_bmp(const char *array[])
{
 BITMAP *bmp;
 int x, y, w, h;
 char *s = (char *)array[0];

 w = strtol(s, &s, 10);
 h = strtol(s, NULL, 10);
 bmp = create_bitmap(w, h);
 if(!bmp) return NULL;

 for(y=0; y<bmp->h; y++)
  for(x=0; x<bmp->w; x++)
   bmp->line[y][x] = (array[y+1][x] == 32)? 0: array[y+1][x]-ADJ_OFFSET;

 return bmp;
}

