/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "blood.h"
#include "car.h"
#include "food.h"
#include "game.h"
#include "level.h"
#include "people.h"
#include "player.h"
#include "scorer.h"
#include "shit.h"



static int count = 0;

static void count_inc(void)
{
  count++;
}

END_OF_STATIC_FUNCTION(count_inc);



static void screenshot(void)
{
  char buf[256];
  PALETTE pal;
  BITMAP *bmp;
  int c;

  get_palette(pal);

  for (c=0; c<10000; c++) {
    usprintf(buf, "shot%04d.pcx", c);
    if (!exists(buf))
      break;
  }

  bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
  save_bitmap(buf, bmp, pal);
  destroy_bitmap(bmp);
}



void play_game(void)
{
  BITMAP *buffer = create_bitmap(GSCREEN_W, GSCREEN_H);
  int gameover = FALSE;

  /* initialise everything */
  init_level();
  init_food();
  init_blood();
  init_people();
  init_car();
  init_shit();
  init_player();
  init_scorer();

  LOCK_VARIABLE(count);
  LOCK_FUNCTION(count_inc);

  count = 0;
  install_int_ex(count_inc, BPS_TO_TIMER(FPS));

  /* main game loop */
  while (!gameover) {
    while ((count > 0) && (!gameover)) {
      poll_keyboard();

      /* update game-objects */
      update_level();
      update_food();
      update_blood();
      update_people();
      update_car();
      update_shit();
      gameover =
      update_player();
      update_scorer();

      count--;
    }

    /* draw all elements */
    draw_level(buffer);
    draw_food(buffer);
    draw_shit(buffer, TRUE);
    draw_player(buffer, TRUE);
    draw_people(buffer, TRUE);
    draw_people(buffer, FALSE);
    draw_blood(buffer);
    draw_car(buffer);
    draw_shit(buffer, FALSE);
    draw_player(buffer, FALSE);
    draw_scorer(buffer);

    /* copy the `buffer' to the screen */
    if ((SCREEN_W == GSCREEN_W) && (SCREEN_H == GSCREEN_H))
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    else
      stretch_blit(buffer, screen,
        0, 0, GSCREEN_W, GSCREEN_H,
        0, 0, SCREEN_W, SCREEN_H);

    /* make a screen shot */
    if (key[KEY_F12]) {
      int saved = count;
      screenshot();
      do {
        poll_keyboard();
      } while (key[KEY_F12]);
      count = saved;
    }
  }

  /* remove everything */
  shutdown_level();
  shutdown_food();
  shutdown_blood();
  shutdown_people();
  shutdown_car();
  shutdown_shit();
  shutdown_player();
  shutdown_scorer();
}



