/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "food.h"
#include "game.h"
#include "level.h"
#include "linklist.h"
#include "mymath.h"



typedef struct FOOD
{
  int x, y;
} FOOD;

static LINKLIST *comida;



void init_food(void)
{
  int c, x, y;

  comida = create_linklist(sizeof(FOOD));

  for (c=0; c<8; c++) {
    x = LEFT_CORNER + 2*TILE_W + (rand() % ((LEVEL_W-4)*TILE_W));
    y = rand() % GSCREEN_H;
    shoot_food(x, y);
  }
}



void shutdown_food(void)
{
  delete_linklist(comida);
}



void update_food(void)
{
  /* do nothing */
}



void draw_food(BITMAP *bmp)
{
  FOOD *food;

  for (food=getfirst_linkitem(comida); food;
       food=getnext_linkitem(comida, food)) {
    putpixel(bmp, food->x, food->y, makecol(255, 255, 0));
  }
}



int eat_food(int x, int y)
{
  FOOD *food, *next;
  int count = 0;
  int w, h;

  for (food=getfirst_linkitem(comida); food; food=next) {
    next = getnext_linkitem(comida, food);

    w = ABS(x - food->x);
    h = ABS(y - food->y);
    if (MAX(w, h) < 8) {
      count += 5;
      remove_linkitem(comida, food);
    }
  }

  return count;
}



void shoot_food(int x, int y)
{
  float angle, length;
  FOOD *food;
  int c;

  for (c=0; c<32; c++) {
    food = insert_linkitem(comida);

    angle = (2.0*M_PI) * (rand() % 1000) / (1000.0);
    length = (32.0) * (rand() % 1000) / (1000.0);

    food->x = x + cos(angle)*length;
    food->y = y + sin(angle)*length;
  }
}


