/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "data.h"
#include "ilegal.h"

/* the palette */
#include "the_pal.c"

/* the bitmaps */
#include "bird1.c"
#include "bird2.c"
#include "bird3.c"
#include "body1_1.c"
#include "body1_2.c"
#include "body1_3.c"
#include "car1.c"
#include "car2.c"
#include "floor1.c"
#include "head1_l.c"
#include "head1_n.c"
#include "lftside1.c"
#include "rgtside1.c"
#include "shit1.c"
#include "street1.c"

BITMAP *the_bitmaps[THE_BITMAPS];



int load_data(void)
{
  set_palette(the_palette);

  the_bitmaps[BIRD1_PCX] = array_to_bmp(bird1_pcx);
  the_bitmaps[BIRD2_PCX] = array_to_bmp(bird2_pcx);
  the_bitmaps[BIRD3_PCX] = array_to_bmp(bird3_pcx);
  the_bitmaps[BODY1_1_PCX] = array_to_bmp(body1_1_pcx);
  the_bitmaps[BODY1_2_PCX] = array_to_bmp(body1_2_pcx);
  the_bitmaps[BODY1_3_PCX] = array_to_bmp(body1_3_pcx);
  the_bitmaps[CAR1_PCX] = array_to_bmp(car1_pcx);
  the_bitmaps[CAR2_PCX] = array_to_bmp(car2_pcx);
  the_bitmaps[FLOOR1_PCX] = array_to_bmp(floor1_pcx);
  the_bitmaps[HEAD1_L_PCX] = array_to_bmp(head1_l_pcx);
  the_bitmaps[HEAD1_N_PCX] = array_to_bmp(head1_n_pcx);
  the_bitmaps[LFTSIDE1_PCX] = array_to_bmp(lftside1_pcx);
  the_bitmaps[RGTSIDE1_PCX] = array_to_bmp(rgtside1_pcx);
  the_bitmaps[SHIT1_PCX] = array_to_bmp(shit1_pcx);
  the_bitmaps[STREET1_PCX] = array_to_bmp(street1_pcx);
  return 0;
}



void unload_data(void)
{
  int c;

  for (c=0; c<THE_BITMAPS; c++)
    destroy_bitmap(the_bitmaps[c]);
}




