/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "car.h"
#include "data.h"
#include "food.h"
#include "game.h"
#include "level.h"
#include "linklist.h"



#define TAXI    1
#define TRUCK   2
#define TYPES   3

#define TYPE2BMP(type) \
  (the_bitmaps[(((type) == 0)? CAR1_PCX: CAR2_PCX)])


typedef struct CAR
{
  int type;
  int time;
  int left;
  int x, y;
  int beg_y;
  float dy;
} CAR;

static LINKLIST *autos;
static int more_autos_time;

static int car_count;
static int lock_count;




void init_car(void)
{
  autos = create_linklist(sizeof(CAR));
  more_autos_time = 0;

  car_count = 0;
  lock_count = 0;
}



void shutdown_car(void)
{
  delete_linklist(autos);
}



void update_car(void)
{
  CAR *car, *next;
  int remove;

  for (car=getfirst_linkitem(autos); car; car=next) {
    next = getnext_linkitem(autos, car);

    car->time++;
    car->y = car->beg_y + car->dy*car->time/FPS;

    remove = FALSE;

    if (car->left) {
      if (car->y >= GSCREEN_H)
        remove = TRUE;
    }
    else {
      if (car->y <= -TYPE2BMP(car->type)->h)
        remove = TRUE;
    }

    if (remove) {
      car_count--;
      remove_linkitem(autos, car);
    }
    else {
      if (car->type == TRUCK) {
        if ((rand() & 15) == 1)
          shoot_food(car->x + TYPE2BMP(car->type)->w/2,
                     car->y + TYPE2BMP(car->type)->h/2);
      }
    }
  }

  /* insert more cars */
  more_autos_time++;
  if (more_autos_time > FPS*4) {
    if (lock_count == 0)
      add_auto(rand() & 1);
  }
}



void draw_car(BITMAP *bmp)
{
  CAR *car;

  for (car=getfirst_linkitem(autos); car;
       car=getnext_linkitem(autos, car)) {
    /* draw the car */
    ((car->left)? draw_sprite: draw_sprite_v_flip)
      (bmp, TYPE2BMP(car->type), car->x, car->y);
  }
}



void add_auto(int left)
{
  CAR *car;

  car = insert_linkitem(autos);

  car->type = rand() % TYPES;
  car->time = 0;
  car->left = left;

  if (car->left) {
    car->x = LEFT_CORNER + TILE_W*2.0 + TILE_W*0.3;
    car->y = car->beg_y = -TYPE2BMP(car->type)->h - GSCREEN_H;
    car->dy = 240.0;
  }
  else {
    car->x = LEFT_CORNER + TILE_W*6.0 - TILE_W*0.6;
    car->y = car->beg_y = GSCREEN_H*2;
    car->dy = -240.0;
  }

  more_autos_time = 0;
  car_count++;
}



int get_auto(void)
{
  return car_count;
}



void lock_autos(void)
{
  lock_count++;
}



void unlock_autos(void)
{
  lock_count--;
}



int hit_auto(int x1, int y1, int x2, int y2)
{
  CAR *car;

  for (car=getfirst_linkitem(autos); car;
       car=getnext_linkitem(autos, car)) {
    if ((car->x < x2) && (car->x+TYPE2BMP(car->type)->w > x1) &&
        (car->y < y2) && (car->y+TYPE2BMP(car->type)->h > y1))
      return (car->left)? +1: -1;
  }

  return 0;
}


