/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "game.h"
#include "linklist.h"
#include "mymath.h"



typedef struct BLOOD
{
  int time;
  int x, y;
  float beg_x, beg_y;
  float lin_x, lin_y;
} BLOOD;

static LINKLIST *sangre;



void init_blood(void)
{
  sangre = create_linklist(sizeof(BLOOD));
}



void shutdown_blood(void)
{
  delete_linklist(sangre);
}



void update_blood(void)
{
  BLOOD *blood, *next;

  for (blood=getfirst_linkitem(sangre); blood; blood=next) {
    next = getnext_linkitem(sangre, blood);

    blood->time++;
    if (blood->time > FPS*2) {
      remove_linkitem(sangre, blood);
    }
    else if (blood->time < FPS/4) {
      blood->x = blood->beg_x + blood->lin_x*blood->time/(FPS/4);
      blood->y = blood->beg_y + blood->lin_y*blood->time/(FPS/4);
    }
  }
}



void draw_blood(BITMAP *bmp)
{
  BLOOD *blood;

  for (blood=getfirst_linkitem(sangre); blood;
       blood=getnext_linkitem(sangre, blood)) {
    rectfill(bmp,
      blood->x, blood->y,
      blood->x+1, blood->y+1, makecol(255, 0, 0));
  }
}



void add_blood_squirt(int x, int y, float dist)
{
  BLOOD *blood;
  float angle;
  float length;
  int c;

  for (c=0; c<32; c++) {
    blood = insert_linkitem(sangre);
    blood->time = 0;

    angle = (2.0*M_PI) * (rand() % 1000) / (1000.0);
    length = (dist) * (rand() % 1000) / (1000.0);

    blood->beg_x = x + cos(angle)*length/8.0;
    blood->beg_y = y + sin(angle)*length/8.0;
    blood->lin_x = cos(angle)*length;
    blood->lin_y = sin(angle)*length;

    blood->x = blood->beg_x;
    blood->y = blood->beg_y;
  }
}


