/*******************************
 * Serpinsky's Triangle
 * by Ender Wiggin
 * See readme.txt for more
 * information about the effect
 *******************************/

#include <allegro.h>

typedef struct {
	int x, y;
} PointType;

int main()
{
	PointType points[3];
	PointType pos;
	int curr_point;
	int screenw, screenh, fullscreen;
	RGB background_color;
	RGB foreground_color;

	srand(time(NULL));

	allegro_init();

	set_config_file("serpinsky.ini");

	install_keyboard();
	install_mouse();

	fullscreen = get_config_int("screen", "fullscreen", 1);
	screenw = get_config_int("screen", "screenw", 640);
	screenh = get_config_int("screen", "screenh", 480);
	if (set_gfx_mode(fullscreen?GFX_DIRECTX:GFX_DIRECTX_WIN, screenw, screenh, 0, 0) != 0) {
		allegro_message("Error setting graphics mode!");
		allegro_exit();
		return 1;
	}

	pos.x = SCREEN_W / 2;
	pos.y = SCREEN_H / 2;

	points[0].x = get_config_int("points", "point_1_x", SCREEN_W/2);
	points[0].y = get_config_int("points", "point_1_y", 0);
	points[1].x = get_config_int("points", "point_2_x", 0);
	points[1].y = get_config_int("points", "point_2_y", SCREEN_H);
	points[2].x = get_config_int("points", "point_3_x", SCREEN_W);
	points[2].y = get_config_int("points", "point_3_y", SCREEN_H);

	foreground_color.r = get_config_int("colors", "foreground_color_r", 63);
	foreground_color.g = get_config_int("colors", "foreground_color_g", 63);
	foreground_color.b = get_config_int("colors", "foreground_color_b", 63);
	background_color.r = get_config_int("colors", "background_color_r", 0);
	background_color.g = get_config_int("colors", "background_color_g", 0);
	background_color.b = get_config_int("colors", "background_color_b", 0);

	set_color(0, &background_color);
	set_color(1, &foreground_color);

	while(!keypressed()) {
		curr_point = rand()%3;
		pos.x = (int)((pos.x + points[curr_point].x) / 2);
		pos.y = (int)((pos.y + points[curr_point].y) / 2);
		putpixel(screen, pos.x, pos.y, 1);
	}

	allegro_exit();
	return 0;
}
END_OF_MAIN();
