#ifndef _RM_STAR_VM_H_
#define _RM_STAR_VM_H_

#define MAX_CODE 768
#define MAX_STACK 64

#define INSN_NOP 0
#define INSN_END 1
#define INSN_YIELD 2
#define INSN_PUSHTIME 3
#define INSN_PUSHX 4
#define INSN_PUSHY 5
#define INSN_POPX 6
#define INSN_POPY 7
#define INSN_PUSH 8
#define INSN_POP 9
#define INSN_ADD 10
#define INSN_SUB 11
#define INSN_MUL 12
#define INSN_DIV 13
#define INSN_MOD 14
#define INSN_SIN 15
#define INSN_COS 16
#define INSN_RAND 17
#define INSN_AJZ 18
#define INSN_RJZ 19
#define INSN_PUSHD 20
#define INSN_POPD 21
#define INSN_PUSHIP 22
#define INSN_PEEK 23
#define INSN_POKE 24
#define INSN_PUSHW 25
#define INSN_PUSHH 26
#define INSN_NEG 27

#define INSN_COUNT 28

extern const char *insn_name[INSN_COUNT];

typedef struct {
  char *name;
  int x;
  int y;
  int data;
  int ip;
  int sp;
  int code[MAX_CODE];
  int stack[MAX_STACK];
} THREAD;

THREAD *create_thread(const char *name);
void destroy_thread(THREAD*);
void run_thread(THREAD*,int,int);

#endif
