#include <malloc.h>
#include <allegro.h>
#include "colors.h"
#include "swscroll.h"

static const char *scroller_text[]={
   "A long time ago, at an installation",
   " far, far away... ",
   NULL,
   "It is a time of intra-system war, as",
   "forces of the User Alliance struggle",
   "to break the iron grip of the evil",
   "Admin Empire. Now, striking from a",
   "hidden directory, they win their first",
   "victory.",
   NULL,
   "During the battle, User spies manage",
   "to snarf source of the Empire's",
   "ultimate weapon; the dreaded `rm-star',",
   "a privileged root program with the",
   "power to destroy an entire file system",
   "at a keystroke.",
   NULL,
   "Now, hotly pursued by the Empire's",
   "sinister audit trail, Princess LA36",
   "races aboard her shellscript."
};

SWSCROLLER *create_swscroller()
{
  const int yellow=makecol(255,255,0);
  SWSCROLLER *swscroller = (SWSCROLLER*)malloc(sizeof(SWSCROLLER));
  int y = 0;
  int dy = 16;
  unsigned int n;

  swscroller->tick=0;
  swscroller->bitmap=create_bitmap(256,1024); // large
  clear_to_color(swscroller->bitmap,background_color());
  swscroller->lasty = 0;

  for (n=0;n<sizeof(scroller_text)/sizeof(scroller_text[0]);++n) {
    if (scroller_text[n]) {
      textprintf_centre(
        swscroller->bitmap,font,swscroller->bitmap->w/2,y,yellow,
        scroller_text[n]
      );
    }
    y+=dy;
  }

  return swscroller;
}

void destroy_swscroller(SWSCROLLER *swscroller)
{
  free(swscroller);
}

int update_swscroller(SWSCROLLER *swscroller)
{
  BITMAP *dest = screen;

  float znear = 10.0f;
  float zfar = 30.0f;
  BITMAP *texture = swscroller->bitmap;
  int height = texture->h/2;
  float t = swscroller->tick/8.0f - height;
  V3D_f v1 = {SCREEN_W/4,   SCREEN_H/4, zfar,  0,          t,                0};
  V3D_f v2 = {SCREEN_W*3/4, SCREEN_H/4, zfar,  texture->w, t,                0};
  V3D_f v3 = {SCREEN_W,     SCREEN_H,   znear, texture->w, height+t+1, 0};
  V3D_f v4 = {0,            SCREEN_H,   znear, 0,          height+t+1, 0};

  ++swscroller->tick;
  quad3d_f(dest,POLYTYPE_PTEX,texture,&v1,&v2,&v3,&v4);
  //return height+t+1 < texture->h;
  return t<320;
}
