#include <stdio.h>
#include "actions.h"

#include <string.h>
#include <allegro.h>

#ifdef ALLEGRO_UNIX
#include <sys/stat.h>
#include <unistd.h>
#endif

#define BEGIN_SECTION "[rmstar_type_"
#define END_SECTION   "]"
#define ACTION_WEAPONS_SECTION "[rmstar_weapons]"

#define no_sound 0

extern char last_error[];

int graphic_mode = GFX_AUTODETECT;


int is_directory(const char *filename, int attr)
{
  return attr&FA_DIREC;
}



int is_executable(const char *filename, int attr)
{
#if (defined ALLEGRO_DOS) || (defined ALLEGRO_WINDOWS)
  static const char *extensions[] = {
    "exe",
    "com",
    "bat", /* DOS scripts */
    "btm"  /* 4DOS scripts */
  };
  const char *ext = get_extension(filename);
  unsigned int i;
  for (i=0; i<sizeof(extensions)/sizeof(extensions[0]); ++i) {
    if (ustricmp(ext, extensions[i])==0) {
      return 1;
    }
  }
  return 0;
#endif

#ifdef ALLEGRO_UNIX
  struct stat s;
  stat(filename, &s);
  return S_IXUSR & s.st_mode && !is_directory(filename, attr);
#endif
}



int init_actions(void)
{
  /* Pray hard that 1024 is enough... */
  static char tmp[1024];
  static char config_file[1024];
  static char dest[1024];
  static int path_found=0;
  static void *config_data;
  static long config_data_size;
  if (!path_found) {
    FILE *f;
    get_executable_name(tmp, sizeof(tmp));
    fix_filename_path(dest,tmp,1024);
    replace_filename(config_file, dest, "rmstar.cfg", sizeof(config_file));
    f=fopen(config_file,"rb");
    fseek(f,0,SEEK_END);
    config_data_size=ftell(f);
    fseek(f,0,SEEK_SET);
    config_data=malloc(config_data_size);
    fread(config_data,config_data_size,1,f);
    fclose(f);
    path_found=1;
  }
  override_config_data(config_data,config_data_size);
  return 1;
}



/* Ripped from the grabber */
static int my_system(const char *exe, const char *filename)
{
   int old_w = SCREEN_W;
   int old_h = SCREEN_H;
   int old_cdepth = screen->vtable->color_depth;
   int ret;
   char *cmd;


   #ifdef ALLEGRO_DOS
      /* fool Windows into noticing that the sound hardware is now free */
      if ((os_type == OSTYPE_WIN95) || (os_type == OSTYPE_WIN98))
         system("command.com /c");
   #endif

   cmd = malloc(ustrsize(exe)+ustrsizez(filename)+ustrsize("\"\" "));
   usprintf(cmd, "%s \"%s\"", exe, filename);
   allegro_exit();
   ret = system(cmd);
   free(cmd);

   #ifdef ALLEGRO_DOS
      /* bring our window back to the foreground */
      if ((os_type == OSTYPE_WIN95) || (os_type == OSTYPE_WIN98)) {
         __dpmi_regs r;
         r.x.ax = 0x168B;
         r.x.bx = 0;
         __dpmi_int(0x2F, &r);
      }
   #endif

   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();
   init_actions();

   set_color_depth(old_cdepth);
   //if (set_gfx_mode(GFX_AUTODETECT, old_w, old_h, 0, 0) != 0) {
   if (set_gfx_mode(graphic_mode, old_w, old_h, 0, 0) != 0) {
      set_gfx_mode(GFX_SAFE, 320, 200, 0, 0);
      alert(
         "bad, Bad, BAD error!", "Unable to restore the graphics mode...",
         NULL, "Shit", NULL, 13, 0
      );
   }

   if (no_sound) {
      install_sound(DIGI_NONE, MIDI_NONE, NULL);
   }
   else {
      if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
         alert(
            "bad, Bad, BAD error!", "Unable to reset the soundcard...",
            NULL, "Shit", NULL, 13, 0
         );
         install_sound(DIGI_NONE, MIDI_NONE, NULL);
      }
   }

   return ret;
}



const char *get_type(const char *filename, int attr)
{
  if (is_directory(filename, attr)) {
    return "|directory|";
  }
  else if (is_executable(filename, attr)) {
    return "|executable|";
  }
  else {
    const char *type = get_extension(filename);
    if (ustrlen(type)==0) {
      type = filename;
    }
    return type;
  }
}


char *create_section(const char *middle)
{
  char *section =
    malloc(ustrsizez(BEGIN_SECTION)+ustrsizez(middle)+ustrsizez(END_SECTION));
  if (section) {
    sprintf(section, "%s%s%s", BEGIN_SECTION, middle, END_SECTION);
  }
  return section;
}


const char *get_weapon_executable(int index)
{
  static char name[256];
  usprintf(name, "weapon%d", index);
  return get_config_string(ACTION_WEAPONS_SECTION, name, 0);
}



const char *get_collision_executable(const char *filename, int attr)
{
  const char *type = get_type(filename, attr);
  char *section = create_section(type);
  const char *ret = get_config_string(section, "action", 0);
  free(section);
  return ret;
}


const char *get_file_image(const char *filename, int attr)
{
  const char *type = get_type(filename, attr);
  char *section = create_section(type);
  const char *ret = get_config_string(section, "image", 0);
  free(section);
  return ret;
}


int get_file_color(const char *filename, int attr, int *r, int *g, int *b)
{
  const char *type = get_type(filename, attr);
  char *section = create_section(type);
  const char *config = get_config_string(section, "color", 0);
  int ret;
  free(section);
  if (!config) return 0;
  ret = sscanf(config, "%d %d %d", r, g, b);
  if (ret!=3) return 0;
  return 1;
}


int get_file_textcolor(const char *filename, int attr, int *r, int *g, int *b)
{
  const char *type = get_type(filename, attr);
  char *section = create_section(type);
  const char *config = get_config_string(section, "textcolor", 0);
  int ret;
  free(section);
  if (!config) return 0;
  ret = sscanf(config, "%d %d %d", r, g, b);
  if (ret!=3) return 0;
  return 1;
}



static int check_error(int err)
{
  if (err==0) {
    strcpy(last_error, "OK");
    return ACTION_OK;
  }
  strcpy(last_error, strerror(errno));
  return ACTION_KO;
}



int shoot_file(const char *filename, int weapon)
{
  const char *exe = get_weapon_executable(weapon);
  if (exe) {
    int ret = my_system(exe, filename);
    return check_error(ret);
  }
  strcpy(last_error, "No binding");
  return ACTION_KO;
}



int collide_file(const char *filename, int attr)
{
  int ret;
  if (is_executable(filename, attr)) {
    ret = my_system(filename, "");
    return check_error(ret);
  }
  else if (is_directory(filename, attr)) {
    ret = chdir(filename);
    return check_error(ret);
  }
  else {
    const char *exe = get_collision_executable(filename, attr);
    if (exe) {
      ret = my_system(exe, filename);
      return check_error(ret);
    }
  }
  strcpy(last_error, "No binding");
  return ACTION_KO;
}

