/* Ripped from: eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'COPYING' for details.
 */
#include "font.h"

//#include "debug.h"

#include <allegro.h>
#include <allegro/internal/aintern.h>


/* begin char 0x20, end char 0x80 */
static FONT_GLYPH g20={6, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};/*   */
static FONT_GLYPH g21={6, 8, {0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x00}};/* ! */
static FONT_GLYPH g22={6, 8, {0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00}};/* " */
static FONT_GLYPH g23={6, 8, {0x50,0x50,0xf8,0x50,0xf8,0x50,0x50,0x00}};/* # */
static FONT_GLYPH g24={6, 8, {0x20,0x78,0x80,0x70,0x08,0xf0,0x20,0x00}};/* $ */
static FONT_GLYPH g25={6, 8, {0x00,0x00,0x88,0x10,0x20,0x40,0x88,0x00}};/* % */
static FONT_GLYPH g26={6, 8, {0x30,0x48,0x30,0x64,0x98,0x90,0x6c,0x00}};/* & */
static FONT_GLYPH g27={6, 8, {0x20,0x20,0x40,0x00,0x00,0x00,0x00,0x00}};/* ' */
static FONT_GLYPH g28={6, 8, {0x10,0x20,0x40,0x40,0x40,0x20,0x10,0x00}};/* ( */
static FONT_GLYPH g29={6, 8, {0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x00}};/* ) */
static FONT_GLYPH g2a={6, 8, {0x00,0x48,0x30,0xfc,0x30,0x48,0x00,0x00}};/* * */
static FONT_GLYPH g2b={6, 8, {0x00,0x20,0x20,0xf8,0x20,0x20,0x00,0x00}};/* + */
static FONT_GLYPH g2c={6, 8, {0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x40}};/* , */
static FONT_GLYPH g2d={6, 8, {0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00}};/* - */
static FONT_GLYPH g2e={6, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00}};/* . */
static FONT_GLYPH g2f={6, 8, {0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00}};/* / */
static FONT_GLYPH g30={6, 8, {0x60,0x90,0x90,0x90,0x90,0x90,0x60,0x00}};/* 0 */
static FONT_GLYPH g31={6, 8, {0x20,0x60,0x20,0x20,0x20,0x20,0x20,0x00}};/* 1 */
static FONT_GLYPH g32={6, 8, {0x60,0x90,0x10,0x20,0x40,0x80,0xf0,0x00}};/* 2 */
static FONT_GLYPH g33={6, 8, {0x60,0x90,0x10,0x20,0x10,0x90,0x60,0x00}};/* 3 */
static FONT_GLYPH g34={6, 8, {0x10,0x30,0x50,0x90,0xf8,0x10,0x10,0x00}};/* 4 */
static FONT_GLYPH g35={6, 8, {0xf0,0x80,0xd0,0x10,0x10,0x90,0x60,0x00}};/* 5 */
static FONT_GLYPH g36={6, 8, {0x20,0x40,0x80,0xd0,0x90,0x90,0x60,0x00}};/* 6 */
static FONT_GLYPH g37={6, 8, {0xf0,0x90,0x10,0x20,0x40,0x40,0x40,0x00}};/* 7 */
static FONT_GLYPH g38={6, 8, {0x60,0x90,0x90,0x60,0x90,0x90,0x60,0x00}};/* 8 */
static FONT_GLYPH g39={6, 8, {0x60,0x90,0x90,0x70,0x10,0x20,0x40,0x00}};/* 9 */
static FONT_GLYPH g3a={6, 8, {0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00}};/* : */
static FONT_GLYPH g3b={6, 8, {0x00,0x00,0x20,0x00,0x00,0x20,0x20,0x40}};/* ; */
static FONT_GLYPH g3c={6, 8, {0x00,0x10,0x20,0x40,0x20,0x10,0x00,0x00}};/* < */
static FONT_GLYPH g3d={6, 8, {0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,0x00}};/* = */
static FONT_GLYPH g3e={6, 8, {0x00,0x40,0x20,0x10,0x20,0x40,0x00,0x00}};/* > */
static FONT_GLYPH g3f={6, 8, {0x70,0x88,0x10,0x20,0x20,0x00,0x20,0x00}};/* ? */
static FONT_GLYPH g40={6, 8, {0x70,0x88,0xb8,0xa8,0xb8,0x80,0x70,0x00}};/* @ */
static FONT_GLYPH g41={6, 8, {0x20,0x50,0x88,0x88,0xf8,0x88,0x88,0x00}};/* A */
static FONT_GLYPH g42={6, 8, {0xf0,0x88,0x88,0xf0,0x88,0x88,0xf0,0x00}};/* B */
static FONT_GLYPH g43={6, 8, {0x30,0x48,0x80,0x80,0x80,0x48,0x30,0x00}};/* C */
static FONT_GLYPH g44={6, 8, {0xe0,0x90,0x88,0x88,0x88,0x90,0xe0,0x00}};/* D */
static FONT_GLYPH g45={6, 8, {0xf8,0x80,0x80,0xf0,0x80,0x80,0xf8,0x00}};/* E */
static FONT_GLYPH g46={6, 8, {0xf8,0x80,0x80,0xf8,0x80,0x80,0x80,0x00}};/* F */
static FONT_GLYPH g47={6, 8, {0x30,0x48,0x80,0x80,0x98,0x48,0x30,0x00}};/* G */
static FONT_GLYPH g48={6, 8, {0x88,0x88,0x88,0xf8,0x88,0x88,0x88,0x00}};/* H */
static FONT_GLYPH g49={6, 8, {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00}};/* I */
static FONT_GLYPH g4a={6, 8, {0x08,0x08,0x08,0x08,0x88,0x88,0x70,0x00}};/* J */
static FONT_GLYPH g4b={6, 8, {0x88,0x88,0x90,0xe0,0x90,0x88,0x88,0x00}};/* K */
static FONT_GLYPH g4c={6, 8, {0x80,0x80,0x80,0x80,0x80,0x80,0xf8,0x00}};/* L */
static FONT_GLYPH g4d={6, 8, {0x88,0xd8,0xa8,0x88,0x88,0x88,0x88,0x00}};/* M */
static FONT_GLYPH g4e={6, 8, {0x88,0xc8,0xa8,0x98,0x88,0x88,0x88,0x00}};/* N */
static FONT_GLYPH g4f={6, 8, {0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00}};/* O */
static FONT_GLYPH g50={6, 8, {0xf0,0x88,0x88,0xf0,0x80,0x80,0x80,0x00}};/* P */
static FONT_GLYPH g51={6, 8, {0x70,0x88,0x88,0x88,0xa8,0x70,0x18,0x00}};/* Q */
static FONT_GLYPH g52={6, 8, {0xf0,0x88,0x88,0xf0,0x90,0x88,0x88,0x00}};/* R */
static FONT_GLYPH g53={6, 8, {0x70,0x88,0x80,0x70,0x08,0x88,0x70,0x00}};/* S */
static FONT_GLYPH g54={6, 8, {0xf8,0x20,0x20,0x20,0x20,0x20,0x20,0x00}};/* T */
static FONT_GLYPH g55={6, 8, {0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00}};/* U */
static FONT_GLYPH g56={6, 8, {0x88,0x88,0x88,0x88,0x50,0x50,0x20,0x00}};/* V */
static FONT_GLYPH g57={6, 8, {0x88,0x88,0x88,0x88,0x88,0xa8,0x50,0x00}};/* W */
static FONT_GLYPH g58={6, 8, {0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00}};/* X */
static FONT_GLYPH g59={6, 8, {0x88,0x88,0x50,0x20,0x20,0x20,0x20,0x00}};/* Y */
static FONT_GLYPH g5a={6, 8, {0xf8,0x08,0x10,0x20,0x40,0x80,0xf8,0x00}};/* Z */
static FONT_GLYPH g5b={6, 8, {0x60,0x40,0x40,0x40,0x40,0x40,0x60,0x00}};/* [ */
static FONT_GLYPH g5c={6, 8, {0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00}};/* \ */
static FONT_GLYPH g5d={6, 8, {0x60,0x20,0x20,0x20,0x20,0x20,0x60,0x00}};/* ] */
static FONT_GLYPH g5e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};/* ^ */
static FONT_GLYPH g5f={6, 8, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc}};/* _ */
static FONT_GLYPH g60={6, 8, {0x20,0x20,0x10,0x00,0x00,0x00,0x00,0x00}};/* ` */
static FONT_GLYPH g61={6, 8, {0x00,0x00,0x78,0x88,0x88,0x88,0x78,0x00}};/* a */
static FONT_GLYPH g62={6, 8, {0x80,0x80,0xf0,0x88,0x88,0x88,0xf0,0x00}};/* b */
static FONT_GLYPH g63={6, 8, {0x00,0x00,0x70,0x88,0x80,0x88,0x70,0x00}};/* c */
static FONT_GLYPH g64={6, 8, {0x08,0x08,0x78,0x88,0x88,0x88,0x78,0x00}};/* d */
static FONT_GLYPH g65={6, 8, {0x00,0x00,0x70,0x88,0xf8,0x80,0x70,0x00}};/* e */
static FONT_GLYPH g66={6, 8, {0x30,0x48,0x40,0xe0,0x40,0x40,0x40,0x00}};/* f */
static FONT_GLYPH g67={6, 8, {0x00,0x00,0x70,0x88,0x88,0x78,0x08,0xf0}};/* g */
static FONT_GLYPH g68={6, 8, {0x80,0x80,0xf0,0x88,0x88,0x88,0x88,0x00}};/* h */
static FONT_GLYPH g69={6, 8, {0x20,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};/* i */
static FONT_GLYPH g6a={6, 8, {0x08,0x00,0x08,0x08,0x08,0x08,0x88,0x70}};/* j */
static FONT_GLYPH g6b={6, 8, {0x80,0x80,0x88,0x90,0xe0,0x90,0x88,0x00}};/* k */
static FONT_GLYPH g6c={6, 8, {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00}};/* l */
static FONT_GLYPH g6d={6, 8, {0x00,0x00,0xd0,0xa8,0xa8,0xa8,0xa8,0x00}};/* m */
static FONT_GLYPH g6e={6, 8, {0x00,0x00,0xf0,0x88,0x88,0x88,0x88,0x00}};/* n */
static FONT_GLYPH g6f={6, 8, {0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00}};/* o */
static FONT_GLYPH g70={6, 8, {0x00,0x00,0xf0,0x88,0x88,0x88,0xf0,0x80}};/* p */
static FONT_GLYPH g71={6, 8, {0x00,0x00,0x78,0x88,0x88,0x88,0x78,0x08}};/* q */
static FONT_GLYPH g72={6, 8, {0x00,0x00,0xb0,0xc8,0x80,0x80,0x80,0x00}};/* r */
static FONT_GLYPH g73={6, 8, {0x00,0x00,0x78,0x80,0x70,0x08,0xf0,0x00}};/* s */
static FONT_GLYPH g74={6, 8, {0x20,0x20,0x78,0x20,0x20,0x20,0x20,0x00}};/* t */
static FONT_GLYPH g75={6, 8, {0x00,0x00,0x88,0x88,0x88,0x88,0x70,0x00}};/* u */
static FONT_GLYPH g76={6, 8, {0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00}};/* v */
static FONT_GLYPH g77={6, 8, {0x00,0x00,0x88,0x88,0xa8,0xa8,0x50,0x00}};/* w */
static FONT_GLYPH g78={6, 8, {0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00}};/* x */
static FONT_GLYPH g79={6, 8, {0x00,0x00,0x88,0x88,0x88,0x78,0x08,0xf0}};/* y */
static FONT_GLYPH g7a={6, 8, {0x00,0x00,0xf8,0x10,0x20,0x40,0xf8,0x00}};/* z */
static FONT_GLYPH g7b={6, 8, {0x10,0x20,0x20,0x40,0x20,0x20,0x10,0x00}};/* { */
static FONT_GLYPH g7c={6, 8, {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00}};/* | */
static FONT_GLYPH g7d={6, 8, {0x40,0x20,0x20,0x10,0x20,0x20,0x40,0x00}};/* } */
static FONT_GLYPH g7e={6, 8, {0x48,0xb0,0x00,0x00,0x00,0x00,0x00,0x00}};/* ~ */
static FONT_GLYPH g7f={6, 8, {0x00,0x00,0x20,0x50,0x88,0x88,0xf8,0x00}};/*  */

/* begin char 0xa1, end char 0x100 */
static FONT_GLYPH ga1={6, 8, {0x00,0x20,0x00,0x20,0x20,0x20,0x20,0x20}};/*  */
static FONT_GLYPH ga2={6, 8, {0x00,0x20,0x70,0x80,0x80,0x80,0x70,0x20}};/*  */
static FONT_GLYPH ga3={6, 8, {0x00,0x30,0x48,0xe0,0x40,0x48,0xf0,0x00}};/*  */
static FONT_GLYPH ga4={6, 8, {0x00,0x88,0x70,0x88,0x88,0x70,0x88,0x00}};/*  */
static FONT_GLYPH ga5={6, 8, {0x88,0x88,0x50,0xf8,0x20,0xf8,0x20,0x00}};/*  */
static FONT_GLYPH ga6={6, 8, {0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH ga7={6, 8, {0x78,0x84,0xb0,0x48,0x48,0x34,0x84,0x78}};/*  */
static FONT_GLYPH ga8={6, 8, {0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00}};/*  */
static FONT_GLYPH ga9={6, 8, {0x00,0x00,0x78,0xb4,0xc4,0xc4,0xb4,0x78}};/*  */
static FONT_GLYPH gaa={6, 8, {0x70,0x90,0x90,0x70,0x00,0xf0,0x00,0x00}};/*  */
static FONT_GLYPH gab={6, 8, {0x00,0x00,0x28,0x50,0xa0,0x50,0x28,0x00}};/*  */
static FONT_GLYPH gac={6, 8, {0x00,0x00,0x00,0xf8,0x08,0x08,0x00,0x00}};/*  */
static FONT_GLYPH gad={6, 8, {0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gae={6, 8, {0x00,0x00,0x78,0xe4,0xd4,0xe4,0xd4,0x78}};/*  */
static FONT_GLYPH gaf={6, 8, {0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb0={6, 8, {0x30,0x48,0x48,0x30,0x00,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb1={6, 8, {0x00,0x20,0x70,0x20,0x00,0x70,0x00,0x00}};/*  */
static FONT_GLYPH gb2={6, 8, {0x60,0x90,0x20,0x40,0xf0,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb3={6, 8, {0x60,0x90,0x20,0x90,0x60,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb4={6, 8, {0x00,0x30,0xc0,0x00,0x00,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb5={6, 8, {0x00,0x00,0x48,0x48,0x48,0x70,0x40,0x40}};/*  */
static FONT_GLYPH gb6={6, 8, {0x74,0x94,0x94,0x74,0x14,0x14,0x14,0x00}};/*  */
static FONT_GLYPH gb7={6, 8, {0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gb8={6, 8, {0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x70}};/*  */
static FONT_GLYPH gb9={6, 8, {0x60,0xa0,0x20,0x20,0x70,0x00,0x00,0x00}};/*  */
static FONT_GLYPH gba={6, 8, {0x60,0x90,0x90,0x60,0x00,0xf0,0x00,0x00}};/*  */
static FONT_GLYPH gbb={6, 8, {0x00,0x00,0xa0,0x50,0x28,0x50,0xa0,0x00}};/*  */
static FONT_GLYPH gbc={6, 8, {0x40,0x48,0x50,0x28,0x58,0xa8,0x3c,0x08}};/*  */
static FONT_GLYPH gbd={6, 8, {0x40,0x48,0x50,0x38,0x64,0x88,0x10,0x1c}};/*  */
static FONT_GLYPH gbe={6, 8, {0xe0,0x28,0x70,0x28,0xd8,0xa8,0x3c,0x08}};/*  */
static FONT_GLYPH gbf={6, 8, {0x00,0x20,0x00,0x20,0x20,0x10,0x88,0x70}};/*  */
static FONT_GLYPH gc0={6, 8, {0x60,0x18,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc1={6, 8, {0x30,0xc0,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc2={6, 8, {0x70,0x88,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc3={6, 8, {0x68,0x98,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc4={6, 8, {0x50,0x00,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc5={6, 8, {0x20,0x50,0x20,0x50,0x88,0xf8,0x88,0x00}};/*  */
static FONT_GLYPH gc6={6, 8, {0x00,0x2c,0x50,0x90,0xf8,0x90,0x9c,0x00}};/*  */
static FONT_GLYPH gc7={6, 8, {0x30,0x48,0x80,0x80,0x48,0x30,0x08,0x38}};/*  */
static FONT_GLYPH gc8={6, 8, {0x60,0x18,0xf8,0x80,0xf0,0x80,0xf8,0x00}};/*  */
static FONT_GLYPH gc9={6, 8, {0x30,0xc0,0xf8,0x80,0xf0,0x80,0xf8,0x00}};/*  */
static FONT_GLYPH gca={6, 8, {0x70,0x88,0xf8,0x80,0xf0,0x80,0xf8,0x00}};/*  */
static FONT_GLYPH gcb={6, 8, {0x50,0x00,0xf8,0x80,0xf0,0x80,0xf8,0x00}};/*  */
static FONT_GLYPH gcc={6, 8, {0x60,0x18,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gcd={6, 8, {0x30,0xc0,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gce={6, 8, {0x70,0x88,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gcf={6, 8, {0x50,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gd0={6, 8, {0x70,0x48,0x48,0xe8,0x48,0x48,0x70,0x00}};/*  */
static FONT_GLYPH gd1={6, 8, {0x68,0x98,0x00,0xc8,0xa8,0x98,0x88,0x00}};/*  */
static FONT_GLYPH gd2={6, 8, {0x60,0x18,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gd3={6, 8, {0x30,0xc0,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gd4={6, 8, {0x70,0x88,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gd5={6, 8, {0x68,0x98,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gd6={6, 8, {0x50,0x00,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gd7={6, 8, {0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00}};/*  */
static FONT_GLYPH gd8={6, 8, {0x74,0x88,0x98,0xa8,0xa8,0xc8,0xf0,0x00}};/*  */
static FONT_GLYPH gd9={6, 8, {0x60,0x18,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gda={6, 8, {0x30,0xc0,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gdb={6, 8, {0x70,0x88,0x00,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gdc={6, 8, {0x50,0x00,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gdd={6, 8, {0x30,0xc0,0x88,0x88,0x50,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gde={6, 8, {0x80,0x80,0xe0,0x90,0x90,0xe0,0x80,0x80}};/*  */
static FONT_GLYPH gdf={6, 8, {0x70,0x88,0x98,0xa0,0x90,0x88,0x90,0x00}};/*  */
static FONT_GLYPH ge0={6, 8, {0x60,0x18,0x78,0x88,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge1={6, 8, {0x30,0xc0,0x00,0x78,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge2={6, 8, {0x70,0x88,0x00,0x78,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge3={6, 8, {0x68,0x98,0x00,0x78,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge4={6, 8, {0x50,0x00,0x78,0x88,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge5={6, 8, {0x20,0x50,0x78,0x88,0x88,0x88,0x78,0x00}};/*  */
static FONT_GLYPH ge6={6, 8, {0x00,0x00,0x68,0x14,0xfc,0x90,0x6c,0x00}};/*  */
static FONT_GLYPH ge7={6, 8, {0x00,0x70,0x88,0x80,0x88,0x70,0x08,0x38}};/*  */
static FONT_GLYPH ge8={6, 8, {0x60,0x18,0x70,0x88,0xf8,0x80,0x70,0x00}};/*  */
static FONT_GLYPH ge9={6, 8, {0x30,0xc0,0x70,0x88,0xf8,0x80,0x70,0x00}};/*  */
static FONT_GLYPH gea={6, 8, {0x70,0x88,0x70,0x88,0xf8,0x80,0x70,0x00}};/*  */
static FONT_GLYPH geb={6, 8, {0x50,0x00,0x70,0x88,0xf8,0x80,0x70,0x00}};/*  */
static FONT_GLYPH gec={6, 8, {0x60,0x18,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH ged={6, 8, {0x30,0xc0,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gee={6, 8, {0x70,0x88,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gef={6, 8, {0x50,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};/*  */
static FONT_GLYPH gf0={6, 8, {0x10,0x38,0x10,0x70,0x90,0x90,0x60,0x00}};/*  */
static FONT_GLYPH gf1={6, 8, {0x68,0x98,0x00,0xf0,0x88,0x88,0x88,0x00}};/*  */
static FONT_GLYPH gf2={6, 8, {0x60,0x18,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gf3={6, 8, {0x30,0xc0,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gf4={6, 8, {0x70,0x88,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gf5={6, 8, {0x68,0x98,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gf6={6, 8, {0x50,0x00,0x70,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gf7={6, 8, {0x00,0x00,0x20,0x00,0xf8,0x00,0x20,0x00}};/*  */
static FONT_GLYPH gf8={6, 8, {0x00,0x00,0x78,0x98,0xa8,0xc8,0xf0,0x00}};/*  */
static FONT_GLYPH gf9={6, 8, {0x60,0x18,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gfa={6, 8, {0x30,0xc0,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gfb={6, 8, {0x70,0x88,0x00,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gfc={6, 8, {0x50,0x00,0x88,0x88,0x88,0x88,0x70,0x00}};/*  */
static FONT_GLYPH gfd={6, 8, {0x30,0xc0,0x88,0x88,0x88,0x78,0x08,0xf0}};/*  */
static FONT_GLYPH gfe={6, 8, {0x80,0x80,0xe0,0x90,0x90,0xe0,0x80,0x80}};/*  */
static FONT_GLYPH gff={6, 8, {0x50,0x00,0x88,0x88,0x88,0x78,0x08,0xf0}};/*  */

/* begin char 0x100, end char 0x180 */
static FONT_GLYPH g100={6, 8, {0xf8,0x00,0x20,0x50,0x88,0xf8,0x88,0x00}};
static FONT_GLYPH g101={6, 8, {0xf8,0x00,0x78,0x88,0x88,0x88,0x78,0x00}};
static FONT_GLYPH g102={6, 8, {0x88,0x70,0x20,0x50,0x88,0xf8,0x88,0x00}};
static FONT_GLYPH g103={6, 8, {0x88,0x70,0x00,0x78,0x88,0x88,0x78,0x00}};
static FONT_GLYPH g104={6, 8, {0x20,0x50,0x88,0xf8,0x88,0x98,0x20,0x18}};
static FONT_GLYPH g105={6, 8, {0x78,0x88,0x88,0x88,0x78,0x10,0x20,0x18}};
static FONT_GLYPH g106={6, 8, {0x30,0xc0,0x30,0x48,0x80,0x80,0x48,0x30}};
static FONT_GLYPH g107={6, 8, {0x30,0xc0,0x70,0x88,0x80,0x88,0x70,0x00}};
static FONT_GLYPH g108={6, 8, {0x70,0x88,0x30,0x48,0x80,0x80,0x48,0x30}};
static FONT_GLYPH g109={6, 8, {0x70,0x88,0x70,0x88,0x80,0x88,0x70,0x00}};
static FONT_GLYPH g10a={6, 8, {0x20,0x00,0x30,0x48,0x80,0x80,0x48,0x30}};
static FONT_GLYPH g10b={6, 8, {0x20,0x00,0x70,0x88,0x80,0x88,0x70,0x00}};
static FONT_GLYPH g10c={6, 8, {0x50,0x20,0x30,0x48,0x80,0x80,0x48,0x30}};
static FONT_GLYPH g10d={6, 8, {0x50,0x20,0x70,0x88,0x80,0x88,0x70,0x00}};
static FONT_GLYPH g10e={6, 8, {0x50,0x20,0xe0,0x90,0x88,0x88,0x90,0xe0}};
static FONT_GLYPH g10f={6, 8, {0x50,0x28,0x08,0x78,0x88,0x88,0x78,0x00}};
static FONT_GLYPH g110={6, 8, {0x70,0x48,0x48,0xe8,0x48,0x48,0x70,0x00}};
static FONT_GLYPH g111={6, 8, {0x10,0x38,0x10,0x70,0x90,0x90,0x60,0x00}};
static FONT_GLYPH g112={6, 8, {0xf8,0x00,0xf8,0x80,0xf0,0x80,0xf8,0x00}};
static FONT_GLYPH g113={6, 8, {0xf8,0x00,0x70,0x88,0xf8,0x80,0x70,0x00}};
static FONT_GLYPH g114={6, 8, {0x88,0x70,0x00,0xf8,0x80,0xf0,0x80,0xf8}};
static FONT_GLYPH g115={6, 8, {0x88,0x70,0x00,0x70,0x88,0xf8,0x80,0x70}};
static FONT_GLYPH g116={6, 8, {0x20,0x00,0xf8,0x80,0xf0,0x80,0xf8,0x00}};
static FONT_GLYPH g117={6, 8, {0x20,0x00,0x70,0x88,0xf8,0x80,0x70,0x00}};
static FONT_GLYPH g118={6, 8, {0xf8,0x80,0xf0,0x80,0xf8,0x10,0x20,0x18}};
static FONT_GLYPH g119={6, 8, {0x70,0x88,0xf8,0x80,0x70,0x10,0x20,0x18}};
static FONT_GLYPH g11a={6, 8, {0x50,0x20,0xf8,0x80,0xf0,0x80,0xf8,0x00}};
static FONT_GLYPH g11b={6, 8, {0x50,0x20,0x70,0x88,0xf8,0x80,0x70,0x00}};
static FONT_GLYPH g11c={6, 8, {0x70,0x88,0x30,0x48,0x80,0x98,0x48,0x30}};
static FONT_GLYPH g11d={6, 8, {0x70,0x88,0x70,0x88,0x88,0x78,0x08,0xf0}};
static FONT_GLYPH g11e={6, 8, {0x88,0x70,0x30,0x48,0x80,0x98,0x48,0x30}};
static FONT_GLYPH g11f={6, 8, {0x88,0x70,0x70,0x88,0x88,0x78,0x08,0xf0}};
static FONT_GLYPH g120={6, 8, {0x20,0x00,0x30,0x48,0x80,0x98,0x48,0x30}};
static FONT_GLYPH g121={6, 8, {0x20,0x00,0x70,0x88,0x88,0x78,0x08,0xf0}};
static FONT_GLYPH g122={6, 8, {0x30,0x48,0x80,0x98,0x48,0x30,0x08,0x38}};
static FONT_GLYPH g123={6, 8, {0x70,0x88,0x88,0x78,0x08,0xf0,0x08,0x38}};
static FONT_GLYPH g124={6, 8, {0x70,0x88,0x00,0x88,0x88,0xf8,0x88,0x88}};
static FONT_GLYPH g125={6, 8, {0x70,0x88,0x80,0x80,0xf0,0x88,0x88,0x88}};
static FONT_GLYPH g126={6, 8, {0x88,0xfc,0x88,0xf8,0x88,0x88,0x88,0x00}};
static FONT_GLYPH g127={6, 8, {0x80,0xf8,0x80,0xf0,0x88,0x88,0x88,0x00}};
static FONT_GLYPH g128={6, 8, {0x68,0x98,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g129={6, 8, {0x68,0x98,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g12a={6, 8, {0xf8,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g12b={6, 8, {0xf8,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g12c={6, 8, {0x88,0x70,0x00,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g12d={6, 8, {0x88,0x70,0x00,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g12e={6, 8, {0x20,0x20,0x20,0x20,0x20,0x10,0x20,0x18}};
static FONT_GLYPH g12f={6, 8, {0x20,0x00,0x20,0x20,0x20,0x10,0x20,0x18}};
static FONT_GLYPH g130={6, 8, {0x20,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g131={6, 8, {0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x00}};
static FONT_GLYPH g132={6, 8, {0x88,0x88,0x88,0x88,0xa8,0xa8,0x90,0x00}};
static FONT_GLYPH g133={6, 8, {0x88,0x00,0x88,0x88,0x88,0x88,0xa8,0x10}};
static FONT_GLYPH g134={6, 8, {0x70,0x88,0x00,0x08,0x08,0x88,0x70,0x00}};
static FONT_GLYPH g135={6, 8, {0x70,0x88,0x00,0x08,0x08,0x08,0x88,0x70}};
static FONT_GLYPH g136={6, 8, {0x90,0x90,0xa0,0xc0,0xa0,0x90,0x08,0x38}};
static FONT_GLYPH g137={6, 8, {0x80,0x80,0xa0,0xc0,0xa0,0x90,0x08,0x38}};
static FONT_GLYPH g138={6, 8, {0x00,0x00,0x90,0xa0,0xc0,0xa0,0x90,0x00}};
// TODO
static FONT_GLYPH g139={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13a={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13b={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13c={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13d={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g13f={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g140={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g141={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g142={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g143={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g144={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g145={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g146={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g147={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g148={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g149={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14a={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14b={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14c={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14d={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g14f={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g150={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g151={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g152={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g153={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g154={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g155={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g156={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g157={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g158={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g159={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15a={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15b={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15c={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15d={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g15f={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g160={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g161={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g162={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g163={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g164={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g165={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g166={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g167={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g168={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g169={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16a={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16b={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16c={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16d={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g16f={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g170={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g171={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g172={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g173={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g174={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g175={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g176={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g177={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g178={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g179={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17a={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17b={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17c={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17d={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17e={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};
static FONT_GLYPH g17f={6, 8, {0x00,0x20,0x50,0x88,0x00,0x00,0x00,0x00}};


static FONT_GLYPH *eme_ascii_data[] = {
  &g20, &g21, &g22, &g23, &g24, &g25, &g26, &g27,
  &g28, &g29, &g2a, &g2b, &g2c, &g2d, &g2e, &g2f,
  &g30, &g31, &g32, &g33, &g34, &g35, &g36, &g37,
  &g38, &g39, &g3a, &g3b, &g3c, &g3d, &g3e, &g3f,
  &g40, &g41, &g42, &g43, &g44, &g45, &g46, &g47,
  &g48, &g49, &g4a, &g4b, &g4c, &g4d, &g4e, &g4f,
  &g50, &g51, &g52, &g53, &g54, &g55, &g56, &g57,
  &g58, &g59, &g5a, &g5b, &g5c, &g5d, &g5e, &g5f,
  &g60, &g61, &g62, &g63, &g64, &g65, &g66, &g67,
  &g68, &g69, &g6a, &g6b, &g6c, &g6d, &g6e, &g6f,
  &g70, &g71, &g72, &g73, &g74, &g75, &g76, &g77,
  &g78, &g79, &g7a, &g7b, &g7c, &g7d, &g7e, &g7f,
};

static FONT_GLYPH *eme_latin1_data[] = {
        &ga1, &ga2, &ga3, &ga4, &ga5, &ga6, &ga7,
  &ga8, &ga9, &gaa, &gab, &gac, &gad, &gae, &gaf,
  &gb0, &gb1, &gb2, &gb3, &gb4, &gb5, &gb6, &gb7,
  &gb8, &gb9, &gba, &gbb, &gbc, &gbd, &gbe, &gbf,
  &gc0, &gc1, &gc2, &gc3, &gc4, &gc5, &gc6, &gc7,
  &gc8, &gc9, &gca, &gcb, &gcc, &gcd, &gce, &gcf,
  &gd0, &gd1, &gd2, &gd3, &gd4, &gd5, &gd6, &gd7,
  &gd8, &gd9, &gda, &gdb, &gdc, &gdd, &gde, &gdf,
  &ge0, &ge1, &ge2, &ge3, &ge4, &ge5, &ge6, &ge7,
  &ge8, &ge9, &gea, &geb, &gec, &ged, &gee, &gef,
  &gf0, &gf1, &gf2, &gf3, &gf4, &gf5, &gf6, &gf7,
  &gf8, &gf9, &gfa, &gfb, &gfc, &gfd, &gfe, &gff
};

static FONT_GLYPH *eme_extended_a_data[] = {
  &g100, &g101, &g102, &g103, &g104, &g105, &g106, &g107,
  &g108, &g109, &g10a, &g10b, &g10c, &g10d, &g10e, &g10f,
  &g110, &g111, &g112, &g113, &g114, &g115, &g116, &g117,
  &g118, &g119, &g11a, &g11b, &g11c, &g11d, &g11e, &g11f,
  &g120, &g121, &g122, &g123, &g124, &g125, &g126, &g127,
  &g128, &g129, &g12a, &g12b, &g12c, &g12d, &g12e, &g12f,
  &g130, &g131, &g132, &g133, &g134, &g135, &g136, &g137,
  &g138, &g139, &g13a, &g13b, &g13c, &g13d, &g13e, &g13f,
  &g140, &g141, &g142, &g143, &g144, &g145, &g146, &g147,
  &g148, &g149, &g14a, &g14b, &g14c, &g14d, &g14e, &g14f,
  &g150, &g151, &g152, &g153, &g154, &g155, &g156, &g157,
  &g158, &g159, &g15a, &g15b, &g15c, &g15d, &g15e, &g15f,
  &g160, &g161, &g162, &g163, &g164, &g165, &g166, &g167,
  &g168, &g169, &g16a, &g16b, &g16c, &g16d, &g16e, &g16f,
  &g170, &g171, &g172, &g173, &g174, &g175, &g176, &g177,
  &g178, &g179, &g17a, &g17b, &g17c, &g17d, &g17e, &g17f
};


static FONT_MONO_DATA extended_a_monofont = {
    0x100, 0x180,               /* begin, end characters */
    eme_extended_a_data,        /* the data set */
    0                           /* next */
};

static FONT_MONO_DATA latin1_monofont = {
    0x0A1, 0x100,               /* begin, end characters */
    eme_latin1_data,            /* the data set */
    &extended_a_monofont        /* next */
};

static FONT_MONO_DATA ascii_monofont = {
    0x20, 0x80,                 /* begin, end characters */
    eme_ascii_data,             /* the data set */
    &latin1_monofont            /* next */
};

FONT _eme_font = {
    &ascii_monofont,            /* first lot of data */
    8,                          /* height */
    0                           /* vtable */
};

FONT *saved_font = 0;

FONT *get_font(FONT_SIZE size)
{
  if (!saved_font) saved_font = font;
  _eme_font.vtable = font_vtable_mono;
  if (size == FONT_SIZE_SMALL) {
    return &_eme_font;
  }
  else if (size == FONT_SIZE_BIG) {
    return saved_font;
  }
  else {
    //DBG_ASSERT(0);
    return font;
  }
}

int font_is_small(FONT *font)
{
  return font == &_eme_font;
}

