#include "colors.h"
#include <stdio.h>

#include <allegro.h>


int background_color()
{
  return makecol(16, 16, 16);
}


BITMAP *invert(BITMAP *bmp)
{
  int i, j;
  BITMAP *ret= create_bitmap_ex(32, bmp->w, bmp->h);
  for (i=0; i<ret->w; ++i) for (j=0; j<ret->h; ++j) {
    int p = getpixel(bmp, i, j);
    int r = getr_depth(32, p);
    int g = getg_depth(32, p);
    int b = getb_depth(32, p);
    int a = geta_depth(32, p);

    putpixel(ret, i, j, makeacol_depth(32, 255-r, 255-g, 255-b, a));
  }
  return ret;
}

BITMAP *colorize(BITMAP *bmp, int red, int green, int blue,int use_alpha)
{
  int i, j;
  BITMAP *ret = create_bitmap_ex(32, bmp->w, bmp->h);
  float hue, saturation, value;

  /* Hack: hue for (255, 255, 255) seems red */
  if (red==255 && green==255 && blue==255) {
    blit(bmp, ret, 0, 0, 0, 0, ret->w, ret->h);
    return ret;
  }

  rgb_to_hsv(red, green, blue, &hue, &saturation, &value);

  for (i=0; i<ret->w; ++i) for (j=0; j<ret->h; ++j) {
    int p = getpixel(bmp, i, j);
    int r = getr_depth(32, p);
    int g = getg_depth(32, p);
    int b = getb_depth(32, p);
    int a = geta_depth(32, p);

    float h, s, v;
    int rr, gg, bb;
    int ints;

    /* Hack: can't have the same "color" blending than Gimp */
    rgb_to_hsv(r, g, b, &h, &s, &v);
    if (use_alpha) {
      //ints = 511-2*a;
      ints = 255-a;
      //ints = 383-3*a/2;
      ints=MID(0,ints,255);
      hsv_to_rgb(hue, ints/255.0f, v, &rr, &gg, &bb);
    }
    else { /* Does not seem to work */
      //hsv_to_rgb(hue, s, v, &rr, &gg, &bb);
      hsv_to_rgb(hue, s, value, &rr, &gg, &bb);
    }

    putpixel(ret, i, j, makeacol_depth(32, rr, gg, bb, a));
  }

  return ret;
}


BITMAP *_colorize(BITMAP *bmp, int red, int green, int blue,int use_alpha)
{
  int i, j;
  BITMAP *ret = create_bitmap_ex(32, bmp->w, bmp->h);

  for (i=0; i<ret->w; ++i) for (j=0; j<ret->h; ++j) {
    int p = getpixel(bmp, i, j);
    int r = getr_depth(32, p);
    int g = getg_depth(32, p);
    int b = getb_depth(32, p);
    int a = geta_depth(32, p);

    int level = (r+g+b)/3;
    int rr = 255 - ((255-red)*level)/255;
    int gg = 255 - ((255-green)*level)/255;
    int bb = 255 - ((255-blue)*level)/255;

    putpixel(ret, i, j, makeacol_depth(32, rr, gg, bb, a));
  }

  return ret;
}

