#include "cache.h"

#include "colors.h"
#include <allegro.h>

typedef struct CACHE_ENTRY {
  struct BITMAP *bmp;
  int color32;
  char *filename;
} CACHE_ENTRY;

static int entry_count=0;
static CACHE_ENTRY *the_cache = 0;

static BITMAP *find(const char *filename, int color32)
{
  int n;
  for (n=0; n<entry_count; ++n) {
    if (the_cache[n].color32==color32) {
      if (ustrcmp(the_cache[n].filename, filename)==0) {
        return the_cache[n].bmp;
      }
    }
  }
  return NULL;
}

static BITMAP *add(const char *filename, int color32)
{
  the_cache = realloc(the_cache, sizeof(CACHE_ENTRY)*(entry_count+1));
  if (the_cache) {
    BITMAP *src;
    the_cache[entry_count].filename = ustrdup(filename);
    the_cache[entry_count].color32 = color32;
    src = load_bitmap(filename, NULL); //Doesn't work in 8 bits
    if (!src) return NULL;
    if (color32==0) {
      the_cache[entry_count].bmp = invert(src);
    }
    else {
      the_cache[entry_count].bmp =
        colorize(src, getr32(color32), getg32(color32), getb32(color32), 1);
    }
    destroy_bitmap(src);
    entry_count++;
    return the_cache[entry_count-1].bmp;
  }
  else {
    entry_count = 0;
    return NULL;
  }
}

BITMAP *get_bitmap(const char *filename, int r, int g, int b)
{
  int color32 = makecol32(r, g, b);
  BITMAP *ret = find(filename, color32);
  if (!ret) {
    ret = add(filename, color32);
  }
  return ret;
}

void clear_bitmap_cache()
{
  int n;
  for (n=0;n<entry_count;++n) {
    destroy_bitmap(the_cache[n].bmp);
    free(the_cache[n].filename);
  }
  the_cache=NULL;
  entry_count=0;
}
