#ifndef ACTIONS_H
#define ACTIONS_H

#define ACTION_OK 0
#define ACTION_KO 1

extern int graphic_mode;

/* Returns 1 if ok, else 0. Must be called after Allegro initialization */
int init_actions(void);


/* Returns non-zero if the file is a directory */
int is_directory(const char *filename,int attr);

/* Returns non-zero if the file is executable */
int is_executable(const char *filename,int attr);


const char *get_weapon_executable(int weapon);
const char *get_collision_executable(const char *filename,int attr);
const char *get_file_image(const char *filename,int attr);
int get_file_color(const char *filename, int attr, int *r, int *g, int *b);
int get_file_textcolor(const char *filename, int attr, int *r, int *g, int *b);

/* Use weapon binding on the file */
int shoot_file(const char *filename, int weapon);
/* Try to execute the file, then to change directory, then use binding */
int collide_file(const char *filename, int attr);

#endif

