UNIT mgVTable;
(*
 *       _    _
 *      | \  / | O  _ ___  _____  _ __  _____
 *      |  \/  || || `_  \/  _  \| `__|/  _  \
 *      | |\/| || || | | || |_| || |   | |_| |
 *      |_|  |_||_||_| |_||___  ||_|   \____/
 *			    __| |
 *			   \___/
 *
 *      Internal virtual tables.
 *
 *      By uo Martnez.
 *	Based on the file "gfx.h" of the Allegro library by Shawn Hargreaves.
 *      Some parts of the code was created by the "h2pas" utility.
 *
 *      See readme.txt for copyright information.
 *)

INTERFACE

{$PACKRECORDS C}

  TYPE
    INTEGERptr = ^INTEGER;
  (* Some internal stuff to define virtual methods. *)
    MG_BITMAPptr = POINTER;
    _BMP_METHOD_ = PROCEDURE (bmp: MG_BITMAPptr); CDECL;
    _LINE_METHOD_ = PROCEDURE (bmp: MG_BITMAPptr; x1, y1, x2, y2, color: LONGINT); CDECL;
    _FLINE_METHOD_ = PROCEDURE (bmp: MG_BITMAPptr; a, b, c, d: LONGINT); CDECL;
    _CIRCLE_METHOD_ = PROCEDURE (bmp: MG_BITMAPptr; x, y, r, c: LONGINT); CDECL;
    _ELLIPSE_METHOD_ = PROCEDURE (bmp: MG_BITMAPptr; x, y, rx, ry, c: LONGINT); CDECL;
    _SPR_METHOD_ = PROCEDURE (bmp, spr: MG_BITMAPptr; x, y: LONGINT); CDECL;
    _BLIT_METHOD_ = PROCEDURE (org, dest: MG_BITMAPptr; o_x, o_y, d_x, d_y, w, h: LONGINT); CDECL;

    MG_GFX_VTABLEptr = ^MG_GFX_VTABLE;
    MG_GFX_VTABLE = RECORD
      color_depth: LONGINT;
      mask_color: LONGINT;
      unwrite_bank: POINTER;  (* C function on some machines, asm on i386 *)
    { Note that you would use these methods directly but it isn't recommendable.
      Use the Mingro Drawing Primitives instead. }
      set_clip: _BMP_METHOD_;
      acquire: _BMP_METHOD_;
      release: _BMP_METHOD_;
      create_sub_bitmap: FUNCTION (parent: MG_BITMAPptr; x, y, w, h: LONGINT): MG_BITMAPptr; CDECL;
      created_sub_bitmap: PROCEDURE (bmp, parent: MG_BITMAPptr); CDECL;
      getpixel: FUNCTION (bmp: MG_BITMAPptr; x, y: LONGINT): LONGINT; CDECL;
      putpixel: PROCEDURE (bmp: MG_BITMAPptr; x, y, color: LONGINT); CDECL;
      vline: _FLINE_METHOD_;
      hline: _FLINE_METHOD_;
      hfill: _FLINE_METHOD_;
      line: _LINE_METHOD_;
      fastline: _LINE_METHOD_;
      rectfill: _LINE_METHOD_;
      triangle: FUNCTION (bmp: MG_BITMAPptr; x1, y1, x2, y2, x3, y3, color: LONGINT): LONGINT; CDECL;
      draw_sprite: _SPR_METHOD_;
      draw_256_sprite: _SPR_METHOD_;
      draw_sprite_v_flip: _SPR_METHOD_;
      draw_sprite_h_flip: _SPR_METHOD_;
      draw_sprite_vh_flip: _SPR_METHOD_;
      draw_trans_sprite: _SPR_METHOD_;
      draw_trans_rgba_sprite: _SPR_METHOD_;
      draw_lit_sprite: PROCEDURE (bmp, sprite: MG_BITMAPptr; x, y, color: LONGINT); CDECL;
      draw_rle_sprite: POINTER;              { Unsuported method are defined as simple pointers. }
      draw_trans_rle_sprite: POINTER;
      draw_trans_rgba_rle_sprite: POINTER;
      draw_lit_rle_sprite: POINTER;
      draw_character: POINTER;
      draw_glyph: POINTER;
      blit_from_memory: _BLIT_METHOD_;
      blit_to_memory: _BLIT_METHOD_;
      blit_from_system: _BLIT_METHOD_;
      blit_to_system: _BLIT_METHOD_;
      blit_to_self: _BLIT_METHOD_;
      blit_to_self_forward: _BLIT_METHOD_;
      blit_to_self_backward: _BLIT_METHOD_;
      blit_between_formats: _BLIT_METHOD_;
      masked_blit: _BLIT_METHOD_;
      clear_to_color: PROCEDURE (bmp: MG_BITMAPptr; color: LONGINT); CDECL;     { The "fixed" parameter is a simple "integer". }
      pivot_scaled_sprite_flip: PROCEDURE (bmp, sprite: MG_BITMAPptr; x, y, cx, cy, angle, scale: LONGINT; v_flip: LONGINT); CDECL;
      do_stretch_blit: PROCEDURE (source, dest: MG_BITMAPptr; s_x, s_y, s_w, s_h, d_x, d_y, d_w, d_h, masked: LONGINT); CDECL;
      draw_gouraud_sprite: POINTER;
      draw_sprite_end: PROCEDURE; CDECL;
      blit_end: PROCEDURE; CDECL;
      polygon: PROCEDURE (bmp: MG_BITMAPptr; vertices: INTEGER; points: INTEGERptr; color: INTEGER); CDECL;
      rect: _LINE_METHOD_;
      circle: _CIRCLE_METHOD_;
      circlefill: _CIRCLE_METHOD_;
      ellipse: _ELLIPSE_METHOD_;
      ellipsefill: _ELLIPSE_METHOD_;
      arc: POINTER;
      spline: POINTER;
      floodfill: PROCEDURE (bmp: MG_BITMAPptr; x, y, c: INTEGER); CDECL;
      polygon3d: POINTER;
      polygon3d_f: POINTER;
      triangle3d: POINTER;
      triangle3d_f: POINTER;
      quad3d: POINTER;
      quad3d_f: POINTER;
    END;

IMPLEMENTATION

END.

