UNIT GUI;
(* Programa: Reversi, versin 2.x
 * Archivo: GUI.pas
 * Descripcin: Define un GUI muy simple.
 * Autor: uo Martnez < >
 *
    Copyright (C) uo Martnez, 2005

    Este programa es un Programa de Libre Distribucin; usted
    puede redistribuirlo y/o modificarlo bajo los trminos de
    la "Licencia de Libre Distribucin de Programas (LLDP)".

    Este programa es distribuido con la esperanza de que le ser
    til, pero SIN NINGUNA GARANTA. Vea la "Licencia de Libre
    Distribucin de Programas" para ms detalles.

    Usted debe haber recibido una copia de la "Licencia de Libre
    Distribucin de Programas" junto con este programa, si no es
    as, escriba a:

    Guimarprog, Apdo. 4034 09080 Burgos, Espaa

 *)

INTERFACE

TYPE
(* GUI_BOTON:
 *   Define un botn pulsable. *)
  GUI_BOTON = CLASS
  PRIVATE
  { Definicin del botn. }
    fX, fY, fAncho, fAlto: INTEGER;
    rX, rY: INTEGER; { Posicin del rtulo. }
    fRotulo: STRING;
  PUBLIC
    CONSTRUCTOR Crea (Rotulo: STRING; X, Y, Ancho, Alto: INTEGER);
    PROCEDURE Dibuja;
    FUNCTION Pulsado (x, y, b: INTEGER): BOOLEAN;
  END;



(* EmpiezaHumano:
 *   Preguna quin empieza. *)
FUNCTION EmpiezaHumano: BOOLEAN;

(* MuestraPuntuaciones:
 *   Dibuja un recuadro con las puntuaciones. *)
PROCEDURE MuestraPuntuaciones (H, O: INTEGER);



IMPLEMENTATION

USES mingro, mgMouse, SysUtils;

(* GUI_BOTON.Crea:
 *   Crea un botn. *)
CONSTRUCTOR GUI_BOTON.Crea (Rotulo: STRING; X, Y, Ancho, Alto: INTEGER);
BEGIN
  INHERITED Create;
  fX := X; fY := Y; fAncho := Ancho; fAlto := Alto;
{ Calcula la posicin del rtulo para que quede en el centro del botn. }
  rX := fX + (fAncho DIV 2) - (LENGTH (Rotulo) * 4);
  rY := fY + (Alto DIV 2) - 4;
  fRotulo := Rotulo;
END;



(* GUI_BOTON.Dibuja:
 *   Dibuja el botn. *)
PROCEDURE GUI_BOTON.Dibuja;
BEGIN
  mgShowMouse (NIL); mgAcquireScreen;
  mgRectFill (mgScreen, fX, fY, fX + fAncho - 1, fY + fAlto - 1,
	mgColor (204, 204, 204));
  mgRect (mgScreen, fX, fY, fX + fAncho - 1, fY + fAlto - 1, mgColor (0, 0, 0));
  mgTextOut (mgScreen, mgDefaultFont, rX, rY, mgColor (0, 0, 0), fRotulo);
  mgReleaseScreen; mgShowMouse (mgScreen);
END;



(* GUI_BOTON.Pulsado:
 *   Comprueba si el usuario ha pulsado la opcin con el ratn. *)
FUNCTION GUI_BOTON.Pulsado (x, y, b: INTEGER): BOOLEAN;
BEGIN
  IF b = 0 THEN
  BEGIN
    Pulsado := FALSE; EXIT;
  END;
{ Espera a que suelte el ratn o a que est fuera del botn. }
  WHILE (fx <= x) AND (x < fx + fAncho) AND (fy <= y) AND (y < fy + fAlto)
	AND (b <> 0) DO
    mgGetMousePosition (x, y, b);
{ Si el botn est pulsado es que se sali del botn, luego no seleccion. }
  Pulsado := (b = 0);
END;



(* EmpiezaHumano:
 *   Pregunta quin empieza. *)
FUNCTION EmpiezaHumano: BOOLEAN;
VAR
  Copia: MG_BITMAPptr;
  Opcion: ARRAY[0..1] OF GUI_BOTON;
  rx, ry, rb: INTEGER; { Estado del ratn. }
BEGIN
  mgShowMouse (NIL); mgAcquireScreen;
{ Salva el fondo para recuperarlo despus. }
  Copia := mgCreateBitmap (244, 70);
  mgBlitEx (mgScreen, Copia, 200, 100, 0, 0, 244, 70);
{ Crea la ventana con dos botones. }
  mgRectFill (mgScreen, 200, 100, 443, 169, mgColor (255, 255, 255));
  mgRect     (mgScreen, 200, 100, 443, 169, mgColor (0, 0, 0));
  mgTextout (mgScreen, mgDefaultFont, 255, 105, mgColor (0, 0, 0),
		'Primer movimiento');
  Opcion[0] := GUI_BOTON.Crea ('Ordenador',337,135,88,17);
  Opcion[1] := GUI_BOTON.Crea ('Humano',216,135,88,17);
  Opcion[1].Dibuja; Opcion[0].Dibuja;
  mgReleaseScreen; mgShowMouse (mgScreen);
{ Bucle principal. }
  WHILE TRUE DO
  BEGIN
  { Espera la pulsacin del usuario. }
    REPEAT
      mgGetMousePosition (rx, ry, rb);
    UNTIL rb <> 0;
    IF Opcion[0].Pulsado (rx, ry, rb) THEN
    BEGIN
      EmpiezaHumano := FALSE; BREAK;
    END;
    IF Opcion[1].Pulsado (rx, ry, rb) THEN
    BEGIN
      EmpiezaHumano := TRUE; BREAK;
    END;
  END;
{ Recupera el fondo. }
  mgShowMouse (NIL);
  mgBlit (Copia, mgScreen, 200, 100);
  mgShowMouse (mgScreen);
  mgDestroyBitmap (Copia);
END;



(* MuestraPuntuaciones:
 *   Dibuja un recuadro con las puntuaciones. *)
PROCEDURE MuestraPuntuaciones (H, O: INTEGER);
VAR
  Copia: MG_BITMAPptr;
  Salir: GUI_BOTON;
  rx, ry, rb: INTEGER; { Estado del ratn. }
BEGIN
  mgShowMouse (NIL); mgAcquireScreen;
{ Salva el fondo para recuperarlo despus. }
  Copia := mgCreateBitmap (244, 70);
  mgBlitEx (mgScreen, Copia, 200, 100, 0, 0, 244, 70);
{ El recuadro y su contenido. }
  mgRectFill (mgScreen, 200, 100, 443, 169, mgColor (255, 255, 255));
  mgRect     (mgScreen, 200, 100, 443, 169, mgColor (0, 0, 0));
  mgTextout (mgScreen, mgDefaultFont, 274, 105, mgColor (0, 0, 0),
		'Puntuaciones');
  mgTextout (mgScreen, mgDefaultFont, 273, 120, mgColor (0, 0, 0),
		'Humano    '+ IntToStr (H));
  mgTextout (mgScreen, mgDefaultFont, 273, 130, mgColor (0, 0, 0),
		'Ordenador '+ IntToStr (O));
  mgReleaseScreen; mgShowMouse (mgScreen);
  Salir := GUI_BOTON.Crea ('Ledo', 277, 145, 88, 16);
  Salir.Dibuja;
{ Espera a que pulse el botn. }
  REPEAT
    mgGetMousePosition (rx, ry, rb);
  UNTIL Salir.Pulsado (rx, ry, rb);   
{ Recupera el fondo. }
  mgShowMouse (NIL);
  mgBlit (Copia, mgScreen, 200, 100);
  mgShowMouse (mgScreen);
  mgDestroyBitmap (Copia);
END;

END.

