UNIT mgMouse;
(*       _    _
 *      | \  / | O  _ ___  _____  _ __  _____
 *      |  \/  || || `_  \/  _  \| `__|/  _  \
 *      | |\/| || || | | || |_| || |   | |_| |
 *      |_|  |_||_||_| |_||___  ||_|   \____/
 *			    __| |
 *			   \___/
 * 
 *      Defines the Mingro mouse routines.  It is a separated unit because
 *	a lot of games doesn't need it.
 *
 *      By uo Martnez.
 *      Some parts of the IMPLEMENTATION section were translated from the
 *	Allegro Game Library sources by Shawn Hargreaves and others. 
 *
 *      See readme.txt for copyright information.
 *)

INTERFACE

  USES
    mgBase, mingro;


(* mgInitMouse:
 *   Detects the mouse, prepares it and returns the number of buttons or 0
 *   if no mouse was detect. *)
FUNCTION mgInitMouse: INTEGER;



(* mgSetMouseSpeed:
 *   Set the mouse speed.  Larger values represent slower mouse movement.  The
 *   default is 2. *)
PROCEDURE mgSetMouseSpeed (x, y: LONGINT); CDECL;



(* mgSetMouseSprite:
 *  Use this function to supply an alternative mouse sprite and the point that
 *  represents the actual mouse position.  To select the default mouse sprite
 *  call mgSetMouseSprite (NIL, 1, 1). *)
PROCEDURE mgSetMouseSprite (sprite: MG_BITMAPptr; x, y: LONGINT);



(* mgSetMousePosition:
 *   Moves the mouse to the specified position. *)
PROCEDURE mgSetMousePosition (x, y: LONGINT); CDECL;



(* mgShowMouse:
 *   Tells to display a mouse pointer in the given bitmap.
 *   Call mgShowMouse (NIL) to hide the mouse cursor. *)
PROCEDURE mgShowMouse (Bmp: MG_BITMAPptr); CDECL;



(* mgGetMousePosition:
 *   Gets the mouse position and button status. *)
PROCEDURE mgGetMousePosition (VAR x, y, b: LONGINT);



(* mgSetMouseWheel:
 *   Sets the mouse wheel position. *)
PROCEDURE mgSetMouseWheel (p: LONGINT); CDECL;



(* mgGetMouseWheel:
 *   Returns the status of the mouse wheel. *)
FUNCTION mgGetMouseWheel: LONGINT;



(* mgGetMouseMickeys:
 *   Gets the mouse speed (mickeys) and button status. *)
PROCEDURE mgGetMouseMickeys (VAR x, y, b: LONGINT);



IMPLEMENTATION

(* Allegro API. *)
VAR
  mouse_x: LONGINT; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'mouse_x';
  mouse_y: LONGINT; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'mouse_y';
  mouse_z: LONGINT; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'mouse_z';
  mouse_b: LONGINT; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'mouse_b';

FUNCTION install_mouse: LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
FUNCTION poll_mouse: LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
PROCEDURE get_mouse_mickeys (x, y: POINTER); CDECL; 
					EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
PROCEDURE set_mouse_sprite (sprite: MG_BITMAPptr); CDECL; 
					EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
PROCEDURE set_mouse_sprite_focus (x, y: LONGINT); CDECL; 
					EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;



(* mgInitMouse:
 *   Detects the mouse, prepares it and returns the number of buttons or 0
 *   if no mouse was detect. *)
FUNCTION mgInitMouse: INTEGER;
BEGIN
  mgInitMouse := install_mouse;
  IF mgInitMouse < 0 THEN mgInitMouse := 0;
END;



(* mgSetMouseSpeed:
 *   Set the mouse speed.  Larger values represent slower mouse movement.  The
 *   default is 2. *)
PROCEDURE mgSetMouseSpeed (x, y: LONGINT); CDECL;
	EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'set_mouse_speed';



(* mgSetMouseSprite:
 *  Use this function to supply an alternative mouse sprite and the point that
 *  represents the actual mouse position.  To select the default mouse sprite
 *  call mgSetMouseSprite (NIL, 1, 1). *)
PROCEDURE mgSetMouseSprite (sprite: MG_BITMAPptr; x, y: LONGINT);
BEGIN
  set_mouse_sprite (sprite); set_mouse_sprite_focus (x, y);
END;



(* mgSetMousePosition:
 *   Moves the mouse to the specified position. *)
PROCEDURE mgSetMousePosition (x, y: LONGINT); CDECL;
	EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'position_mouse';



(* mgShowMouse:
 *   Tells to display a mouse pointer in the given bitmap. *)
PROCEDURE mgShowMouse (Bmp: MG_BITMAPptr); CDECL;
	EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'show_mouse';



(* mgGetMousePosition:
 *   Gets the mouse position and button status. *)
PROCEDURE mgGetMousePosition (VAR x, y, b: LONGINT);
BEGIN
  poll_mouse;
  x := mouse_x; 
  y := mouse_y;
  b := mouse_b;
END;



(* mgGetMouseMickeys:
 *   Gets the mouse speed (mickeys) and button status. *)
PROCEDURE mgGetMouseMickeys (VAR x, y, b: LONGINT);
BEGIN
  poll_mouse;
  get_mouse_mickeys (@x, @y);
  b := mouse_b;
END;



(* mgSetMouseWheel:
 *   Sets the mouse wheel position. *)
PROCEDURE mgSetMouseWheel (p: LONGINT); CDECL;
	EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME NAME 'position_mouse_z';



(* mgGetMouseWheel:
 *   Returns the status of the mouse wheel. *)
FUNCTION mgGetMouseWheel: LONGINT;
BEGIN
  poll_mouse;
  mgGetMouseWheel := mouse_z;
END;

END.

