UNIT allegAPI;
(*       _    _
 *      | \  / | O  _ ___  _____  _ __  _____
 *      |  \/  || || `_  \/  _  \| `__|/  _  \
 *      | |\/| || || | | || |_| || |   | |_| |
 *      |_|  |_||_||_| |_||___  ||_|   \____/
 *			    __| |
 *			   \___/
 * 
 *      Interfaces with the Allegro Game Library for internal use only.
 *
 *	Some people would think that all this stuff should be public but I
 *	think that Mingro should be so simple as possible and so platform
 *	independent as possible.  So all this stuff still being private for a
 *	long time.
 *
 *	The order is the same than the used by the Allegro's documentation.
 *
 *      By uo Martnez.
 *
 *      See readme.txt for copyright information.
 *)

INTERFACE

  USES mgBase;

  FUNCTION install_allegro (id: LONGINT; errno: PLONGINT; atexit: POINTER): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE allegro_exit; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE set_uformat (_type: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION install_timer: LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION install_keyboard: LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION set_gfx_mode (card, w, h, v_w, v_h: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE set_color_depth (depth: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE set_color_conversion (_mode: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION load_bitmap (filename: PCHAR; pal: POINTER): POINTER; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION save_bitmap (filename: PCHAR; bmp: POINTER; pal: POINTER): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE blit (source, dest: POINTER; source_x, source_y, dest_x, dest_y, width, height: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION text_length (f: POINTER; str: PCHAR): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE textout_ex (bmp: POINTER; f: POINTER; s: PCHAR; x, y, color, bg: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION install_sound (digi, midi: LONGINT; path: POINTER): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION load_sample (filename: PCHAR): POINTER; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION play_sample (spl: POINTER; vol, pan, freq, loop: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION load_midi (filename: PCHAR): POINTER; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION play_midi (midi: POINTER; loop: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  PROCEDURE adjust_sample (spl: POINTER; vol, pan, freq, loop: LONGINT); CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getr (c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getg (c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getb (c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getr_depth (color_depth, c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getg_depth (color_depth, c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION getb_depth (color_depth, c: LONGINT): LONGINT; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION load_datafile (filename: PCHAR): POINTER; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;
  FUNCTION load_datafile_object (filename, objectname: PCHAR): POINTER; CDECL; EXTERNAL ALLEGRO_SHARED_LIBRARY_NAME;



IMPLEMENTATION

END.

