#include <stdlib.h>
#include "main.h"

/*
 * The usual xmalloc and xrealloc type routines, for allocating memory
 * and bombing out if it fails.
 */

void *xm(size_t sz)
{
	void *p;
	p = malloc(sz);
	if (p == NULL) abort_with_error("out of memory");
	return p;
}

void *xr(void *p, size_t sz)
{
	p = realloc(p, sz);
	if (p == NULL) abort_with_error("out of memory");
	return p;
}

/* expand array */
void *xpnd(void *p, int nit, int *sit, size_t sz)
{
	if (nit < *sit) return p;
	else if (*sit > 0) return xr(p, sz * (*sit *= 2));
	else return xm(sz * (*sit = 10));
}
