#include <assert.h>
#include <allegro.h>
#include "config.h"
#include "main.h"

/*
 * This module handles loading images and selecting the right one.
 */

#define NUMTRAINIMAGES 18

static BITMAP *trains[NUMTRAINIMAGES];
static const char *trainfilenames[] =
{
	SHAREPATH "Tlul.bmp",
	SHAREPATH "Tlur.bmp",
	SHAREPATH "Tl_l.bmp",
	SHAREPATH "Tl_r.bmp",
	SHAREPATH "Tldl.bmp",
	SHAREPATH "Tldr.bmp",
	SHAREPATH "T_ul.bmp",
	SHAREPATH "T_ur.bmp",
	SHAREPATH "T__l.bmp",
	SHAREPATH "T__r.bmp",
	SHAREPATH "T_dl.bmp",
	SHAREPATH "T_dr.bmp",
	SHAREPATH "Trul.bmp",
	SHAREPATH "Trur.bmp",
	SHAREPATH "Tr_l.bmp",
	SHAREPATH "Tr_r.bmp",
	SHAREPATH "Trdl.bmp",
	SHAREPATH "Trdr.bmp"
};

/*
 *        up     none    down   |  left   none   right
 * there  -1       0       1    |   -1      0      1
 */
BITMAP *image_train(int vdir, int hdir, int turn)
{
	int idx = turn + (vdir+1)*2 + (hdir+1)*6;
	assert(idx >= 0);
	assert(idx < NUMTRAINIMAGES);
	return trains[idx];
}

#define NUMENEMYBITMAPS 12

static BITMAP *enemies[NUMENEMYBITMAPS];
static const char *enemyfilenames[] =
{
	SHAREPATH "Ens.bmp",
	SHAREPATH "Ess.bmp",
	SHAREPATH "Ews.bmp",
	SHAREPATH "Ees.bmp",
	SHAREPATH "En.bmp",
	SHAREPATH "Es.bmp",
	SHAREPATH "Ew.bmp",
	SHAREPATH "Ee.bmp",
	SHAREPATH "Enh.bmp",
	SHAREPATH "Esh.bmp",
	SHAREPATH "Ewh.bmp",
	SHAREPATH "Eeh.bmp"
};

BITMAP *image_enemy(int vdir, int hdir, int moving)
{
	int idx = -1;

	if (vdir == -1 && hdir == 0) idx = 0;
	else if (vdir == 1 && hdir == 0) idx = 1;
	else if (hdir == -1 && vdir == 0) idx = 2;
	else if (hdir == 1 && vdir == 0) idx = 3;
	else assert(0);

	idx += 4*moving;
	assert(idx >= 0);
	assert(idx < NUMENEMYBITMAPS);
	return enemies[idx];
}

BITMAP *image_bullet;

static BITMAP *load_or_die(const char *filename)
{
	BITMAP *ret = load_bitmap(filename, NULL);
	if (ret == NULL) abort_with_error("Cannot load %s: %s", filename,
		allegro_error);
	return ret;
}

void load_images(void)
{
	int ix;
	for (ix = 0; ix < NUMTRAINIMAGES; ix++)
		trains[ix] = load_or_die(trainfilenames[ix]);
	for (ix = 0; ix < NUMENEMYBITMAPS; ix++)
		enemies[ix] = load_or_die(enemyfilenames[ix]);
	image_bullet = load_or_die(SHAREPATH "B.bmp");
}
