#ifdef GAME_INT_H
#error "multiple include"
#endif
#define GAME_INT_H

/*
 * Various things exported from game.c because draw.c needs them.
 */

typedef struct
{
	int y, x;
	int hdir; /* -1 left, 0 none, 1 right */
	int vdir; /* -1 up,   0 none, 1 down  */
	int turn; /*          0 left, 1 right */
	int crashed;
	int steps; /* how many steps since last move */

	/* Need this to teleport only once at a time. */
	int justteleported;

	/* And don't reflect forever, either. */
	int justreflected;

	/* You can't fire multiple times from the same spot. */
	int canfire;

	/* For restarting the level. */
	int spawny, spawnx;
	int gameovercount; /* When this hits 0, you restart. */
} train_t;
extern train_t train;

#define MAXMONSTERS 256
typedef struct
{
	int y, x;
	int hdir;
	int vdir;
	int alive; /* hack: set to -1 to indicate collapsing */
	int steps;
} monster_t;
extern monster_t monsters[MAXMONSTERS];
extern int nummonsters;
extern int numlivingmonsters;
extern int timetics; /* time before you lose */

#define MAXBULLETS 256
typedef struct
{
	int y, x;
	int hdir;
	int vdir;
	int inuse;
	int steps;
} bullet_t;
extern bullet_t bullets[MAXBULLETS];
extern int numbullets;

int clipx(int n);
int clipy(int n);
void checkmonstersanity(int mt);
void checkbulletsanity(int bt);

#define LEFT -1
#define UP -1
#define NONE 0
#define DOWN 1
#define RIGHT 1

#define TURN_LEFT 0
#define TURN_RIGHT 1

/*
 * I specifically chose STEPS_PER_MOVE to be the same as FONT_WIDTH
 * and FONT_HEIGHT, in font.h. Now it's different, but FONT_WIDTH and
 * FONT_HEIGHT are a multiple, so it's good enough I guess.
 */
#define STEPS_PER_MOVE 8 /* Number of steps for a full move */

extern int titlescreen; /* Drawing code needs this, for obvious reasons */
