#include <assert.h>
#include <allegro.h>
#include "font.h"
#include "main.h"

/*
 * This module maintains a set of bitmaps constituting a scaled-up
 * version of Allegro's default font, used for the ASCII art train
 * tracks and on the title screen.
 */

#define MAXDRAWCHAR  126
#define DEFFONT_WIDTH  8
#define DEFFONT_HEIGHT 8

BITMAP *scaledfonts[MAXDRAWCHAR+1];
BITMAP *scratch;

static void scalechar(int c)
{
	char cs[2] = " ";
	cs[0] = c;
	if (scratch == NULL)
	{
		scratch = create_bitmap(DEFFONT_WIDTH, DEFFONT_HEIGHT);
		if (scratch == NULL)
		{
			abort_with_error("Can't create scratch bitmap: %s",
				allegro_error);
		}
	}
	clear_bitmap(scratch);
	scaledfonts[c] = create_bitmap(FONT_WIDTH, FONT_HEIGHT);
	if (scaledfonts[c] == NULL)
	{
		abort_with_error("Can't create bitmap to scale font: %s",
			allegro_error);
	}
	clear_bitmap(scaledfonts[c]);
	textout_ex(scratch, font, cs, 0, 0,
		1, /* color -- arbitrary, just must not be 0  */
		-1);
	stretch_blit(scratch, scaledfonts[c],
		0, 0, DEFFONT_WIDTH, DEFFONT_HEIGHT,
		0, 0, FONT_WIDTH, FONT_HEIGHT);
}

void drawchar(BITMAP *target, int x, int y, int c, int color, int bg)
{
	assert(c >= 0);
	assert(c <= MAXDRAWCHAR);
	if (scaledfonts[c] == NULL)
		scalechar(c);
	draw_character_ex(target, scaledfonts[c], x, y, color, bg);
}
