/*
 * Here's where the color themes are set up. I was hoping to make more
 * than two, but these were the only attempts that worked passably
 * well. And the brown/blue one, "chip world", still sucks pretty bad.
 *
 * If you have any design sense, please add a decent theme and email
 * me about it.
 */

enum
{
	BLACK = 0,
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	BROWN,
	LIGHT_GRAY,
	GRAY,
	LIGHT_BLUE,
	LIGHT_GREEN,
	LIGHT_CYAN,
	LIGHT_RED,
	LIGHT_MAGENTA,
	YELLOW,
	WHITE
};

int status_color;    /* Status text */
int status_em_color; /* Emphasized status text */
int status_bg;       /* Status bars background color */
int view_color;      /* Color of the tracks */
int view_bg;         /* View area background color */

int themes[][5] =
{
	{WHITE,     YELLOW, BROWN, LIGHT_BLUE, BLUE},  /* chip world */
	{WHITE,     YELLOW, GRAY,  LIGHT_GRAY, BLACK}  /* old school */
};

#define NUMTHEMES (sizeof themes / sizeof themes[0])

static int lasttheme = -1;

void reset_colors(void)
{
	lasttheme = -1;
}

void setup_colors(void)
{
	if (lasttheme == -1) lasttheme = 0;
	else lasttheme = (lasttheme+1) % NUMTHEMES;

	status_color    = themes[lasttheme][0];
	status_em_color = themes[lasttheme][1];
	status_bg       = themes[lasttheme][2];
	view_color      = themes[lasttheme][3];
	view_bg         = themes[lasttheme][4];
}
