#include "PlayArea.h"


PlayArea::PlayArea() : Widget() {
	NewGame(2);
	QUAD_FONT = Skin::nFonts;
	skin->LoadFont("fnt6.pcx", QUAD_FONT);
}


void PlayArea::Draw(Bitmap &canvas) {
    char num[2];
	int ax, ay, offX, offY, x, y;

	Color cf = skin->c_face;
	Color cb = skin->c_back;
	Color c1 = skin->c_shad1;
	Color c2 = skin->c_shad2;
	Font f = skin->GetFont(QUAD_FONT);

	offX = (w() - tileSize*nTiles)/2;
	offY = (h() - tileSize*nTiles)/2;
	
	if (offX || offY) {
		canvas.Clear(cf);
	}

	text_mode(-1);
    for (ay=0, y=offY; ay<nTiles; ay++, y+=tileSize) {
		x=offX;
    	for (ax=0; ax<nTiles; ax++, x+=tileSize) {
    	    if (active[ax][ay]) {
				canvas.Draw3DFrame(x, y, x+tileSize-1, y+tileSize-1, cf, c1, c2);
				usprintf(num, "%d", number[ax][ay]);
				f.GUITextout(canvas, num, x+(tileSize/2)-1, (y)+((tileSize-14)/2), c2, c1, -1, 2);
			}
			else {
				canvas.Draw3DFrame(x, y, x+tileSize-1, y+tileSize-1, cb, cb, cb);
			}
		}
    }

    DrawCursor(canvas);
}

void PlayArea::DrawCursor(Bitmap &canvas) {
	Color cs = skin->c_select;
	Color c1 = skin->c_shad1;
	Color c2 = skin->c_shad2;

	int x = (w() - tileSize*nTiles)/2 + cx*tileSize;
	int y = (h() - tileSize*nTiles)/2 + cy*tileSize;
	
	canvas.Draw3DFrame(x,   y,   x+tileSize-1, y+tileSize-1, cs, c1, c2);
	canvas.Draw3DFrame(x+3, y+3, x+tileSize-4, y+tileSize-4, cs, c2, c1);
	if (tileSize >= 18)	canvas.Draw3DFrame(x+6, y+6, x+tileSize-7, y+tileSize-7, cs, c1, c2);
	if (tileSize >= 24)	canvas.Draw3DFrame(x+9, y+9, x+tileSize-10, y+tileSize-10, cs, c2, c1);
	if (tileSize >= 30)	canvas.Draw3DFrame(x+12, y+12, x+tileSize-13, y+tileSize-13, cs, c1, c2);
}


bool PlayArea::CanDo(int mx, int my, bool left, bool right, bool up, bool down) {
    int moves = 0;
    bool ret = true;

    if (mx>=0 && mx<nTiles && my>=0 && my<nTiles)
        moves = number[mx][my];
    else
        return false;
    
    if (left || right || up || down) {
        for (int x=0; x<moves; x++) {
    	    if (active[mx][my] && mx>=0 && mx<nTiles && my>=0 && my<nTiles) {
    			if (left)	mx--;
    			else if (right)	mx++;
    			if (up)		my--;
    			else if (down)	my++;
			}
    	    else {
    			ret = false;
    			break;
    	    }
        }
    }
    else
        ret = false;
        
    return ret;
}


int PlayArea::MovesLeft(int mx, int my) {
	int ret = 0;
	if (CanDo(mx-1, my-1, 1, 0, 1, 0))		ret++;
	if (CanDo(mx-1, my,   1, 0, 0, 0))		ret++;
	if (CanDo(mx-1, my+1, 1, 0, 0, 1))		ret++;
	if (CanDo(mx,   my-1, 0, 0, 1, 0))		ret++;
	if (CanDo(mx,   my+1, 0, 0, 0, 1))		ret++;
	if (CanDo(mx+1, my-1, 0, 1, 1, 0))		ret++;
	if (CanDo(mx+1, my,   0, 1, 0, 0))		ret++;
	if (CanDo(mx+1, my+1, 0, 1, 0, 1))		ret++;
	return ret;
}

	
void PlayArea::MsgClick() {
	Widget::MsgClick();
    int mx, my;
    bool left = false;
    bool right = false;
    bool up = false;
    bool down = false;

	Point mp = GetMousePos();
    mx = (mp.x() - (w() - tileSize*nTiles)/2)/tileSize;
    my = (mp.y() - (h() - tileSize*nTiles)/2)/tileSize;

    if		(mx-cx == 1  && my-cy > -2 && my-cy < 2)	right = true;
    else if (mx-cx == -1 && my-cy > -2 && my-cy < 2)	left  = true;
    if 		(my-cy == 1  && mx-cx > -2 && mx-cx < 2)	down  = true;
    else if (my-cy == -1 && mx-cx > -2 && mx-cx < 2)	up    = true;
    
	Move(mx,my, left,right,up,down);
}


bool PlayArea::MsgChar(int c) {
	Widget::MsgChar(c);
    int mx, my;
    bool left = false;
    bool right = false;
    bool up = false;
    bool down = false;
    
    int cc = c>>8;
    switch (cc) {
    	case KEY_UP:
    	case KEY_8_PAD:
			up = true;
			break;
    	case KEY_DOWN:
    	case KEY_2_PAD:
			down = true;
			break;
    	case KEY_LEFT:
    	case KEY_4_PAD:
			left = true;
			break;
    	case KEY_RIGHT:
    	case KEY_6_PAD:
			right = true;
			break;
    	case KEY_HOME:
    	case KEY_7_PAD:
			up = true;
    		left = true;
			break;
    	case KEY_PGUP:
    	case KEY_9_PAD:
			up = true;
    		right = true;
			break;
    	case KEY_END:
    	case KEY_1_PAD:
			down = true;
    		left = true;
			break;
    	case KEY_PGDN:
    	case KEY_3_PAD:
			down = true;
    		right = true;
			break;
    	default:
			return false;
			break;
    };

    mx = cx;
    my = cy;
    if (left)		mx--;
    else if (right)	mx++;
    if (up)		my--;
    else if (down)	my++;

	Move(mx,my, left,right,up,down);
    return true;
}


void PlayArea::Move(int mx, int my, bool left, bool right, bool up, bool down) {
    if (CanDo(mx, my, left, right, up, down)) {
    	int moves = number[mx][my];
    	points += moves*moves;
    	movesMade++;
    	tilesVisited += moves;
        for (int i=0; i<moves; i++) {
    	    if (left)		cx--;
    	    else if (right)	cx++;
    	    if (up)		cy--;
    	    else if (down)	cy++;
			active[cx][cy] = false;
        }
		Redraw();

		GetParent()->HandleEvent(*this, UPDATE_STATISTICS);
    	CheckForEndGame();
    }
}


void PlayArea::CheckForEndGame() {
	if (MovesLeft(cx, cy) == 0) {
	    finnished = true;
		GetParent()->HandleEvent(*this, GAME_OVER);
	}
}

	
void PlayArea::Reset() {
	double rnd = 1.035742;
	int cursor;
	for (int y=0; y<nTiles; y++) {
		for (int x=0; x<nTiles; x++) {
			rnd *= 1.00056462;
			srand((int)(time(0)*rnd));
			number[x][y] = (rand() % (9 - gameType/2))+1;
			active[x][y] = true;
		}
	}
	cursor = rand() % (nTiles*nTiles);
	cx = ldiv(cursor, nTiles).quot;
	cy = ldiv(cursor, nTiles).rem;
	active[cx][cy] = false;
	points = 0;
	movesMade = 0;
	tilesVisited = 0;
	finnished = false;

	if (GetParent()) {
		GetParent()->HandleEvent(*this, UPDATE_STATISTICS);
		Redraw();
	}
}


void PlayArea::NewGame(int type) {
	if (type != -1) {
		gameType = type;
	}
	
	switch (gameType) {
		case 0:
			nTiles = 30;
			tileSize = 14;
			break;
		
		case 1:
			nTiles = 27;
			tileSize = 16;
			break;
		
		case 2:
			nTiles = 24;
			tileSize = 18;
			break;
		
		case 3:
			nTiles = 21;
			tileSize = 20;
			break;
		
		case 4:
			nTiles = 18;
			tileSize = 24;
			break;
		
		case 5:
			nTiles = 15;
			tileSize = 28;
			break;
		
		case 6:
			nTiles = 12;
			tileSize = 36;
			break;

		case 7:
			nTiles = 9;
			tileSize = 48;
			break;
	};
	
	Reset();
}
