#include "MainDlg.h"
#include "HighScore.h"
#include "HighScoreDlg.h"

////////////////////////////////////////////////////////////////////////////////
// Constructor
MainDlg::MainDlg() : Dialog() {
    // Initialize the objects
    //                    x,    y,    w,    h,    key,    flags,  object specific data
	panelMain.Setup(      6,   25,  628,  452,      0,        0);
	panelInfo.Setup(    194,    2,  440,   20,      0,        0);
	tInfo.ClearFlag(D_AUTOSIZE);
	tInfo.Setup(        194,    6,  440,   12,      0,        0, "Quad v1.2 (c) 2002 by Miran Amon", 2);

	pPlayArea.Setup(     12,   31,  440,  440,      0,        0);
	playArea.Setup(      16,   35,  432,  432,      0,        0);

	pStats.Setup(       458,   31,  170,  140,      0,        0);
	tLeft.Setup(        474,   51,   80,   20,      0,        0, "Left:", 0);
	tMoves.Setup(       474,   81,   80,   20,      0,        0, "Moves:", 0);
	tTiles.Setup(       474,  101,   80,   20,      0,        0, "Tiles:", 0);
	tAvg.Setup(         474,  121,   80,   20,      0,        0, "Average:", 0);
	tScore.Setup(       474,  141,   80,   20,      0,        0, "Score:", 0);
	nLeft.Setup(        554,   51,   50,   19,      0,D_DISABLED,"0", 5);
	nMoves.Setup(       554,   81,   50,   19,      0,D_DISABLED,"0", 5);
	nTiles.Setup(       554,  101,   50,   19,      0,D_DISABLED,"0", 5);
	nAvg.Setup(         554,  121,   50,   19,      0,D_DISABLED,"0", 5);
	nScore.Setup(       554,  141,   50,   19,      0,D_DISABLED,"0", 5);
	UpdateStatistics();

	pInstructions.Setup(458,  177,  170,  294,      0,        0);
	lInstructions.InsertItem(new ListItemString("How to play:"), 0);
	lInstructions.InsertItem(new ListItemString(""), 1);
	lInstructions.InsertItem(new ListItemString("Move in any direction"), 2);
	lInstructions.InsertItem(new ListItemString("by as many tiles as"), 3);
	lInstructions.InsertItem(new ListItemString("the number on the first"), 4);
	lInstructions.InsertItem(new ListItemString("first one says."), 5);
	lInstructions.InsertItem(new ListItemString("Every tile can be vi-"), 6);
	lInstructions.InsertItem(new ListItemString("sited only once. You"), 7);
	lInstructions.InsertItem(new ListItemString("get as many points as"), 8);
	lInstructions.InsertItem(new ListItemString("is the length of your"), 9);
	lInstructions.InsertItem(new ListItemString("journey squared"), 10);
	lInstructions.InsertItem(new ListItemString("(e.g. for 5 tiles you"), 11);
	lInstructions.InsertItem(new ListItemString("would get 25 points)"), 12);
	lInstructions.Setup(462,  181,  162,  286,      0, D_DISABLED);

	kNewGame[0].Setup(KEY_N);
	Add(kNewGame[0]);
	for (int i=1; i<9; i++) {
		kNewGame[i].Setup(KEY_F1+i-1);
		Add(kNewGame[i]);
	}
	kQuit.Setup(KEY_Q, KB_CTRL_FLAG);

	// Add the objects to the dialog
    Add(desktop);
	Add(kQuit);

	Add(panelMain);
	Add(panelInfo);
	Add(tInfo);
	Add(pPlayArea);
	Add(playArea);

	Add(pStats);
	Add(tLeft);		Add(nLeft);
	Add(tMoves);	Add(nMoves);
	Add(tTiles);	Add(nTiles);
	Add(tAvg);		Add(nAvg);
	Add(tScore);	Add(nScore);

	Add(pInstructions);
	Add(lInstructions);

	MakeMenu();
}


void MainDlg::MakeMenu() {
	newGameMenu.Add("Massive (30x30)", NEW_GAME0);
	newGameMenu.Add("Huge (27x27)", NEW_GAME1);
	newGameMenu.Add("Big (24x24)", NEW_GAME2);
	newGameMenu.Add("Medium (21x21)", NEW_GAME3);
	newGameMenu.Add("Small (18x18)", NEW_GAME4);
	newGameMenu.Add("Very small (15x15)", NEW_GAME5);
	newGameMenu.Add("Tiny (12x12)", NEW_GAME6);
	newGameMenu.Add("Miniature (9x9)", NEW_GAME7);
	
    fileMenu.Add("&High scores", HIGH_SCORES);
    fileMenu.Add("E&xit\tCtrl-Q", CLOSE_DIALOG);

    mainMenu.Add("&File", fileMenu);
    mainMenu.Add("&New game", newGameMenu);
	Add(mainMenu);
} 

////////////////////////////////////////////////////////////////////////////////
// The event handling functions
////////////////////////////////////////////////////////////////////////////////

void MainDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);
	
	if (obj == playArea) {
		switch (msg) {
			case PlayArea::UPDATE_STATISTICS:
				UpdateStatistics();
				break;

			case PlayArea::GAME_OVER:
				MessageBox msg("Game over!", "No more moves!", NULL, NULL, "OK");
				msg.Popup(this);
				UpdateHSC();
				playArea.NewGame();
				break;
		};
	}
	else {
		switch (msg) {
			case MSG_ACTIVATE:
				if (obj == kQuit) Close();
				else for (int i=0; i<9; i++) {
					if (obj == kNewGame[i]) {
						playArea.NewGame(i-1);
						UpdateStatistics();
					}
				}
				break;

			case CLOSE_DIALOG:
				Close();
				break;

			case NEW_GAME0:		playArea.NewGame(0);	UpdateStatistics();		break;
			case NEW_GAME1:		playArea.NewGame(1);	UpdateStatistics();		break;
			case NEW_GAME2:		playArea.NewGame(2);	UpdateStatistics();		break;
			case NEW_GAME3:		playArea.NewGame(3);	UpdateStatistics();		break;
			case NEW_GAME4:		playArea.NewGame(4);	UpdateStatistics();		break;
			case NEW_GAME5:		playArea.NewGame(5);	UpdateStatistics();		break;
			case NEW_GAME6:		playArea.NewGame(6);	UpdateStatistics();		break;
			case NEW_GAME7:		playArea.NewGame(7);	UpdateStatistics();		break;

			case HIGH_SCORES:
				ShowHSC();
				break;
		};
	}
}


void MainDlg::UpdateStatistics() {
	char buf[5];
	usprintf(buf, "%d", playArea.MovesLeft());					nLeft.SetText(buf);
	usprintf(buf, "%d", playArea.MovesMade());					nMoves.SetText(buf);
	usprintf(buf, "%d", playArea.TilesVisited());				nTiles.SetText(buf);
	if (playArea.MovesMade() > 0)
		usprintf(buf, "%d", playArea.Score()/playArea.MovesMade());
	else
		usprintf(buf, "---");
	nAvg.SetText(buf);
	usprintf(buf, "%d", playArea.Score());						nScore.SetText(buf);
}


void MainDlg::UpdateHSC() {
	HighScore hsc;
	char name[8];
	usprintf(name, "%d.hsc", playArea.GameType());
	hsc.Load(name);
	if (hsc.GetPlacement(playArea.Score()) != -1) {
		MessageBox msg("Congratulations!", "You have a high-score!", NULL, NULL, "OK");
		msg.Popup(this);
		HighScoreDlg hDlg(playArea.GameType(), playArea.Score(), playArea.MovesMade(), playArea.TilesVisited());
		hDlg.SetParent(this);
		hDlg.Popup();
	}
}


void MainDlg::ShowHSC() {
	HighScoreDlg hDlg(playArea.GameType());
    hDlg.SetParent(this);
	hDlg.Popup();
}


bool MainDlg::MsgClose() {
	MessageBox msg("Quad", "Are you sure?", NULL, NULL, "Yes", "No");
	if (msg.Popup(this) == 1) {
		return true;
	}
	else {
		return false;
	}
	return Dialog::MsgClose();
}
