#ifndef		QUAD_PLAYAREA
#define		QUAD_PLAYAREA

#include <MASkinG.h>
using namespace MAS;

class PlayArea : public Widget {
	protected:
		int nTiles, tileSize, gameType;
		int active[30][30];
		int number[30][30];
		int cx, cy;
		int movesMade, tilesVisited;
		bool finnished;
		int points;
		int QUAD_FONT;

		bool CanDo(int, int, bool, bool, bool, bool);
		void Move(int, int, bool, bool, bool, bool);
		int MovesLeft(int, int);
		void CheckForEndGame();
		void DrawCursor(Bitmap &canvas);
		void Reset();

    public:
		PlayArea();

		void Draw(Bitmap &canvas);
		void MsgClick();
		bool MsgChar(int c);
		bool MsgWantfocus(void) { return true; }

		enum { UPDATE_STATISTICS=MSG_SUSER, GAME_OVER };

		void NewGame(int type=-1);
		int Score() { return points; }
		int MovesMade() { return movesMade; }
		int TilesVisited() { return tilesVisited; }
		int MovesLeft() { return MovesLeft(cx, cy); }
		int GameType() { return gameType; }
};

#endif
