#include "HighScoreDlg.h"

class ListItemHiscore : public ListItemString {
	public:
		ListItemHiscore(const char *t) : ListItemString(t) {}
		int h() {
			return 14;
		}
};

HighScoreDlg::HighScoreDlg(int gameType, int nsc, int nmv, int ntl)
	: Window()
{
	title.SetText("HighScores");
	clientArea->Resize(345, 250);

	hsc = new HighScore;
	usprintf(fileName, "%d.hsc", gameType);
	hsc->Load(fileName);

	newscore = nsc;
	newmoves = nmv;
	newtiles = ntl;
	already_added = false;
	
	lSize.SetText("Choose board size");
	cmbSize.list.InsertItem(new ListItemString("Massive (30x30)"), 0);
	cmbSize.list.InsertItem(new ListItemString("Huge (27x27)"), 1);
	cmbSize.list.InsertItem(new ListItemString("Big (24x24)"), 2);
	cmbSize.list.InsertItem(new ListItemString("Medium (21x21)"), 3);
	cmbSize.list.InsertItem(new ListItemString("Small (18x18)"), 4);
	cmbSize.list.InsertItem(new ListItemString("Very small (15x15)"), 5);
	cmbSize.list.InsertItem(new ListItemString("Tiny (12x12)"), 6);
	cmbSize.list.InsertItem(new ListItemString("Miniature (9x9)"), 7);
	cmbSize.list.Select(gameType);

	line1.SetText("pos name                 mvs tls score");
	line2.SetText("Enter your name:");
	eName.SetText("", 20);
	buttonOK.Setup(0,0,0,0, KEY_O, D_EXIT, "&OK");

	if (nsc == 0) {
		eName.SetText("  ...when you get a high-score :)", 35);
		eName.Disable();
		line2.Disable();
	}
	else {
		buttonOK.Disable();
		line1.Disable();
		list.Disable();
		cmbSize.Disable();
	}

	UpdateList();

	// Add the objects to the dialog
	Add(line1);
	Add(list);
	Add(line2);
	Add(eName);
	Add(buttonOK);
	Add(lSize);
	Add(cmbSize);
}


HighScoreDlg::~HighScoreDlg() {
	delete hsc;
}


void HighScoreDlg::UpdateSize() {
	Window::UpdateSize();
	lSize.Shape(10, 16, 120, 16);
	cmbSize.Shape(134, 10, 200, 24);
	line1.Shape(10,  40, 324,  16);
	list.Shape(10,  56, 324, 125);
	line2.Shape(10, 194, 100,  16);
	eName.Shape(110, 190, 224,  24);
	buttonOK.Shape(10, 222,	324,  24);
}


void HighScoreDlg::MsgInitSkin() {
	Window::MsgInitSkin();
	
	line1.SetFont(Skin::nFonts, Skin::NORMAL);
	line1.SetFont(Skin::nFonts, Skin::SELECT);
	line1.SetFont(Skin::nFonts, Skin::DISABLE);
	line1.SetFont(Skin::nFonts, Skin::FOCUS);

	list.SetFont(Skin::nFonts, Skin::NORMAL);
	list.SetFont(Skin::nFonts, Skin::SELECT);
	list.SetFont(Skin::nFonts, Skin::DISABLE);
	list.SetFont(Skin::nFonts, Skin::FOCUS);
	Centre();
}


void HighScoreDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);
	if (msg == MSG_ACTIVATE) {
		if (obj == eName) {
			if (!already_added) {
				int i=hsc->GetPlacement(newscore);
				hsc->Add(eName.GetText(), newscore, newmoves, newtiles);
				hsc->Save(fileName);
				eName.SetText("");
				eName.Disable();
				line2.Disable();
				buttonOK.Enable();
				line1.Enable();
				list.Enable();
				cmbSize.Enable();
				UpdateList();
				list.Select(i);
				already_added = true;
				simulate_keypress(KEY_TAB<<8);
			}
		}
		else if (obj == cmbSize){
			delete hsc;
			hsc = new HighScore;
			usprintf(fileName, "%d.hsc", cmbSize.list.Selection());
			hsc->Load(fileName);
			UpdateList();
		}
	}
}


void HighScoreDlg::UpdateList() {
	int i;
	char buf[41];
	buf[40] = '\0';
	list.DeleteAllItems();
	for (i=0; i<hsc->size; i++) {
		usprintf(buf, "%02d\xB3%-20s\xB3%03d\xB3%03d\xB3%05d", i+1,
			     hsc->name[hsc->order[i]],
				 hsc->moves[hsc->order[i]],
				 hsc->tiles[hsc->order[i]],
				 hsc->score[hsc->order[i]]);
		list.InsertItem(new ListItemHiscore(buf), i);
	}
}
