#include "HighScore.h"

HighScore::HighScore() {
	size = 25;

	for (int i=0; i<size; i++) {
		ustrncpy(name[i], " --- nobody ---    ", 20);
		score[i] = 0;
		moves[i] = 0;
		tiles[i] = 0;
		order[i] = i;
	}
}

HighScore::~HighScore() { }


bool HighScore::Add(char n[20], int s, int m, int t) {
	int place = GetPlacement(s);

	if (place == -1)
		return false;
	else {
		ustrncpy(name[order[size-1]], n, 20);
		score[order[size-1]] = s;
		moves[order[size-1]] = m;
		tiles[order[size-1]] = t;
		int temp = order[size-1];
		for (int i=size-1; i>place; i--)
			order[i] = order[i-1];
		order[place] = temp;
		return true;
	}
}


int HighScore::GetPlacement(int s) {
	for (int i=0; i<size; i++) {
		if (score[order[i]] < s) {
			return i;
		}
	}

	return -1;
}


void HighScore::Save(char *file) {
	FILE *f = fopen(file, "wb");
	if (!f) return;

	int hi, lo;
	long sc, mv, tl;
	unsigned char ch;

	for (int i=0; i<size; i++) {
		for (int j=0; j<20; j++) {
			ch = name[order[i]][j];
			if (ch >= 128)
				ch = 0x20;
			ch += 80;
			fputc(ch, f);
		}
		sc = score[order[i]] + 12345;
		hi = sc / 65536;
		lo = sc % 65536;
		fputc(hi/256, f);
		fputc(hi%256, f);
		fputc(lo/256, f);
		fputc(lo%256, f);

		mv = moves[order[i]] + 12345;
		hi = mv / 65536;
		lo = mv % 65536;
		fputc(hi/256, f);
		fputc(hi%256, f);
		fputc(lo/256, f);
		fputc(lo%256, f);

		tl = tiles[order[i]] + 12345;
		hi = tl / 65536;
		lo = tl % 65536;
		fputc(hi/256, f);
		fputc(hi%256, f);
		fputc(lo/256, f);
		fputc(lo%256, f);
	}

	fclose(f);
}


void HighScore::Load(char *file) {
	FILE *f = fopen(file, "rb");
	if (!f) return;

	long sc, mv, tl;

	for (int i=0; i<size; i++) {
		order[i] = i;
		for (int j=0; j<20; j++)
			name[order[i]][j] = fgetc(f) - 80;
		sc = fgetc(f) << 24;
		sc += fgetc(f) << 16;
		sc += fgetc(f) << 8;
		sc += fgetc(f);
		score[order[i]] = sc - 12345;

		mv = fgetc(f) << 24;
		mv += fgetc(f) << 16;
		mv += fgetc(f) << 8;
		mv += fgetc(f);
		moves[order[i]] = mv - 12345;

		tl = fgetc(f) << 24;
		tl += fgetc(f) << 16;
		tl += fgetc(f) << 8;
		tl += fgetc(f);
		tiles[order[i]] = tl - 12345;
	}

	fclose(f);
}
