/* Pyrastak */
/* (c)2001 Robin Burrows rburrows@bigfoot.com */
/* www.geocities.com/rburrowsgc/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <allegro.h>
#include "pyrastak.h"
#include "pyradata.h"
#ifdef USEJGMOD
#include "jgmod.h"

JGMOD * gamexm;
#endif

int HSGetHighest (char *);
void HSEnterHighscore (char *, int, int);

DATAFILE * commondata;
FONT * gamefont;
volatile int fpsdelay, fps, fpscounter, fpstimer;
int redraw = 0;
static int fliptype = 0;

static int oldmx, oldmy;
static int explodalready;

static int scoradd;
static int gameover;
static CELL nexts[8];
static int nextshunt;
static int pixdebrisitems;
PIXDEBRIS * pixdebris;
BITMAP * debrisbm;
static BITMAP * bdropbm;
static CELL grid[GRIDSIZE][GRIDSIZE];
static BITMAP * shapes[NUMCOLOURS][NUMSHAPES];
static int currentlevel, linesgot, falldir;
static int score, lastscore, highscore, zaps;
static int playxoff = PLAYXOFF;
static int playyoff = PLAYYOFF;

/* DR system vars */
static CLEARLIST * clearlistpt;
static CLEARLIST * clearlist2pt;
static int clearitems;
static int clearitems2;
static CLEARPIX * pixclearlistpt;
static CLEARPIX * pixclearlist2pt;
static int pixclearitems;
static int pixclearitems2;

/* Designed for both page flip and non-pageflip modes
 * using double buffer and DRS
 */
PALETTE gamepal;
BITMAP * dbuffer;
BITMAP * flip3bm;
static BITMAP * dscreen, * bscreen;
static int scroffset;

void FlipScreen (int flipgdi)
/* 0 = normal flip
 * 1 = flip to GDI
 */
{
BITMAP * flip3tempbm;

	if (fliptype == 3) {
		blit (dbuffer, screen, 0, 0, 0, 0, dbuffer->w, dbuffer->h);
		flip3tempbm = dbuffer;
		dbuffer = flip3bm;
		flip3bm = flip3tempbm;
		return;
	}
	if (flipgdi == 1) {
		scroffset = 0;
		show_video_bitmap (screen);
		dbuffer = dscreen;
		return;
	}
	show_video_bitmap (dbuffer);
	if (scroffset) dbuffer = dscreen; else dbuffer = bscreen;
	scroffset = SCRHEIGHT-scroffset;
}

/* Keep the game speed correct on all systems... */
void fpsinterrupt (void)
{
	fpstimer--; if (fpstimer<0)
	{
		fps = fpscounter; fpscounter = 0;
		fpstimer = 59;
	}
	fpsdelay ++;
}
END_OF_FUNCTION (fpsinterrupt);

void DRinit (void)
{
	clearlistpt = malloc (1000*sizeof(CLEARLIST));
	clearlist2pt = malloc (1000*sizeof(CLEARLIST));
	clearitems = 0;	
	clearitems2 = 0;	
	pixclearlistpt = malloc ((MAXDEBRIS+1)*sizeof(CLEARPIX));
	pixclearlist2pt = malloc ((MAXDEBRIS+1)*sizeof(CLEARPIX));
	pixclearitems = 0;	
	pixclearitems2 = 0;	
}

void DRexit (void)
{
	free (clearlistpt);
	free (clearlist2pt);
	free (pixclearlistpt);
	free (pixclearlist2pt);
}

void DRblit (BITMAP * src, BITMAP * dest, int sx, int sy, int dx, int dy, int width, int height)
{
	masked_blit (src, dest, sx, sy, dx, dy, width, height);
	clearlistpt[clearitems].x = dx;
	clearlistpt[clearitems].y = dy;
	clearlistpt[clearitems].w = width;
	clearlistpt[clearitems].h = height;
	clearitems++;
}

void DRClearList (void)
{
int i;
CLEARLIST * myclearpt;
CLEARPIX * mypixclearpt;

	myclearpt = clearlist2pt;
	mypixclearpt = pixclearlist2pt;

	acquire_bitmap (dbuffer);
	for (i=0;i<clearitems2;i++) {
//		rectfill (dbuffer, myclearpt->x, myclearpt->y,
//			myclearpt->x+myclearpt->w, myclearpt->y+myclearpt->h, 0);
		blit (bdropbm, dbuffer, myclearpt->x, myclearpt->y, myclearpt->x, myclearpt->y,
			myclearpt->w, myclearpt->h);
		myclearpt++;
	}
	for (i=0;i<pixclearitems2;i++) {
		putpixel (dbuffer, mypixclearpt->x, mypixclearpt->y,
           bdropbm->line[mypixclearpt->y][mypixclearpt->x]);
		mypixclearpt++;
	}
	release_bitmap (dbuffer);

	myclearpt = clearlist2pt;
	clearlist2pt = clearlistpt;
	clearlistpt = myclearpt;
	clearitems2 = clearitems;
	clearitems = 0;	
	mypixclearpt = pixclearlist2pt;
	pixclearlist2pt = pixclearlistpt;
	pixclearlistpt = mypixclearpt;
	pixclearitems2 = pixclearitems;
	pixclearitems = 0;	
}

void cleargrid (void)
{
int x, y, incx;

	for (y=0;y<GRIDSIZE;y++) {
		for (x=0;x<GRIDSIZE;x++) {
			grid[y][x].block = -2;
			grid[y][x].shape = -2;
			grid[y][x].xoff = 0;
			grid[y][x].yoff = 0;
			grid[y][x].marked = 0;
		}
	}

	incx = 0;
	for (y=(GRIDSIZE-2);y>0;y--) {
		for (x=1+(incx/2);x<((GRIDSIZE-1)-(incx/2));x++) {
			grid[y][x].block = -1;
			grid[y][x].shape = -1;
			grid[y][x].xoff = 0;
			grid[y][x].yoff = 0;
		}
		incx++;
	}

/* temp */
	grid[5][1].block = 0;
	grid[5][1].shape = 0;
	grid[5][2].block = 1;
	grid[5][2].shape = 1;
	grid[5][3].block = 2;
	grid[5][3].shape = 2;
	grid[5][4].block = 3;
	grid[5][4].shape = 3;
	grid[5][5].block = 2;
	grid[5][5].shape = 2;

	grid[4][3].block = 2;
	grid[4][3].shape = 3;
	grid[4][4].block = 3;
	grid[4][4].shape = 1;
	grid[4][2].block = 2;
	grid[4][2].shape = 1;
	grid[4][5].block = 0;
	grid[4][5].shape = 1;
}

void Getgamepal (void)
{
int i;

	for (i=0;i<16;i++) {
		gamepal[i].r = ((RGB *)(commondata[partspal].dat))[i].r;
		gamepal[i].g = ((RGB *)(commondata[partspal].dat))[i].g;
		gamepal[i].b = ((RGB *)(commondata[partspal].dat))[i].b;
	}
	for (i=16;i<32;i++) {
		gamepal[i].r = ((RGB *)(commondata[fontpal].dat))[i].r;
		gamepal[i].g = ((RGB *)(commondata[fontpal].dat))[i].g;
		gamepal[i].b = ((RGB *)(commondata[fontpal].dat))[i].b;
	}
	for (i=32;i<48;i++) {
		gamepal[i].r = ((RGB *)(commondata[blkspal].dat))[i].r;
		gamepal[i].g = 10;
		gamepal[i].b = 10;
	}
	for (i=32;i<48;i++) {
		gamepal[i+16].r = 10;
		gamepal[i+16].g = ((RGB *)(commondata[blkspal].dat))[i].g;
		gamepal[i+16].b = 10;
	}
	for (i=32;i<48;i++) {
		gamepal[i+32].r = 10;
		gamepal[i+32].g = 10;
		gamepal[i+32].b = ((RGB *)(commondata[blkspal].dat))[i].b;
	}
	for (i=32;i<48;i++) {
		gamepal[i+48].r = ((RGB *)(commondata[blkspal].dat))[i].r;
		gamepal[i+48].g = ((RGB *)(commondata[blkspal].dat))[i].g;
		gamepal[i+48].b = 10;
	}
	for (i=96;i<256;i++) {
		gamepal[i].r = ((RGB *)(commondata[bdrop1pal].dat))[i].r;
		gamepal[i].g = ((RGB *)(commondata[bdrop1pal].dat))[i].g;
		gamepal[i].b = ((RGB *)(commondata[bdrop1pal].dat))[i].b;
	}
}

void prettify (void)
{
int x, y;

	for (y=0;y<256;y+=16) {
		for (x=0;x<256;x+=16) {
			rectfill (dbuffer, x, y, x+15, y+15, y+(x/16));
		}
	}
}

void Drawmousecursor (void)
{
int x, y;

	x = mouse_x-16; y = mouse_y-16;

	draw_rle_sprite (dbuffer, commondata[mouseptr].dat, x, y);
	clearlistpt[clearitems].x = x;
	clearlistpt[clearitems].y = y;
	clearlistpt[clearitems].w = ((RLE_SPRITE *) commondata[mouseptr].dat)->w;
	clearlistpt[clearitems].h = ((RLE_SPRITE *) commondata[mouseptr].dat)->h;
	clearitems++;
}

void DrawGrid (void)
{
int x, y, xoadd;

	for (y=0;y<GRIDSIZE;y++) {
		xoadd = (BLKWIDTH/2)*(y&1);
		for (x=0;x<GRIDSIZE;x++) {
			if (grid[y][x].block >= 0) {
				DRblit (shapes[grid[y][x].block][grid[y][x].shape],
					dbuffer, 0, 0, playxoff+(x*64)+xoadd+grid[y][x].xoff,
					playyoff+(y*64)+grid[y][x].yoff,
					BLKWIDTH, BLKHEIGHT);
			}
		}
	}
}

int GetgridX (int xpix, int ypix)
{
	xpix -= playxoff; ypix -= playyoff;
	if (xpix < 0 || ypix < 0) return -1;

	if ((ypix/BLKHEIGHT)&1) xpix -= (BLKWIDTH/2);

	xpix /= BLKWIDTH; ypix /= BLKHEIGHT;
	if (xpix >= GRIDSIZE || ypix >= GRIDSIZE) return -1;

	return xpix;
}

int GetgridY (int xpix, int ypix)
{
	xpix -= playxoff; ypix -= playyoff;
	if (xpix < 0 || ypix < 0) return -1;

	if ((ypix/BLKHEIGHT)&1) xpix -= (BLKWIDTH/2);

	xpix /= BLKWIDTH; ypix /= BLKHEIGHT;
	if (xpix >= GRIDSIZE || ypix >= GRIDSIZE) return -1;

	return ypix;
}

void Drawmouserect (void)
{
int mx, my, mx2, my2;

	mx2 = mouse_x; my2 = mouse_y;
	mx = GetgridX (mx2, my2);
	my = GetgridY (mx2, my2);
	if (mx == -1 || my == -1) return;

	if (grid[my][mx].block >= 0 && grid[my][mx].xoff == 0 &&
		grid[my][mx].yoff == 0) {

		if (oldmx != mx || oldmy != my) {
			play_sample (commondata[move].dat, 255, 128, 2000, 0);
			oldmx = mx; oldmy = my;
		}

		mx *= BLKWIDTH; my *= BLKHEIGHT;
		if ((my/BLKHEIGHT)&1) mx += (BLKWIDTH/2);
		mx += playxoff; my += playyoff;

		rect (dbuffer, mx, my, mx+(BLKWIDTH-1), my+(BLKHEIGHT-1),
			makecol (255, 255, 255));
		clearlistpt[clearitems].x = mx;
		clearlistpt[clearitems].y = my;
		clearlistpt[clearitems].w = BLKWIDTH;
		clearlistpt[clearitems].h = BLKHEIGHT;
		clearitems++;
	}
}

void Gameinit (void)
{
int x, y, col, shp;

		blit (bdropbm, dbuffer, 0, 0, 0, 0,	SCREEN_W, SCREEN_H);
//	clear (dbuffer);
	FlipScreen (0);
		blit (bdropbm, dbuffer, 0, 0, 0, 0,	SCREEN_W, SCREEN_H);
//	clear (dbuffer);
	FlipScreen (0);

	Getgamepal ();
	set_palette (gamepal);

	while (mouse_b & 1);
	fpsdelay = 0;
	highscore = HSGetHighest ("scores");
	gameover = 0; scoradd = 0;
	score = 0; lastscore = 0; nextshunt = 0;
	currentlevel = 1;
	linesgot = 0;
	falldir = 0;
	zaps = 8;
	srand (time(NULL));
	for (x=0;x<8;x++) {
		nexts[x].block = rand()%NUMCOLOURS;
		nexts[x].shape = rand()%NUMSHAPES;
		nexts[x].xoff = 0;
		nexts[x].yoff = 0;
	}

	for (col=0;col<NUMCOLOURS;col++) {
	for (shp=0;shp<NUMSHAPES;shp++) {
		shapes[col][shp] = create_bitmap (
		((BITMAP *)(commondata[blk1+shp].dat))->w,
		((BITMAP *)(commondata[blk1+shp].dat))->h);
		for (y=0;y<(((BITMAP *)(commondata[blk1+shp].dat))->h);y++) {
		for (x=0;x<(((BITMAP *)(commondata[blk1+shp].dat))->w);x++) {
		if (getpixel ((BITMAP *)(commondata[blk1+shp].dat), x, y))
		putpixel (shapes[col][shp], x, y,
			getpixel ((BITMAP *)(commondata[blk1+shp].dat), x, y)+(col*16));
		else putpixel (shapes[col][shp], x, y, 0);
		} }
//		blit (shapes[col][shp], dbuffer, 0, 0, col*64, shp*64, 64, 64);
	} }

	debrisbm = create_bitmap (SCREEN_W, 72);
	clear (debrisbm);

	pixdebris = malloc ((MAXDEBRIS+1)*sizeof(PIXDEBRIS));
	pixdebrisitems = 0;
}

void Gameexit (void)
{
int col, shp;

	for (col=0;col<NUMCOLOURS;col++) {
		for (shp=0;shp<NUMSHAPES;shp++) {
			destroy_bitmap (shapes[col][shp]);
		}
	}
	destroy_bitmap (debrisbm);
}

void Explodeblock (int x, int y)
{
int gx, gy, i;

	gx = x; gy = y;
	x *= BLKWIDTH; x += playxoff;
	if (y&1) x += (BLKWIDTH/2);
	y *= BLKHEIGHT; y += playyoff;
	x += 6; y += 6;

	if (!explodalready) {
		explodalready = 1;
		play_sample (commondata[explode].dat, 255, 128, 1000, 0);
	}
	for (i=0;i<500;i++) {
		if (pixdebrisitems<MAXDEBRIS) {
		pixdebris[pixdebrisitems].colour = 32+(grid[gy][gx].block*16)+(rand()%16);
		pixdebris[pixdebrisitems].x = itofix (x+(rand()%(BLKWIDTH-12)));
		pixdebris[pixdebrisitems].y = itofix (y+(rand()%(BLKHEIGHT-12)));
		pixdebris[pixdebrisitems].xadd = itofix ((rand()%30)-15);
		pixdebris[pixdebrisitems].yadd = itofix ((rand()%30)-22);
		pixdebris[pixdebrisitems].xadd /= 100;
		pixdebris[pixdebrisitems].yadd /= 100;
		pixdebrisitems++;
		}
	}
}

int Amassdebris (int x, int y, int col)
{
int i;

	y -= (SCREEN_H-debrisbm->h);
	if (y < 0) return 0;

	if (y >= debrisbm->h) y = debrisbm->h-1;
	if (!getpixel (debrisbm, x, y+1) && y != (debrisbm->h-1)) return 0;
	i = 0; while (getpixel (debrisbm, x, y-i) > 0) i--;
	putpixel (debrisbm, x, y-i, col);
	return -1;
}

void Movedebris (void)
{
int i;

	for (i=0;i<pixdebrisitems;i++) {
		pixdebris[i].x += pixdebris[i].xadd;
		pixdebris[i].y += pixdebris[i].yadd;
		pixdebris[i].yadd += (itofix (1)/10);
		if (pixdebris[i].x < (itofix(0)) || 
			pixdebris[i].x > (itofix(SCREEN_W))) {
				pixdebrisitems--;
				pixdebris[i].colour = pixdebris[pixdebrisitems].colour;
				pixdebris[i].x = pixdebris[pixdebrisitems].x;
				pixdebris[i].y = pixdebris[pixdebrisitems].y;
				pixdebris[i].xadd = pixdebris[pixdebrisitems].xadd;
				pixdebris[i].yadd = pixdebris[pixdebrisitems].yadd;
		} else {
			if (Amassdebris (fixtoi(pixdebris[i].x),
				fixtoi(pixdebris[i].y), pixdebris[i].colour)) {
				pixdebrisitems--;
				pixdebris[i].colour = pixdebris[pixdebrisitems].colour;
				pixdebris[i].x = pixdebris[pixdebrisitems].x;
				pixdebris[i].y = pixdebris[pixdebrisitems].y;
				pixdebris[i].xadd = pixdebris[pixdebrisitems].xadd;
				pixdebris[i].yadd = pixdebris[pixdebrisitems].yadd;
			}
		}
	}
}

void Drawdebris (void)
{
int i;

	masked_blit (debrisbm, dbuffer, 0, 0, 0, SCREEN_H-debrisbm->h,
		debrisbm->w, debrisbm->h);

	for (i=0;i<pixdebrisitems;i++) {
		putpixel (dbuffer,
			fixtoi(pixdebris[i].x), fixtoi(pixdebris[i].y),
			pixdebris[i].colour);
		pixclearlistpt[i].x = fixtoi(pixdebris[i].x);
		pixclearlistpt[i].y = fixtoi(pixdebris[i].y);
		pixclearitems++;
	}
}

void Topdroplogic (void)
{
int i;

	nextshunt--;
	if (nextshunt < 0) {
		nextshunt = (BLKWIDTH*4);
		if (grid[1][GRIDSIZE/2].block != -1) {
			gameover = 1;
			return;
		}
		grid[1][GRIDSIZE/2].block = nexts[0].block;
		grid[1][GRIDSIZE/2].shape = nexts[0].shape;
		grid[1][GRIDSIZE/2].xoff = 0;
		grid[1][GRIDSIZE/2].yoff = -(playyoff+BLKHEIGHT);
		for (i=0;i<7;i++) {
			nexts[i].block = nexts[i+1].block;
			nexts[i].shape = nexts[i+1].shape;
			nexts[i].xoff = nexts[i+1].xoff;
			nexts[i].yoff = nexts[i+1].yoff;
		}
		nexts[7].block = rand()%NUMCOLOURS;
		nexts[7].shape = rand()%NUMSHAPES;
		nexts[7].xoff = 0;
		nexts[7].yoff = 0;
		play_sample (commondata[drop].dat, 255, 128, 1000, 0);
	}
}

void Topdropdraw (void)
{
int i;

	for (i=0;i<8;i++) {
		if (nextshunt < (BLKWIDTH*2)) DRblit (shapes[nexts[i].block][nexts[i].shape],
			dbuffer, 0, 0, playxoff+((GRIDSIZE/2)*BLKWIDTH)+(i*BLKWIDTH)+(BLKWIDTH/2), 0,
			BLKWIDTH, BLKHEIGHT);
		if (nextshunt >= (BLKWIDTH*2) && nextshunt < (BLKWIDTH*3))
			DRblit (shapes[nexts[i].block][nexts[i].shape], dbuffer, 0, 0,
			playxoff+((GRIDSIZE/2)*BLKWIDTH)+(nextshunt-(BLKWIDTH*2))+(i*BLKWIDTH)+(BLKWIDTH/2),
			0, BLKWIDTH, BLKHEIGHT);
		if (nextshunt >= (BLKWIDTH*3)) DRblit (shapes[nexts[i].block][nexts[i].shape],
			dbuffer, 0, 0, playxoff+((GRIDSIZE/2+1)*BLKWIDTH)+(i*BLKWIDTH)+(BLKWIDTH/2), 0,
			BLKWIDTH, BLKHEIGHT);
	}
}

void Falldown (void)
{
int x, y, offs;

	for (y=(GRIDSIZE-1);y>0;y--) {
		offs = y&1;
//		for (x=1;x<(GRIDSIZE-1);x++) {
		if (falldir) x=(GRIDSIZE-2); else x=1;
		while (1) {
			if (grid[y][x].xoff > 0) grid[y][x].xoff--;
			if (grid[y][x].xoff < 0) grid[y][x].xoff++;
			if (grid[y][x].xoff == 0 && grid[y][x].yoff < 0) grid[y][x].yoff++;

			if (grid[y][x].block == -1) {
			if (grid[y-1][(x+offs)-1].block >= 0 &&
				grid[y-1][(x+offs)].block < 0) {
			if (!grid[y-1][(x+offs)-1].xoff && !grid[y-1][(x+offs)-1].yoff) {
			grid[y][x].block = grid[y-1][(x+offs)-1].block;
			grid[y][x].shape = grid[y-1][(x+offs)-1].shape;
			grid[y][x].xoff = -(BLKWIDTH/2);
			grid[y][x].yoff = -BLKHEIGHT;

			grid[y-1][(x+offs)-1].block = -1;
			grid[y-1][x+(y&1)].xoff = 0;
			grid[y-1][x+(y&1)].yoff = 0;

			} }
			else { if (grid[y-1][(x+offs)-1].block < 0 &&
				grid[y-1][(x+offs)].block >= 0) {
			if (!grid[y-1][(x+offs)].xoff && !grid[y-1][(x+offs)].yoff) {
			grid[y][x].block = grid[y-1][(x+offs)].block;
			grid[y][x].shape = grid[y-1][(x+offs)].shape;
			grid[y][x].xoff = (BLKWIDTH/2);
			grid[y][x].yoff = -BLKHEIGHT;

			grid[y-1][(x+offs)].block = -1;
			grid[y-1][x+(y&1)].xoff = 0;
			grid[y-1][x+(y&1)].yoff = 0;
			} } }
			}
			if (falldir) x--; else x++;
			if (x == 0 || x == (GRIDSIZE-1)) break;
		}
	}
}

void Clickblock (void)
{
int mx, my, mx2, my2;

	mx2 = mouse_x; my2 = mouse_y;
	mx = GetgridX (mx2, my2);
	my = GetgridY (mx2, my2);
	if (mx == -1 || my == -1) return;

	if (grid[my][mx].block >= 0) {
		zaps--;
		Explodeblock (mx, my);
		grid[my][mx].block = -1;
	}
}

void Winninglines (void)
{
int x, y, offs, llen, zapadd, scoradd2;

	zapadd = 0; scoradd2 = 0;
	for (y=(GRIDSIZE-1);y>0;y--) {
		offs = y&1;
		for (x=1;x<(GRIDSIZE-1);x++) {
			if (grid[y][x].block >= 0 && !grid[y][x].marked &&
				grid[y][x].xoff == 0 && grid[y][x].yoff == 0) {
			llen = 1;
			while (grid[y][x].block == grid[y][x+llen].block &&
				grid[y][x].xoff == 0 && grid[y][x+llen].yoff == 0 &&
				!grid[y][x+llen].marked &&
				grid[y][x+llen].block >= 0) llen++;
			if (llen == 3) { scoradd2 += 50; zapadd += 1; linesgot++; }
			if (llen == 4) { scoradd2 += 150; zapadd += 2; linesgot+=2; }
			if (llen == 5) { scoradd2 += 500; zapadd += 3; linesgot+=3; }
			if (llen > 6) { scoradd2 += 1000; zapadd += 4; linesgot+=4; }
			if (llen > 2) { while (llen) { llen--; grid[y][x+llen].marked = 1; } }
			}

			if (grid[y][x].block >= 0 && !grid[y][x].marked &&
				grid[y][x].xoff == 0 && grid[y][x].yoff == 0) {
			llen = 1;
			while (grid[y][x].shape == grid[y][x+llen].shape &&
				grid[y][x].xoff == 0 && grid[y][x+llen].yoff == 0 &&
				!grid[y][x+llen].marked &&
				grid[y][x+llen].block >= 0) llen++;
			if (llen == 3) { scoradd2 += 50; zapadd += 1; linesgot++; }
			if (llen == 4) { scoradd2 += 150; zapadd += 2; linesgot+=2; }
			if (llen == 5) { scoradd2 += 500; zapadd += 3; linesgot+=3; }
			if (llen > 6) { scoradd2 += 1000; zapadd += 4; linesgot+=4; }
			if (llen > 2) { while (llen) { llen--; grid[y][x+llen].marked = 1; } }
			}

		}
	}

	for (y=(GRIDSIZE-1);y>0;y--) {
		for (x=1;x<(GRIDSIZE-1);x++) {
			if (grid[y][x].marked) {
				grid[y][x].marked = 0;
				Explodeblock (x, y);
				grid[y][x].block = -1;
			}
		}
	}
	if (scoradd2) {
		score += scoradd2;
		scoradd += scoradd2;
	}
	if (zapadd) {
		zaps += zapadd;
	}
	while (linesgot >= 10) {
		currentlevel++;
		linesgot-=10;
		score += (currentlevel*100); zaps += 1;
		play_sample (commondata[roar].dat, 255, 128, 500, 0);
		for (y=3;y>0;y--) {
			for (x=1;x<(GRIDSIZE-1);x++) {
				if (grid[y][x].block>=0) Explodeblock (x, y);
				grid[y][x].block = -1;
			}
		}
	}
}

void Showscore (void)
{
char scoretxt[128];

	sprintf (scoretxt, "Score: %d", score);
	textout (dbuffer, commondata[mainfont].dat, scoretxt, 0, 0, -1);
	sprintf (scoretxt, "Last combo: %d", lastscore);
	textout (dbuffer, commondata[mainfont].dat, scoretxt, 0, 20, -1);
	sprintf (scoretxt, "Zaps: %d", zaps);
	textout (dbuffer, commondata[mainfont].dat, scoretxt, 0, 40, -1);
	sprintf (scoretxt, "Level: %d (%d to next)", currentlevel, 10-linesgot);
	textout (dbuffer, commondata[mainfont].dat, scoretxt, 0, 60, -1);
	sprintf (scoretxt, "Highscore: %d", highscore);
	textout (dbuffer, commondata[mainfont].dat, scoretxt, 0, 80, -1);


	if (!zaps) textout_centre (dbuffer, commondata[mainfont].dat, "No zaps!", SCREEN_W/2, SCREEN_H-60, -1);
	clearlistpt[clearitems].x = 0;
	clearlistpt[clearitems].y = 0;
	clearlistpt[clearitems].w = 152;
	clearlistpt[clearitems].h = 100;
	clearitems++;
}

void Showfalldir (void)
{
	if (falldir) draw_rle_sprite (dbuffer, commondata[rightarr].dat, 20, 220);
	else draw_rle_sprite (dbuffer, commondata[leftarr].dat, 20, 220);

	clearlistpt[clearitems].x = 20;
	clearlistpt[clearitems].y = 220;
	clearlistpt[clearitems].w = ((RLE_SPRITE *) commondata[leftarr].dat)->w;
	clearlistpt[clearitems].h = ((RLE_SPRITE *) commondata[leftarr].dat)->h;
	clearitems++;
}

void StartGame (void)
{
int mousedn, rmsedn, lloops;

	mousedn = 0; rmsedn = 0;
	cleargrid ();
	DRinit ();
	Gameinit ();

	while (!gameover) {
		FlipScreen (0);
		DRClearList ();
		DrawGrid ();
		Topdropdraw ();
		Drawmouserect ();
		Drawdebris ();
		Showfalldir ();
		Drawmousecursor ();
		Showscore ();

		while (!fpsdelay); lloops = fpsdelay; fpsdelay = 0;
		while (lloops) {
			explodalready = 0;
			if (mousedn && !(mouse_b&1)) mousedn = 0;
			if (rmsedn && !(mouse_b&2)) rmsedn = 0;
			if (!mousedn && (mouse_b&1) && zaps) {
				if (scoradd) {
					lastscore = scoradd; scoradd = 0;
				}
				mousedn = 1;
				Clickblock ();
			}
			if (!rmsedn && (mouse_b&2)) {
				rmsedn = 1; falldir = 1-falldir;
			}
			Falldown ();
			Topdroplogic ();
			Movedebris ();
			Winninglines ();
			lloops--;
		}
		if (key[KEY_ESC]) { while (key[KEY_ESC]); break; }
	}

	if (scoradd) {
		lastscore = scoradd;
		score += scoradd;
	}
	DRexit ();
	Gameexit ();
	HSEnterHighscore ("scores", score, currentlevel);

#ifdef USEJGMOD
	gamexm = NULL;
	if (gamexm==NULL && modvol) {
		packfile_password (NULL);
		gamexm = load_mod ("BDATA\\INGAME.XM");
		if (gamexm == NULL) gamexm = load_mod ("BDATA\\INGAME.S3M");
		if (gamexm == NULL) gamexm = load_mod ("BDATA\\INGAME.MOD");
		if (gamexm == NULL) {
			gamexm = load_mod ("BDATA\\MUSIC.DAT#INGAME.XM");
		}
		if (gamexm!=NULL) {
			play_mod (gamexm, TRUE); 
			set_mod_volume (modvol);
		}
	}
#endif
#ifdef USESEAL
	SEALStartMusic (1);
#endif

	score = 0;
	currentlevel = 1;
	linesgot = 0;

#ifdef USEJGMOD
	if (gamexm!=NULL) { stop_mod (); destroy_mod (gamexm); gamexm = NULL; }
#endif
#ifdef USESEAL
	SEALStopMusic ();
#endif
}

int mainmenu (void)
{
	while (key[KEY_ESC]);
	while (mouse_b & 1);
	clear (dbuffer);
	Getgamepal ();
	set_palette (gamepal);
    blit (commondata[bdrop1].dat, dbuffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    text_mode (-1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Pyrastak", SCREEN_W/2, 10, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"(C)2001 Robin Burrows <rburrows@bigfoot.com>", SCREEN_W/2, 50, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"http://www.geocities.com/rburrowsgc/", SCREEN_W/2, 80, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Click blocks to zap them", SCREEN_W/2, 110, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Match 3 or more same colour blocks HORIZONTALLY or", SCREEN_W/2, 140, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Match 3 or more same shape blocks HORIZONTALLY", SCREEN_W/2, 170, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"for points and extra zaps", SCREEN_W/2, 200, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Click right mouse button to change gravity direction", SCREEN_W/2, 230, -1);
	textout_centre (dbuffer, commondata[mainfont].dat,
		"Click mouse to start ... Press ESC to exit", SCREEN_W/2, 340, -1);

	FlipScreen (0);
	while (1) {
		if (key[KEY_ESC]) return 5;
		if (mouse_b & 1) return 1;
	}
}

void RedrawAll (void) { redraw = 2; }

int main (int argc, char * argv[])
{
int choice;

	allegro_init ();
	install_timer ();
	install_keyboard ();
	install_mouse ();

//	ReadPrefs ();
	fliptype = 0; if (argc > 1) {
		if (!strcmp(argv[1], "-fliptype3")) fliptype = 3;
		if (!strcmp(argv[1], "-fliptype4")) fliptype = 4;
		if (fliptype < 0 || fliptype > 4) fliptype = 3;
	}

//#ifdef USEALLEGSND
	reserve_voices (16, -1);
	if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0)
        {
	        printf ("Error initializing sound card");
//	        return 1;
        }
//#endif
#ifdef USEJGMOD
	if (install_mod (12)==-1) { } //allegro_exit (); return -1; }
#endif

	dscreen = NULL; bscreen = NULL;
	if (fliptype == 4) { choice = GFX_AUTODETECT_WINDOWED; fliptype = 0; }
	else { choice = GFX_AUTODETECT; }
	if (set_gfx_mode (choice, SCRWIDTH, SCRHEIGHT, 0, SCRHEIGHT*2)<0) {
	if (set_gfx_mode (choice, SCRWIDTH, SCRHEIGHT, 0, 0)<0) {
		allegro_exit ();
		allegro_message ("Couldn't open screen in 640*480*8\n");
		return 0;
	} }
	if (fliptype != 3) {
		dscreen = create_video_bitmap (SCRWIDTH, SCRHEIGHT);
		dbuffer = dscreen;
		bscreen = create_video_bitmap (SCRWIDTH, SCRHEIGHT);
		if (bscreen == NULL) return 0;
		scroffset = 0;
	} else {
		dbuffer = create_bitmap (SCRWIDTH, SCRHEIGHT);
		flip3bm = create_bitmap (SCRWIDTH, SCRHEIGHT);
		if (dbuffer == NULL || flip3bm == NULL) return 0;
	}
	set_window_title ("Pyrastak V1.0");
	set_display_switch_callback(SWITCH_IN, RedrawAll);
#ifdef USESEAL
	SEALOpen ();	
#endif
	FlipScreen (0);
	FlipScreen (1);

	commondata = load_datafile ("pyradata.dat");
	if (commondata == NULL) {
		return 0;
	}

/* Lock 'n load FPS routines under interrupt */
	fpsdelay = 0; fps = 0; fpstimer = 0; fpscounter = 0;
	LOCK_VARIABLE (fpsdelay); LOCK_VARIABLE (fps);
	LOCK_VARIABLE (fpstimer); LOCK_VARIABLE (fpscounter);
	LOCK_FUNCTION (fpsinterrupt);
	install_int_ex (fpsinterrupt, BPS_TO_TIMER(LOGICFPS));

	gamefont = commondata[mainfont].dat;
    bdropbm = commondata[bdrop1].dat;

	while (1) {
		choice = mainmenu ();
		if (choice == 1) StartGame ();
		if (choice == 5) break;
	}

	clear (dbuffer);
	FlipScreen (1);

	remove_int (fpsinterrupt);
#ifdef USESEAL
	SEALStopMusic ();
	SEALClose ();
#endif
	if (fliptype != 3) {
		if (dscreen != NULL) destroy_bitmap (dscreen);
		if (bscreen != NULL) destroy_bitmap (bscreen);
	} else {
		destroy_bitmap (dbuffer);
		destroy_bitmap (flip3bm);
	}
	if (commondata != NULL) unload_datafile (commondata);
//	allegro_exit ();

	return 0;
}
END_OF_MAIN();
