#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include "pyradata.h"

typedef struct {
char name[32];
int score;
int level;
} HSENTRY;

void FlipScreen (int);

extern FONT * gamefont;
extern BITMAP * dbuffer;

static HSENTRY hsboard[10];

void HSGenerateDefaultHighscores (void)
{
int i;

	for (i=0;i<10;i++) {
		strcpy (hsboard[i].name, "Pyrastak");
		hsboard[i].score = 1000-(i*100);
		hsboard[i].level = 1;
	}
}


int HSReadHighscores (FILE * hsfpt)
{
int i, j, hsval, hscheck, hscheck2;
char hsfbuf[4096];

	hscheck = 0; hscheck2 = 0;
	for (i=0;i<4096;i++) hsfbuf[i] = 0;
	fread (hsfbuf, 1, 4096, hsfpt);
	for (i=0;i<4096;i++) if (hsfbuf[i] < ' ') hsfbuf[i] = 0;

	i = 0; while (i<4000) {
		if (!strncmp ("version", hsfbuf+i, 7)) {
			hsval = atoi (hsfbuf+i+8);
			if (hsval != 1) return -1;
		}
		if (!strncmp ("entry", hsfbuf+i, 5)) {
			hsval = atoi (hsfbuf+i+6);
			while (hsfbuf[i] != 0) i++;
			while (hsfbuf[i] == 0) i++;
			strcpy (hsboard[hsval].name, hsfbuf+i);
			while (hsfbuf[i] != 0) i++;
			while (hsfbuf[i] == 0) i++;
			hsboard[hsval].score = atoi (hsfbuf+i);
			while (hsfbuf[i] != 0) i++;
			while (hsfbuf[i] == 0) i++;
			hsboard[hsval].level = atoi (hsfbuf+i);
		}
		if (!strncmp ("checksum", hsfbuf+i, 8)) {
			hsval = atoi (hsfbuf+i+9);
			j = 0;
			while (j<i) {
				hscheck += ((j/12)*hsfbuf[j]);
				j++;
			}
			if (hscheck == hsval) hscheck2 = 1;
		}

		while (hsfbuf[i] != 0) i++;
		while (hsfbuf[i] == 0) i++;
	}
	if (hscheck2 == 0) return -1;
	return 0;
}

int HSSaveHighscores (FILE * hsfpt)
{
int i, hspos, hscheck;
char hssavebuf[4096];

	sprintf (hssavebuf, "version=1\x0d\x0a");
	hspos = 11;
	for (i=0;i<10;i++) {
		sprintf (hssavebuf+hspos, "entry=%d\x0d\x0a", i);
		hspos += strlen (hssavebuf+hspos);
		sprintf (hssavebuf+hspos, "%s\x0d\x0a", hsboard[i].name);
		hspos += strlen (hssavebuf+hspos);
		sprintf (hssavebuf+hspos, "%d\x0d\x0a", hsboard[i].score);
		hspos += strlen (hssavebuf+hspos);
		sprintf (hssavebuf+hspos, "%d\x0d\x0a", hsboard[i].level);
		hspos += strlen (hssavebuf+hspos);
	}
	hscheck = 0;
	i = 0; while (i<hspos) {
		if (hssavebuf[i] >= ' ') hscheck += ((i/12)*hssavebuf[i]);
		i++;
	}
	sprintf (hssavebuf+hspos, "checksum=%d\x0d\x0a", hscheck);
	hspos += strlen (hssavebuf+hspos);
	fwrite (hssavebuf, 1, hspos, hsfpt);
	return 0;
}

int HSGetHighest (char * hsfname)
{
FILE * fpt;
char hsrealname[256];

	strcpy (hsrealname, hsfname);
	strcat (hsrealname, ".txt");

	fpt = fopen (hsrealname, "rb");
	if (fpt == NULL) {
		HSGenerateDefaultHighscores ();
	} else {
		if (HSReadHighscores (fpt)) { fclose (fpt); return 1000000; }
		fclose (fpt);
	}
	return hsboard[0].score;
}

void HSDisplayHighscores (void)
{
int i;
char hsnumbuf[32];
BITMAP * hsbm;

	clear (dbuffer);
	FlipScreen (0);
	clear (dbuffer);

	acquire_bitmap (dbuffer);
	textout_centre (dbuffer, gamefont, "Plucky Pyrastak perfectionists", SCREEN_W/2, 0, -1);
	textout (dbuffer, gamefont, "Rank", 24, 62, -1);
	textout (dbuffer, gamefont, "Name", 96, 62, -1);
	textout (dbuffer, gamefont, "Score", 440, 62, -1);
	textout (dbuffer, gamefont, "Level", 530, 62, -1);
	for (i=0;i<10;i++) {
		sprintf (hsnumbuf, "%d", i+1);
		textout (dbuffer, gamefont, hsnumbuf, 42, 94+(i*30), -1);
		textout (dbuffer, gamefont, hsboard[i].name, 96, 94+(i*30), -1);
		sprintf (hsnumbuf, "%d", hsboard[i].score);
		textout (dbuffer, gamefont, hsnumbuf, 440, 94+(i*30), -1);
		sprintf (hsnumbuf, "%d", hsboard[i].level);
		textout (dbuffer, gamefont, hsnumbuf, 540, 94+(i*30), -1);
	}
	release_bitmap (dbuffer);

	hsbm = dbuffer;
	FlipScreen (0);
	blit (hsbm, dbuffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	FlipScreen (0);
}

void HSEnterName (int pos)
{
int i, j;

	rect (dbuffer, 92, 90+(pos*30), 
		420, 116+(pos*30), makecol (255, 0, 0));
	FlipScreen (0);
	rect (dbuffer, 92, 90+(pos*30), 
		420, 116+(pos*30), makecol (255, 0, 0));
	clear_keybuf();
	if (pos<10) i = 0; else i = 30; while (1) {
		if (i<28) {
			j = readkey();
			if ((j>>8) == KEY_ENTER) { if (i == 0) {
					strcpy (hsboard[pos].name, "Mr Enterkey");
				}
				i = 30;
				rect (dbuffer, 92, 90+(pos*30), 
					420, 116+(pos*30), 0);
				text_mode (0);
				textout (dbuffer, gamefont, hsboard[pos].name,
					96, 94+(pos*30), makecol (255,255,255));
				FlipScreen (0);
				rect (dbuffer, 92, 90+(pos*30), 
					420, 116+(pos*30), 0);
				textout (dbuffer, gamefont, hsboard[pos].name,
					96, 94+(pos*30), makecol (255,255,255));
					break;
			}
			if (((j>>8) == KEY_BACKSPACE) && (i>0)) { i--;
			hsboard[pos].name[i] = 0;
			text_mode (0);
			rectfill (dbuffer, 93, 91+(pos*30), 
				419, 114+(pos*30), 0);
			textout (dbuffer, gamefont, hsboard[pos].name,
				96, 94+(pos*30), makecol (255,255,255));
			FlipScreen (0);
			rectfill (dbuffer, 93, 91+(pos*30), 
				419, 114+(pos*30), 0);
			textout (dbuffer, gamefont, hsboard[pos].name,
				96, 94+(pos*30), makecol (255,255,255));
			}
			if (((j>>8)==KEY_SPACE) || ((j&0xFF)>=' ')) {
			hsboard[pos].name[i] = j; i++;
			hsboard[pos].name[i] = 0;
			text_mode (0);
			textout (dbuffer, gamefont, hsboard[pos].name,
				96, 94+(pos*30), makecol (255,255,255));
			FlipScreen (0);
			textout (dbuffer, gamefont, hsboard[pos].name,
				96, 94+(pos*30), makecol (255,255,255));
			}
			while (key[KEY_ENTER]); while (key[KEY_SPACE]);
		} else break;
	}
	while (key[KEY_ENTER]);
}

void HSEnterHighscore (char * hsfname, int hsscore, int hslevel)
{
int i, hscrpos, hssaveneeded;
FILE * fpt;
char hsrealname[256];
char noscmsg[256];

	strcpy (hsrealname, hsfname);
	strcat (hsrealname, ".txt");

	fpt = fopen (hsrealname, "rb");
	if (fpt == NULL) {
		HSGenerateDefaultHighscores ();
	} else {
		if (HSReadHighscores (fpt)) { fclose (fpt); return; }
		fclose (fpt);
	}

	for (hscrpos=0;hscrpos<10;hscrpos++) {
		if (hsscore > hsboard[hscrpos].score) break;
	}
	for (i=8;i>=hscrpos;i--) {
		hsboard[i+1] = hsboard[i];
	}
	if (hscrpos<10) {
		hsboard[hscrpos].name[0] = 0;
		hsboard[hscrpos].score = hsscore;
		hsboard[hscrpos].level = hslevel;
		hssaveneeded = 1;
		HSDisplayHighscores ();
		textout_centre (dbuffer, gamefont,
			"Please enter your name in the high score table", SCREEN_W/2, 400,
			makecol (255, 255, 255));
		FlipScreen (0);
		textout_centre (dbuffer, gamefont,
			"Please enter your name in the high score table", SCREEN_W/2, 400,
			makecol (255, 255, 255));
		HSEnterName (hscrpos);
	} else {
		hssaveneeded = 0;
		HSDisplayHighscores ();
		if (hslevel > 0) {
			sprintf (noscmsg, "Your score was %d on level %d", hsscore, hslevel);
			textout_centre (dbuffer, gamefont, noscmsg, SCREEN_W/2, 400,
				makecol (255, 255, 255));
			FlipScreen (0);
			textout_centre (dbuffer, gamefont, noscmsg, SCREEN_W/2, 400,
				makecol (255, 255, 255));
		}
	}

	while (1) {
		if (key[KEY_ESC] || key[KEY_SPACE] || key[KEY_ENTER]) break;
		if (mouse_b & 1) break;
	}

	if (hssaveneeded) {
		fpt = fopen (hsrealname, "wb");
		if (fpt == NULL) return;
		HSSaveHighscores (fpt);
		fclose (fpt);
	}
}
