#include "std_include.h"


// ======================================================================================
// copy a file from disk into memory
//
// input :
//   name          = pointer on the file paths & name
//   buffer_length = pointer on a variable that will receive the size of the file
//
// output
//   return a pointer on a copy of the file in mem, NULL if error
// ======================================================================================
char * read_file_in_mem(char * name, long * buffer_length)
{
   FILE * in;
   long length;
   char * buffer;


   // init
   * buffer_length = length = 0;

   // open
   in = fopen(name, "rb");
   if (in == NULL)
   {
      printf("read_file_in_mem() : can't open %s\n", name);
      return NULL;
   }

   // get size
   fseek(in, 0, SEEK_END);
   length = ftell(in);
   fseek(in, 0, SEEK_SET);

   // malloc
   buffer = (char *) malloc(length);
   if (buffer == NULL)
   {
      fclose(in);
      printf("read_file_in_mem() : can't allocate %li bytes for %s\n", length, name);
      return NULL;
   }

   // copy in mem
   fread(buffer, length, 1, in);

   // end
   fclose(in);
   * buffer_length = length;
   return buffer;
}
