#ifndef _BOX_H_

#define _BOX_H_


typedef struct
{
   int x1, y1; // inclusive, they ARE the offsets to add to the sprite pivot
   int w,  h;  // width and height
   int x2, y2; // x2 = x1 + w, y2 = y1 + h
               // the mouse is in the frame if :
               //    (mouse_x >= x1) && (mouse_y >= y1) &&
               //    (mouse_x < x2)  && (mouse_y < y2)
} BOX_S;


/* A BOX_S is used for knowing both the size of an animation / any image
   and where to place it relatively to its sprite pivot

   for instance let's take a sprite of 50 * 70 pixels.
   Now say that this sprite is a flying baloon, his ground level is under the animation.
   Such a sprite will have a BOX_S that looks like :

      x1 = -25
      w  = 50
      x2 = x1 + w = 25

      y1 = -100
      h  = 70
      y2 = y1 + h = 30


   warning ! Ascii art is coming :


           w 
         <--->   


    x1,y1
         *---.
         |   |            /|\
         |   |             |
         |   |             | h
         |   |             |
         |   |             |
         `---* x2, y2     \|/ 


           +     <---- sprite pivot, always at coordinates 0,0

  In other words, x1 and y1 are offsets to add to the sprite position on the screen
  to draw it correctly, according to its ground level & body size

  NOTE : this BOX_S is the original animation / frame placment when at zoom 1:1
         you need to do maths if you're stretching the animation / frame

*/ 


#endif
