
// ======================================================================================
//
//  NOTE : ALL THE .C AND ALL THE .H ARE USING THESE TABULATION SETTINGS :
//
//    Tab size   : 3
//    Ident size : 3
//    with the option "Insert spaces"
//
//  The allegro library version that I use is 4.0.3
//
// ======================================================================================

#include "std_include.h"

#include "loading_file.h"
#include "loading_bam.h"

// not really necessary
#include "types.h"
#include "animation.h"
#include "box.h"
#include "palette.h"
#include "bam_structs.h"


// ======================================================================================
// global datas
// ======================================================================================
typedef enum {NM_NONE, NM_HAIR, NM_SKIN, NM_CLOTH1, NM_CLOTH2, NM_CLOTH3, NM_END} NM_LAYER;

typedef struct
{
   BITMAP          * scr_buffer;
   BITMAP          * bmp_tmp;
   BITMAP          * bmp_cmap_list;
   char            * bam_file;
   long            bam_length;
   BAM_ANIMATION_S * bam_anim;
   BITMAP          * curr_bmp;
   BITMAP          * cmap_analyse;
   BITMAP          * cmap_prev;
   char            bam_noext[512];
   char            strtmp[512];
} GLB_S;
GLB_S glb;


// ======================================================================================
// exit the program (release all memory)
// used by atexit() at the start of the program
// ======================================================================================
void pst_exit(void)
{
   if (glb.bmp_cmap_list) destroy_bitmap(glb.bmp_cmap_list);
   if (glb.bmp_tmp)       destroy_bitmap(glb.bmp_tmp);
   if (glb.scr_buffer )   destroy_bitmap(glb.scr_buffer);
   if (glb.bam_file)      free(glb.bam_file);
   if (glb.bam_anim)      destroy_bam_animation(glb.bam_anim);
   if (glb.curr_bmp)      destroy_bitmap(glb.curr_bmp);
   if (glb.cmap_analyse)  destroy_bitmap(glb.cmap_analyse);
   if (glb.cmap_prev)     destroy_bitmap(glb.cmap_prev);
}


// ======================================================================================
// save all frames of all directions, and save a special image showing the sprite pivot
// ======================================================================================
void pst_pcx_save(char * bamname)
{
   BITMAP * bmp;
   int    d, f, i, green_idx, shadow_idx, r, g, b;


   if (glb.bam_anim == NULL)
      return;

   bmp = create_bitmap_ex(8, glb.bam_anim->anim->box.w, glb.bam_anim->anim->box.h);
   if (bmp == NULL)
   {
      printf("pst_pcx_save() ERROR :can't create a bitmap of %i * %i pixels\n",
         glb.bam_anim->anim->box.w,
         glb.bam_anim->anim->box.h
      );
      exit(-1);
   }

   green_idx  = 0;
   shadow_idx = 1;
   for (i=0; i < 256; i++)
   {
      r = glb.bam_anim->palette_data.palette[0].color[i].r;
      g = glb.bam_anim->palette_data.palette[0].color[i].g;
      b = glb.bam_anim->palette_data.palette[0].color[i].b;
      if ((r == 0) && (g == 255) && (b == 0))
         green_idx = i;
      else if ((r == 0) && (g == 0) && (b == 0))
         shadow_idx = i;
   }
   if (green_idx == shadow_idx)
   {
      // can't be, but just in case
      green_idx  = 0;
      shadow_idx = 1;
   }

   for (d=0; d < glb.bam_anim->anim->direction_num; d++)
   {
      for (f=0; f < glb.bam_anim->anim->direction[d].frame_num; f++)
      {
         clear_to_color(bmp, green_idx);
         i = glb.bam_anim->anim->direction[d].frame[f].bmp_idx;
         if (glb.bam_anim->anim->bmp[i])
         {
            blit(
               glb.bam_anim->anim->bmp[i],
               bmp,
               0, 0,
               glb.bam_anim->anim->direction[d].frame[f].box.x1 - glb.bam_anim->anim->box.x1,
               glb.bam_anim->anim->direction[d].frame[f].box.y1 - glb.bam_anim->anim->box.y1,
               glb.bam_anim->anim->direction[d].frame[f].box.w,
               glb.bam_anim->anim->direction[d].frame[f].box.h
            );

            // save image
            strcpy(glb.bam_noext, bamname);
            i = strlen(bamname);
            if (i >= 4)
            {
               if (glb.bam_noext[i-4] == '.')
                  glb.bam_noext[i-4] = 0x00;
            }
            sprintf(glb.strtmp, "%s_d%03i_f%03i.pcx", glb.bam_noext, d, f);
            save_pcx(glb.strtmp, bmp, glb.bam_anim->palette_data.al_palette[0]);
         }
      }
   }

   // pivot image
   clear_to_color(bmp, green_idx);
   hline(bmp, 0, - glb.bam_anim->anim->box.y1, glb.bam_anim->anim->box.w, shadow_idx);
   vline(bmp, - glb.bam_anim->anim->box.x1, 0, glb.bam_anim->anim->box.h, shadow_idx);

   strcpy(glb.bam_noext, bamname);
   i = strlen(bamname);
   if (i >= 4)
   {
      if (glb.bam_noext[i-4] == '.')
         glb.bam_noext[i-4] = 0x00;
   }
   sprintf(glb.strtmp, "%s_pivot.pcx", glb.bam_noext);
   save_pcx(glb.strtmp, bmp, glb.bam_anim->palette_data.al_palette[0]);

   // end
   destroy_bitmap(bmp);
}


// ======================================================================================
// entry point
// ======================================================================================
int main(int argc, char ** argv)
{
   int       gfx_bpp    = 32,
             gfx_mode   = GFX_AUTODETECT_WINDOWED,
             gfx_width  = 800,
             gfx_height = 600,
             ret, i, r, g, b, done = FALSE,
             cmap_cursor_redraw = FALSE,
             c, val, coul, x, y, curr_dir=0, curr_frame=0;
   char      * bmp_cmap_name = "data/pal32.bmp",
             * bmp_cmap_idx  = "data/pal32idx.txt";
   BITMAP    * bmp;
   PALETTE   * al_pal, pal_original;
   PALETTE_S * pal;
   int       curr_layer   = NM_HAIR,
             old_layer    = NM_HAIR,
             old_cmap     = 0,
             first_redraw = TRUE,
             show_pivot   = TRUE;
   char      str_tmp[512];
   FILE      * in, * out;
   int       col_white,  col_black, col_red,  col_green, col_blue,
             col_yellow, col_cyan,  col_pink, col_help;
   int       cmap_mul, cmap_add, cmap_h, d, f;
   int       * cmapidx, size;
   struct
   {
      char * desc;
      int  activeable;
      int  active;
      int  scancode;
      int  x0, y0;
      WORD cmap_idx;
   } layer[NM_END] = {
      // desc             activeable  active scancode  x0   y0  cmap_idx
      // --------------   ----------  ------ -------- ---  ---  --------
      { {"xx : None   "}, FALSE,      FALSE, 0,         0,   0,        0},
      { {"F1 : Hair   "}, FALSE,      FALSE, KEY_F1,  100,  30,        0},
      { {"F2 : Skin   "}, FALSE,      FALSE, KEY_F2,  100,  50,        0},
      { {"F3 : Cloth 1"}, FALSE,      FALSE, KEY_F3,  100,  70,        0},
      { {"F4 : Cloth 2"}, FALSE,      FALSE, KEY_F4,  100,  90,        0},
      { {"F5 : Cloth 3"}, FALSE,      FALSE, KEY_F5,  100, 110,        0}
     };


   // some inits
   memset( & glb, 0, sizeof(glb));

   // start allegro
   allegro_init();
   install_keyboard();
   install_timer();

   // prepare exit
   atexit(pst_exit);

   // load BAM
   if ((argc < 2) || (argc > 3))
   {
      printf("syntaxe : pst_colors <file.bam> [-fullscreen]\n");
      exit(0);
   }
   glb.bam_file = read_file_in_mem(argv[1], & glb.bam_length);
   if ( ! glb.bam_file)
   {
      printf("can't read %s\n", argv[1]);
      exit(1);
   }

   // decode BAM
   glb.bam_anim = decode_bam(glb.bam_file, glb.bam_length);
   if (glb.bam_anim == NULL)
   {
      // error
      printf("can't decode the BAM\n");
      exit(1);
   }
   memcpy(pal_original, glb.bam_anim->palette_data.al_palette[0], sizeof(PALETTE));

   // assign colors of the BAM palette to their appropriate layer
   pal = & glb.bam_anim->palette_data.palette[0];
   al_pal = glb.bam_anim->palette_data.al_palette;
   for (i=1; i < 256; i++)
   {
      pal->color[i].z = NM_NONE;
      r = pal->color[i].r;
      g = pal->color[i].g;
      b = pal->color[i].b;

      // which layer is it ?
      if ((r==255) && (g==255) && (b==255))
         pal->color[i].z = NM_NONE;
      else if (((r) && (g==255) && (b==255)) || ((r==0) && (g) && (g==b)))
         pal->color[i].z = NM_CLOTH2;
      else if (((g) && (r==255) && (b==255)) || ((g==0) && (r) && (r==b)))
         pal->color[i].z = NM_CLOTH3;
      else if (((b) && (r==255) && (g==255)) || ((b==0) && (r) && (r==g)))
         pal->color[i].z = NM_SKIN;
      else if (((b==255) && (r==g))          || ((b) && (r==0) && (g==0)))
         pal->color[i].z = NM_CLOTH1;
      else if (((r==255) && (g==b))          || ((r) && (g==0) && (b==0)))
         pal->color[i].z = NM_HAIR;
   }

   // which layers are used in this BAM ?
   for (d=0; d < glb.bam_anim->anim->direction_num; d++)
   {
      for (f=0; f < glb.bam_anim->anim->direction[d].frame_num; f++)
      {
         c   = glb.bam_anim->anim->direction[d].frame[f].bmp_idx;
         bmp = glb.bam_anim->anim->bmp[c];
         for (y=0; y < glb.bam_anim->anim->direction[d].frame[f].box.h; y++)
         {
            for (x=0; x < glb.bam_anim->anim->direction[d].frame[f].box.w; x++)
            {
               c = getpixel(bmp, x, y);
               c = pal->color[c].z;
               if ((c > NM_NONE) && (c < NM_END))
               {
                  layer[c].activeable = TRUE;
                  layer[c].active     = TRUE;
               }
            }
         }
      }
   }

   // retrieve precedent color parameters (if any)
   strcpy(str_tmp, argv[1]);
   str_tmp[strlen(argv[1]) - 4] = 0;
   strcat(str_tmp, "_user.bin");
   in = fopen(str_tmp, "rb");
   if (in)
   {
      for (i=NM_NONE + 1; i < NM_END; i++)
      {
         fread( & layer[i].active,   1, sizeof(layer[i].active),   in);
         if (layer[i].activeable != TRUE)
            layer[i].active = FALSE;
         fread( & layer[i].cmap_idx, 1, sizeof(layer[i].cmap_idx), in);
      }
      fread( & curr_dir,   1, sizeof(curr_dir), in);
      fread( & curr_frame, 1, sizeof(curr_frame), in);
      fread( & show_pivot, 1, sizeof(show_pivot), in);
      fclose(in);
   }

   // fullscreen ?
   if (argc == 3)
   {
      if (stricmp("-fullscreen", argv[2]) == 0)
         gfx_mode = GFX_AUTODETECT_FULLSCREEN;
   }

   // init screen
   set_color_depth(gfx_bpp);
   ret = set_gfx_mode(gfx_mode, gfx_width, gfx_height, 0, 0);
   if (ret < 0)
   {
      gfx_bpp = 24;
      set_color_depth(gfx_bpp);
      ret = set_gfx_mode(gfx_mode, gfx_width, gfx_height, 0, 0);
      if (ret < 0)
      {
         printf("can't initialise screen mode %i*%i 32 or 24 bpp\n"
            "allegro_error = %s\n",
            gfx_width, gfx_height, allegro_error);
         exit(1);
      }
   }

   // find colors
   col_help   = makecol(255, 255, 128);
   col_white  = makecol(255, 255, 255);
   col_black  = makecol(  0,   0,   0);
   col_red    = makecol(255,   0,   0);
   col_green  = makecol(  0, 255,   0);
   col_blue   = makecol(  0,   0, 255);
   col_yellow = makecol(255, 255,   0);
   col_cyan   = makecol(  0, 255, 255);
   col_pink   = makecol(255,   0, 255);

   // screen buffer
   glb.scr_buffer = create_bitmap(gfx_width, gfx_height);
   if (glb.scr_buffer == NULL)
   {
      printf("can't create a BITMAP for screen buffer (%i * %i pixels)\n",
         gfx_width, gfx_height);
      exit(1);
   }
   clear(glb.scr_buffer);

   // load bitmap with gradients of ps:t
   glb.bmp_cmap_list = load_bitmap(bmp_cmap_name, NULL);
   if (glb.bmp_cmap_list == NULL)
   {
      printf("can't load %s\n", bmp_cmap_name);
      exit(1);
   }
   for (i=NM_NONE + 1; i < NM_END; i++)
   {
      if (layer[i].cmap_idx >= glb.bmp_cmap_list->h)
         layer[i].cmap_idx = 0;
   }

   // load corresponding idxs
   in = fopen(bmp_cmap_idx, "rt");
   if (in == NULL)
   {
      printf("can't load %s\n", bmp_cmap_idx);
      exit(1);
   }
   size = sizeof(int) * glb.bmp_cmap_list->h;
   cmapidx = (int *) malloc(size);
   if (cmapidx == NULL)
   {
      fclose(in);
      printf("can't allocate %i bytes for cmap idx\n", size);
      exit(1);
   }
   for (i=0; i < glb.bmp_cmap_list->h; i++)
   {
      fscanf(in, "%i\n", & c);
      if (c < 0)
         c = 0;
      cmapidx[i] = c;
   }
   fclose(in);

   // temp
   size = 7 + strlen(argv[1]);
   c = (gfx_width - size * 8) / 2;
   textprintf(glb.scr_buffer, font, c, 10, col_white, "file = %s", argv[1]);

   cmap_mul = gfx_height / glb.bmp_cmap_list->h;
   cmap_h   = cmap_mul * glb.bmp_cmap_list->h;
   cmap_add = (gfx_height - cmap_h) / 2;
   stretch_blit(glb.bmp_cmap_list, glb.scr_buffer,
                0, 0,
                glb.bmp_cmap_list->w, glb.bmp_cmap_list->h,
                15, cmap_add,
                glb.bmp_cmap_list->w, cmap_h
   );

   for (val=NM_NONE + 1; val < NM_END; val++)
   {
      for (i=0; i < glb.bmp_cmap_list->w; i++)
      {
         c = getpixel(glb.bmp_cmap_list, i, layer[val].cmap_idx);
         vline(glb.scr_buffer, 200 + i, 9 + 20 * val, 17 + 20 * val, c);
      }
   }

   // temp bitmap, for stretch_blit() of current animation frame
   x = glb.bam_anim->anim->box.w;
   y = glb.bam_anim->anim->box.h;
   glb.curr_bmp = create_bitmap(x, y);
   if (glb.curr_bmp == NULL)
   {
      free(cmapidx);
      printf("can't create glb.curr_bmp bitmap\n");
      exit(1);
   }

   // colormap analyse
   glb.cmap_analyse = create_bitmap(256, 256);
   if (glb.cmap_analyse == NULL)
   {
      free(cmapidx);
      printf("can't create glb.cmap_analyse bitmap\n");
      exit(1);
   }

   // colormap preview
   glb.cmap_prev = create_bitmap(256, 25);
   if (glb.cmap_prev == NULL)
   {
      free(cmapidx);
      printf("can't create glb.cmap_prev bitmap\n");
      exit(1);
   }

   // help
   c = col_help;
   textout(glb.scr_buffer, font, "Page Down    = Next Frame",                400, 30, c);
   textout(glb.scr_buffer, font, "Page Up      = Previous Frame",            400, 40, c);

   textout(glb.scr_buffer, font, "End          = Next Direction",            400, 60, c);
   textout(glb.scr_buffer, font, "Home         = Previous Direction",        400, 70, c);

   textout(glb.scr_buffer, font, "Echap        = Screenshots + Save + Quit", 400, 90, c);

   textout(glb.scr_buffer, font, "Up / Down    = Change current Layer",      400, 110, c);
   textout(glb.scr_buffer, font, "Left / Right = Change current Colors",     400, 120, c);
   textout(glb.scr_buffer, font, "F1 ... F5    = Active / Desactive Layer",  400, 130, c);

   textout(glb.scr_buffer, font, "P            = Show / Hide Sprite Pivot",  400, 150, c);
   textout(glb.scr_buffer, font, "S            = Save all frames in PCX",    400, 160, c);

   // main loop
   while ( ! done)
   {
      // keyboard
      if (key[KEY_ESC])
         done = TRUE;
      else
      {
         for (i=1; i < NM_END; i++)
         {
            if (layer[i].activeable == TRUE)
            {
               if (key[layer[i].scancode])
               {
                  layer[i].active = layer[i].active ? FALSE : TRUE;
                  while (key[layer[i].scancode])
                  {
                     // wait until the key is released
                  }
               }
            }
         }

         // color map idx 
         cmap_cursor_redraw = FALSE;
         if (key[KEY_UP])
         {
            while (key[KEY_UP])
            {
               // wait
            }
            if (curr_layer > NM_HAIR)
            {
               curr_layer--;
               cmap_cursor_redraw = TRUE;
            }
         }
         else if (key[KEY_DOWN])
         {
            while (key[KEY_DOWN])
            {
               // wait
            }
            if (curr_layer < NM_CLOTH3)
            {
               curr_layer++;
               cmap_cursor_redraw = TRUE;
            }
         }
         else if (key[KEY_LEFT])
         {
            rest(100);
            if (layer[curr_layer].cmap_idx > 0)
            {
               layer[curr_layer].cmap_idx--;
               cmap_cursor_redraw = TRUE;
            }
         }
         else if (key[KEY_RIGHT])
         {
            rest(100);
            if (layer[curr_layer].cmap_idx < glb.bmp_cmap_list->h - 1)
            {
               layer[curr_layer].cmap_idx++;
               cmap_cursor_redraw = TRUE;
            }
         }
         else if (key[KEY_PGDN])
         {
            rest(40);
            if (curr_frame < glb.bam_anim->anim->direction[curr_dir].frame_num - 1)
               curr_frame++;
            else
               curr_frame = 0;
         }
         else if (key[KEY_PGUP])
         {
            rest(40);
            if (curr_frame > 0)
               curr_frame--;
            else
               curr_frame = glb.bam_anim->anim->direction[curr_dir].frame_num - 1;
         }
         else if (key[KEY_END])
         {
            rest(200);
            if (curr_dir < glb.bam_anim->anim->direction_num - 1)
               curr_dir++;
            else
               curr_dir = 0;
         }
         else if (key[KEY_HOME])
         {
            rest(200);
            if (curr_dir > 0)
               curr_dir--;
            else
               curr_dir = glb.bam_anim->anim->direction_num - 1;
         }
         else if (key[KEY_P]) // pivot
         {
            while (key[KEY_P])
            {
               // wait
            }
            show_pivot = show_pivot ? FALSE : TRUE;
         }

         // save pcx animation
         if (key[KEY_S])
         {
            while (key[KEY_S])
            {
               // wait
            }
            pst_pcx_save(argv[1]);
         }

         if (cmap_cursor_redraw || first_redraw)
         {
            c = col_black;
            rect(glb.scr_buffer, 98, 8 + 20 * old_layer, 196, 18 + 20 * old_layer, c);
            x = 17 + glb.bmp_cmap_list->w;
            d = cmap_add - 1 + cmap_mul * layer[old_layer].cmap_idx;
            y = cmap_add - 1 + cmap_mul * (layer[old_layer].cmap_idx + 1);
            y = ((d + y) / 2) - 2,
            textout(glb.scr_buffer, font, ">", 7, y, c);
            textout(glb.scr_buffer, font, "<", x, y, c);
            d = cmap_add - 1 + cmap_mul * old_cmap;
            y = cmap_add - 1 + cmap_mul * (old_cmap + 1);
            y = ((d + y) / 2) - 2;
            textout(glb.scr_buffer, font, ">", 7, y, c);
            textout(glb.scr_buffer, font, "<", x, y, c);

            c = col_white;
            rect(glb.scr_buffer, 98, 8 + 20 * curr_layer, 196, 18 + 20 * curr_layer, c);
            d = cmap_add - 1 + cmap_mul * layer[curr_layer].cmap_idx;
            y = cmap_add - 1 + cmap_mul * (layer[curr_layer].cmap_idx + 1);
            y = ((d + y) / 2) - 2;
            textout(glb.scr_buffer, font, ">", 7, y, c);
            textout(glb.scr_buffer, font, "<", x, y, c);
            for (i=0; i < glb.bmp_cmap_list->w; i++)
            {
               c = getpixel(glb.bmp_cmap_list, i, layer[curr_layer].cmap_idx);
               vline(glb.scr_buffer, 200 + i, 9 + 20 * curr_layer, 17 + 20 * curr_layer, c);
            }

            old_layer = curr_layer;
            old_cmap = layer[curr_layer].cmap_idx;
            first_redraw = FALSE;

            // colormap anlyse
            clear(glb.cmap_analyse);
            for (i=0; i < glb.bmp_cmap_list->w; i++)
            {
               y = layer[curr_layer].cmap_idx;
               c = getpixel(glb.bmp_cmap_list, i, y);
               r = getr(c);
               g = getg(c);
               b = getb(c);

               // Red point
               x = i * 255 / glb.bmp_cmap_list->w;
               y = 255 - r;
               if ((r == g) && (r == b)) c = col_white;
               else if (r == g)          c = col_yellow;
               else if (r == b)          c = col_pink;
               else                      c = col_red;
               putpixel(glb.cmap_analyse, x, y, c);

               // Green point
               y = 255 - g;
               if ((g == r) && (g == b)) c = col_white;
               else if (g == r)          c = col_yellow;
               else if (g == b)          c = col_cyan;
               else                      c = col_green;
               putpixel(glb.cmap_analyse, x, y, c);

               // Blue point
               y = 255 - b;
               if ((b == r) && (b == g)) c = col_white;
               else if (b == r)          c = col_pink;
               else if (b == g)          c = col_cyan;
               else                      c = col_blue;
               putpixel(glb.cmap_analyse, x, y, c);

               // preview
               c = makecol(r, g, b);
               rectfill(glb.cmap_prev, x, 0, (i+1) * 255 / glb.bmp_cmap_list->w, 24, c);
            }
         }
      }

      // color map cursor redraw

      // layer infos
      r = col_red;
      g = col_green;
      c = col_white;
      for (i=1; i < NM_END; i++)
      {
         textprintf(glb.scr_buffer, font,
            layer[i].x0, layer[i].y0,
            layer[i].active ? g : r,
            "%s", layer[i].desc
         );
         textprintf(glb.scr_buffer, font,
            206 + glb.bmp_cmap_list->w, layer[i].y0,
            c,
            "%3i", cmapidx[ layer[i].cmap_idx ]
         );
      }

      // update palette
      memcpy(glb.bam_anim->palette_data.al_palette[0], pal_original, sizeof(PALETTE));
      for (i=1; i < 256; i ++)
      {
         c = pal->color[i].z;
         if ((c > NM_NONE) && (c < NM_END))
         {
            if (layer[c].active)
            {
               // replace all 32 colors of this gradient
               y = layer[c].cmap_idx;
               for (x=0; x < 32; x++)
               {
                  if ((i+x) < 256)
                  {
                     d = x * glb.bmp_cmap_list->w / 32;
                     coul = getpixel(glb.bmp_cmap_list, d, y);
                     al_pal[0][i+x].r = getr(coul) >> 2;
                     al_pal[0][i+x].g = getg(coul) >> 2;
                     al_pal[0][i+x].b = getb(coul) >> 2;
                  }
               }
               i += 31;
            }
         }
      }

      bmp = glb.bam_anim->anim->bmp[
         glb.bam_anim->anim->direction[curr_dir].frame[curr_frame].bmp_idx];
      set_palette( * al_pal);
      clear(glb.curr_bmp);
      draw_sprite(glb.curr_bmp, bmp, 0, 0);

      x = 590 + glb.bam_anim->anim->direction[curr_dir].frame[curr_frame].box.x1 * 2;
      y = 500 + glb.bam_anim->anim->direction[curr_dir].frame[curr_frame].box.y1 * 2;

      if ( ! show_pivot)
      {
         c = col_black;
         hline(glb.scr_buffer, 390, 500, 790, c);
         vline(glb.scr_buffer, 590, 250, 580, c);
      }

      stretch_blit(glb.curr_bmp, glb.scr_buffer,
         0, 0, glb.curr_bmp->w, glb.curr_bmp->h,
         x, y, glb.curr_bmp->w*2, glb.curr_bmp->h*2
      );

      if (show_pivot)
      {
         c = col_white;
         hline(glb.scr_buffer, 390, 500, 790, c);
         vline(glb.scr_buffer, 590, 250, 580, c);
      }

      // color map analyse
      blit(glb.cmap_analyse, glb.scr_buffer, 0, 0, 108, 148, 256, 256);
      rect(glb.scr_buffer, 107, 147, 364, 404, col_white);

      // color map preview
      blit(glb.cmap_prev, glb.scr_buffer, 0, 0, 108, 418, 256, glb.cmap_prev->h);
      rect(glb.scr_buffer, 107, 417, 364, 441, col_white);


      // screenshots
      if (done)
      {
         strcpy(str_tmp, argv[1]);
         str_tmp[strlen(argv[1]) - 4] = 0;
         strcat(str_tmp, "_screen.pcx");
         save_pcx(str_tmp, glb.scr_buffer, NULL);

         strcpy(str_tmp, argv[1]);
         str_tmp[strlen(argv[1]) - 4] = 0;
         strcat(str_tmp, ".pcx");
         save_pcx(str_tmp, bmp, al_pal[0]);

         // save color parameters for future use
         strcpy(str_tmp, argv[1]);
         str_tmp[strlen(argv[1]) - 4] = 0;
         strcat(str_tmp, "_user.bin");
         out = fopen(str_tmp, "wb");
         if (out != NULL)
         {
            for (i=NM_NONE + 1; i < NM_END; i++)
            {
               fwrite( & layer[i].active,   1, sizeof(layer[i].active),   out);
               fwrite( & layer[i].cmap_idx, 1, sizeof(layer[i].cmap_idx), out);
            }
            fwrite( & curr_dir,   1, sizeof(curr_dir), out);
            fwrite( & curr_frame, 1, sizeof(curr_frame), out);
            fwrite( & show_pivot, 1, sizeof(show_pivot), out);
            fclose(out);
         }
      }

      // update screen
      vsync();
      blit(glb.scr_buffer, screen, 0, 0, 0, 0, gfx_width, gfx_height);

      rectfill(glb.scr_buffer, 
         x, y, x + glb.curr_bmp->w*2, y + glb.curr_bmp->h*2, col_black
      );
   }

   // end
   free(cmapidx);
   return 0;

}
END_OF_MAIN();
