#ifndef _PALETTE_H_

#define _PALETTE_H_


#include "types.h"


// ----------------------------------------------------------------------
// no padding bytes between members of a struct for now
#pragma pack(1)
// ----------------------------------------------------------------------


typedef struct
{
   UBYTE r; // all components : from 0 to 255
   UBYTE g;
   UBYTE b;
   UBYTE z; // zero, just for padding
} COLOR_RGBZ_S;


// ----------------------------------------------------------------------
// cancel the previous "no padding bytes" command
#pragma pack()
// ----------------------------------------------------------------------


typedef struct
{
   COLOR_RGBZ_S color[256];
} PALETTE_S;

typedef struct
{
   int       pal_num;      // # of palettes

   PALETTE_S * palette;    // pointer to a table of accurate palettes
                           // (componants range from 0 to 255)

   PALETTE   * al_palette; // pointer to a table of equivalent allegro palettes
                           // (componants range from 0 to 63)
} PALETTE_DATA_S;


#endif
