#ifndef _BAM_STRUCTS_H_

#define _BAM_STRUCTS_H_


#include "palette.h"
#include "animation.h"


// ----------------------------------------------------------------------
// no padding bytes between members of a struct for now
#pragma pack(1)
// ----------------------------------------------------------------------


typedef struct
{
   char   signature[4];
   char   version[4];
} BAM_FILE_HEADER_S;

typedef struct
{
   char   signature[4];
   char   version[4];
   long   length;
   char   bamc_data_start; // unbounded
} BAMC_DATA_HEADER_S;

typedef struct
{
   char   signature[4];
   char   version[4];
   UWORD  num_frames; // total, NOT per cycle
   UBYTE  num_cycles;
   UBYTE  compressed_color_index;
   UDWORD frame_entries_offset;
   UDWORD palette_offset;
   UDWORD lookup_table_offset;
} BAM_DATA_HEADER_S;

typedef struct
{
   WORD   width;
   WORD   height;
   WORD   offset_x;
   WORD   offset_y;
   UDWORD frame_data_offset; // bit 0-30 = offset, bit 31 = RAW frame flag
} BAM_FRAME_HEADER_S;

typedef struct
{
   WORD size;
   WORD start;
} BAM_CYCLE_HEADER_S;

typedef struct
{
   UBYTE b;
   UBYTE g;
   UBYTE r;
   UBYTE zero;
} BAM_RGBQUAD_S;

typedef struct
{
   BAM_RGBQUAD_S color[256];
} BAM_PALETTE_S;


// ----------------------------------------------------------------------
// cancel the previous "no padding bytes" command
#pragma pack()
// ----------------------------------------------------------------------


typedef struct
{
   PALETTE_DATA_S palette_data; // for the only 1 palette of the BAM
   ANIMATION_S    * anim;       // standard Animation datas
} BAM_ANIMATION_S;


/*
typedef struct
{
   ANIMATION_S * anim;
   char        weapon_class;
   char        alpha_type;
   char        sub_alpha_type;
} COF_LAYER_S;

typedef struct
{
   int         layer_num;             // # of layers
   COF_LAYER_S * layer;               // pointer on a a table of layer
   UBYTE       * layer_drawing_order; // pointer on a buffer of layer indecies
} COF_ANIMATION_S;
*/

#endif
