#ifndef _ANIMATION_H_

#define _ANIMATION_H_


// these structure are BAM / GIF / DCC / DC6 / COF ... *INDEPENDANT*
// for instance a BAM loading function will decode a BAM and fill its own datas
// as well as these standard animation structures

// note that these generic structure don't support layers.
// a COF loading function will again fill its own datas, one of them
// will be layers datas, with their sorting order

// the present structures can be seen as the basic animation of only 1 layer
// of an animation, not a whole animation managment
// it handles only allegro BITMAP & their placment relative to their sprite pivot
// (by the help of the box.x1 & box.y1 datas)


#include "box.h"


typedef struct
{
   int     bmp_idx; // index in ANIMATION_S.bmp[]
   BOX_S   box;     // frame box
} FRAME_S;

typedef struct
{
   int     frame_num; // # of frame for this direction
   FRAME_S * frame;   // pointer to a table of frame for this direction
   BOX_S   box;       // direction box
} DIRECTION_S;

typedef struct
{
   int            direction_num; // # of directions
   DIRECTION_S    * direction;   // pointer to a table of directions datas
   BOX_S          box;           // animation box
   int            bmp_num;       // # of BITMAP
   BITMAP         ** bmp;        // pointer to a table of pointer to BITMAP
} ANIMATION_S;


#endif
