#include <allegro.h>
#include "Pongpaddle.h"
#include "Pongball.h"

extern BITMAP *back_buffer;
extern _ball ball[100];
extern int MAX_BALLS;
int calculate_direction(int loc, float y, int h);

void _paddle::init(int location, int control)
{
  switch(location)
  {
    case 0:
      x = 5;
      break;
    case 1:
      x = 630;
      break;
  }
  y = 200;
  yv = 0;
  h = 80;
  score = 0;
  side = location;
  controller = control;
}

void _paddle::draw()
{
  rectfill(back_buffer, x, int(y), x + 5, int(y) + h, 15);
}

void _paddle::check()
{
  int key_is_pressed = 0;
  switch(controller)
  {
    case AI:
      yv += 0.2 * calculate_direction(side, y, h);
      if (yv < -MAX_PADDLE_SPEED) yv = -MAX_PADDLE_SPEED;
      if (yv > MAX_PADDLE_SPEED) yv = MAX_PADDLE_SPEED;
      key_is_pressed = 1;
      break;
    case ARROWS:
      if (key[KEY_UP])
      {
        yv -= 0.2;
        if (yv < -MAX_PADDLE_SPEED) yv = -MAX_PADDLE_SPEED;
        key_is_pressed = 1;
      }
      if (key[KEY_DOWN])
      {
        yv += 0.2;
        if (yv > MAX_PADDLE_SPEED) yv = MAX_PADDLE_SPEED;
        key_is_pressed = 1;
      }
      break;
    case WASD:
      if (key[KEY_W])
      {
        yv -= 0.2;
        if (yv < -MAX_PADDLE_SPEED) yv = -MAX_PADDLE_SPEED;
        key_is_pressed = 1;
      }
      if (key[KEY_S])
      {
        yv += 0.2;
        if (yv > MAX_PADDLE_SPEED) yv = MAX_PADDLE_SPEED;
        key_is_pressed = 1;
      }
      break;
  }
  y += yv;
  if (y < 0)
  {
    y = 0;
    yv = 0;
  }
  if (y + h > 479)
  {
    y = 479 - h;
    yv = 0;
  }
  if (key_is_pressed == 0)
  {
    if ((yv < 0.1) || (yv > -0.1))
    {
      yv = 0;
    }
    else
    {
      if (yv < 0)
      {
        yv += 0.1;
      }
      else if (yv > 0)
      {
        yv -= 0.1;
      }
    }
  }
}

void _paddle::reset()
{
  y = 200;
  yv = 0;
  h = 80;
  score = 0;
}

int calculate_direction(int loc, float y, int h)
{
  float eta[100];
  int i = 0;
  int best;
  while (i < 100)
  {
    eta[i] = 10000;
    i++;
  }
  i = 0;
  while (i < MAX_BALLS)
  {
    if (ball[i].exists == 1)
    {
      switch(loc)
      {
        case 0:
          if (ball[i].xv > 0)
          {
            eta[i] = ((630 - ball[i].x) / ball[i].xv) + (620 / ball[i].xv);
          }
          else
          {
            eta[i] = (ball[i].x - 10) / -ball[i].xv;
          }
          break;
        case 1:
          if (ball[i].xv < 0)
          {
            eta[i] = ((ball[i].x - 10) / -ball[i].xv) + (620 / -ball[i].xv);
          }
          else
          {
            eta[i] = (630 - ball[i].x) / ball[i].xv;
          }
          break;
      }
    }
    i++;
  }
  best = 0;
  i = 1;
  while (i < MAX_BALLS)
  {
    if (eta[i] < eta[best])
    {
      best = i;
    }
    i++;
  }
  if (ball[best].y + 2 > y + (h / 2))
  {
    return 1;
  }
  else
  {
    return -1;
  }
}
