#include <allegro.h>
#include <math.h>
#include <time.h>
#include <fstream.h>
#include <String>

#include "Pongball.h"
#include "Pongpaddle.h"
#include "Pongparticle.h"

using namespace std;

const int QUIT = -1;
const int PMENU = 0;
const int PGAME = 1;
const int WINNER = 2;

volatile int counter;
volatile int fpstime;
int ball_release_rate;
int score_to_win;
int MAX_BALLS;
int frames;
int fps;
int show_fps;
int gamestatus;
int blit_buffer;
int winner;

_ball ball[100];
_paddle paddle[2];
_particle particle[200];

BITMAP *back_buffer;

void do_menu();
void do_game();
void reset_balls();
void do_ball_collisions(int p);
void show_player_control(int p, int x, int y);
void switch_controls(int p, int i);
void new_ball();
void show_winner();

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

void fps_handler()
{
  fpstime++;
}
END_OF_FUNCTION(fps_handler);

int main()
{
  int t;
  srand(time(NULL));
  allegro_init();
  set_color_depth(8);
  install_keyboard();
  install_timer();
  install_int_ex(timer_handler, BPS_TO_TIMER(60));
  install_int_ex(fps_handler, BPS_TO_TIMER(1));
  set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
  back_buffer = create_bitmap(640, 480);
  clear(back_buffer);
  counter = 0;
  fpstime = 0;
  frames = 0;
  show_fps = 0;
  blit_buffer = 1;
  score_to_win = 10;
  ball_release_rate = 120;
  gamestatus = PMENU;
  MAX_BALLS = 20;
  paddle[0].init(0, ARROWS);
  paddle[1].init(1, AI);
  ifstream settings("pong.cfg");
  if (!settings.bad())
  {
    settings >> t;
    paddle[0].init(0, t);
    settings >> t;
    paddle[1].init(1, t);
    settings >> score_to_win;
    settings >> MAX_BALLS;
    settings >> ball_release_rate;
  }
  while (gamestatus != QUIT)
  {
    if (key[KEY_F])
    {
      if (show_fps == 0)
      {
        show_fps = 1;
      }
      else
      {
        show_fps = 0;
      }
      clear_keybuf();
    }
    if (key[KEY_ESC])
    {
      gamestatus = QUIT;
    }
    while (counter > 0)
    {
      switch(gamestatus)
      {
        case PMENU:
          do_menu();
          break;
        case PGAME:
          do_game();
          break;
        case WINNER:
          show_winner();
          break;
      }
      counter--;
      blit_buffer = 1;
      if (fpstime > 0)
      {
        fps = frames / fpstime;
        frames = 0;
        fpstime = 0;
      }
    }
    if (blit_buffer == 1)
    {
      if (show_fps == 1)
      {
        textprintf(back_buffer, font, 5, 5, 15, "FPS: %-1d", fps);
      }
      blit(back_buffer, screen, 0, 0, 0, 0, 640, 480);
      blit_buffer = 0;
      frames++;
    }
  }
  ofstream s_settings("pong.cfg");
  if (!s_settings.bad())
  {
    s_settings << paddle[0].controller << "\n";
    s_settings << paddle[1].controller << "\n";
    s_settings << score_to_win << "\n";
    s_settings << MAX_BALLS << "\n";
    s_settings << ball_release_rate << "\n";
  }
  destroy_bitmap(back_buffer);
  allegro_exit();
  return 0;
}
END_OF_MAIN();

void do_menu()
{
  const int PLAY = 0;
  const int CONTROL1 = 1;
  const int CONTROL2 = 2;
  const int LIMIT = 3;
  const int BMAX = 4;
  const int BRATE = 5;
  static int choice = 0;
  static int keydelay = 0;
  int t;
  clear(back_buffer);
  textout_centre(back_buffer, font, "Pong Clone #946", 320, 50, 15);
  textout_centre(back_buffer, font, "Start Game", 320, 200, 15);
  show_player_control(0, 320, 210);
  show_player_control(1, 320, 220);
  textprintf_centre(back_buffer, font, 320, 230, 15, "Score to win: %-1d", score_to_win);
  textprintf_centre(back_buffer, font, 320, 240, 15, "Maximum balls: %-1d", MAX_BALLS);
  textprintf_centre(back_buffer, font, 320, 250, 15, "Ball release rate: %-1d", 305 - ball_release_rate);
  rect(back_buffer, 0, 198 + (choice * 10), 639, 209 + (choice * 10), 15);
  if (keydelay > 0)
  {
    keydelay--;
  }
  else
  {
    if (key[KEY_DOWN])
    {
      choice++;
      if (choice == 6)
      {
        choice = 0;
      }
      keydelay = 10;
    }
    else if (key[KEY_UP])
    {
      choice--;
      if (choice == -1)
      {
        choice = 5;
      }
      keydelay = 10;
    }
  }
  switch(choice)
  {
    case PLAY:
      if ((key[KEY_ENTER]) && (keydelay == 0))
      {
        t = 0;
        while (t < 200)
        {
          particle[t].exists = 0;
          t++;
        }
        reset_balls();
        ball[0].create();
        paddle[0].reset();
        paddle[1].reset();
        gamestatus = PGAME;
        keydelay = 20;  //important once a game is over and the menu is brought back
      }
      break;
    case CONTROL1:
      if (keydelay == 0)
      {
        if (key[KEY_RIGHT])
        {
          switch_controls(0, 1);
          keydelay = 10;
        }
        else if (key[KEY_LEFT])
        {
          switch_controls(0, -1);
          keydelay = 10;
        }
      }
      break;
    case CONTROL2:
      if (keydelay == 0)
      {
        if (key[KEY_RIGHT])
        {
          switch_controls(1, 1);
          keydelay = 10;
        }
        else if (key[KEY_LEFT])
        {
          switch_controls(1, -1);
          keydelay = 10;
        }
      }
      break;
    case LIMIT:
      if (keydelay == 0)
      {
        if (key[KEY_LEFT])
        {
          if (score_to_win > 1)
          {
            score_to_win--;
            keydelay = 10;
          }
        }
        else if (key[KEY_RIGHT])
        {
          if (score_to_win < 50)
          {
            score_to_win++;
            keydelay = 10;
          }
        }
      }
      break;
    case BMAX:
      if (keydelay == 0)
      {
        if (key[KEY_LEFT])
        {
          if (MAX_BALLS > 1)
          {
            MAX_BALLS--;
            keydelay = 10;
          }
        }
        else if (key[KEY_RIGHT])
        {
          if (MAX_BALLS < 100)
          {
            MAX_BALLS++;
            keydelay = 10;
          }
        }
      }
      break;
    case BRATE:
      if (keydelay == 0)
      {
        if (key[KEY_LEFT])
        {
          if (ball_release_rate < 300)
          {
            ball_release_rate++;
            keydelay = 5;
          }
        }
        else if (key[KEY_RIGHT])
        {
          if (ball_release_rate > 5)
          {
            ball_release_rate--;
            keydelay = 5;
          }
        }
      }
      break;
  }
}

void do_game()
{
  int r = rand()%ball_release_rate;
  int i = 0;
  clear(back_buffer);
  while (i < MAX_BALLS)
  {
    if (ball[i].exists == 1)
    {
      ball[i].move();
      ball[i].draw();
    }
    i++;
  }
  i = 0;
  while (i < 200)
  {
    if (particle[i].exists == 1)
    {
      particle[i].move();
    }
    i++;
  }
  paddle[0].check();
  do_ball_collisions(0);
  paddle[1].check();
  do_ball_collisions(1);
  paddle[0].draw();
  paddle[1].draw();
  textprintf(back_buffer, font, 1, 1, 15, "%-1d", paddle[0].score);
  textprintf_right(back_buffer, font, 639, 1, 15, "%-1d", paddle[1].score);
  if (r == 0)
  {
    new_ball();
  }
  if ((paddle[0].score >= score_to_win) || (paddle[1].score >= score_to_win))
  {
    gamestatus = WINNER;
  }
}

void reset_balls()
{
  int i = 0;
  while (i < MAX_BALLS)
  {
    ball[i].exists = 0;
    i++;
  }
}

void do_ball_collisions(int p)
{
  int q;
  int z;
  int i = 0;
  while (i < MAX_BALLS)
  {
    if ((ball[i].exists == 1) && ((paddle[p].x + 5 > int(ball[i].x) - 5) && (int(ball[i].x) + 5 > paddle[p].x)))
    {
      if ((int(ball[i].y) + 5 > int(paddle[p].y)) && (int(ball[i].y) - 5 < int(paddle[p].y) + paddle[p].h))
      {
        if (paddle[p].side == 0)
        {
          ball[i].xv = f_abs(ball[i].xv);
          z = 0;
          while (z < 10)
          {
            q = find_free_particle();
            if (q != -1)
            {
              particle[q].init(ball[i].x + 2, ball[i].y + 2, RIGHT);
            }
            z++;
          }
        }
        else
        {
          ball[i].xv = -f_abs(ball[i].xv);
          z = 0;
          while (z < 10)
          {
            q = find_free_particle();
            if (q != -1)
            {
              particle[q].init(ball[i].x + 2, ball[i].y + 2, LEFT);
            }
            z++;
          }
        }
      }
    }
    i++;
  }
}

void show_player_control(int p, int x, int y)
{
  string message;
  string type;
  char n[5];
  message = "Paddle ";
  sprintf(n, "%-1d", p + 1);
  message += n;
  message += " control: ";
  switch(paddle[p].controller)
  {
    case AI:
      type = "AI";
      break;
    case ARROWS:
      type = "ARROWS";
      break;
    case WASD:
      type = "WASD";
      break;
  }
  message += type;
  textout_centre(back_buffer, font, message.c_str(), x, y, 15);
}

void switch_controls(int p, int i)
{
  paddle[p].controller += i;
  if (paddle[p].controller < 0)
  {
    paddle[p].controller = 2;
  }
  if (paddle[p].controller > 2)
  {
    paddle[p].controller = 0;
  }
}

void new_ball()
{
  int i = 0;
  while (i < MAX_BALLS)
  {
    if (ball[i].exists == 0)
    {
      ball[i].create();
      i = MAX_BALLS;
    }
    i++;
  }
}

void show_winner()
{
  clear(back_buffer);
  paddle[0].draw();
  paddle[1].draw();
  textprintf(back_buffer, font, 1, 1, 15, "%-1d", paddle[0].score);
  textprintf_right(back_buffer, font, 639, 1, 15, "%-1d", paddle[1].score);
  if (paddle[0].score > paddle[1].score)
  {
    textout_centre(back_buffer, font, "Player 1 Wins", 320, 200, 15);
  }
  else
  {
    textout_centre(back_buffer, font, "Player 2 Wins", 320, 200, 15);
  }
  textout_centre(back_buffer, font, "Press Enter", 320, 220, 15);
  if (key[KEY_ENTER])
  {
    gamestatus = PMENU;
  }
}
