/* Path Finding Demo
   Copyright (C) 2004 by David A. Capello

   See LICENSE for more information.
*/

#include <stdio.h>
#include <stdlib.h>

#include "heap.h"

void heap_init (HEAP *heap, int (*cmp) (const void *p1, const void *p2))
{
  heap->size = 0;
  heap->array = NULL;
  heap->top = 0;
  heap->cmp = cmp;
}

void heap_fini (HEAP *heap)
{
  if (heap->array)
    free (heap->array);

  heap->size = 0;
  heap->array = NULL;
  heap->top = 0;
}

#define SWAP_ITEMS(x, y)			\
  t = heap->array[(x)];				\
  heap->array[(x)] = heap->array[(y)];		\
  heap->array[(y)] = t;				\
  (x) = (y);

void heap_push (HEAP *heap, void *ptr)
{
  int c, p;			/* current, parent */
  void *t;			/* temporary */

  if (heap->top == heap->size) {
    if (!heap->size) heap->size = 1;
    else heap->size <<= 1;
    heap->array = realloc (heap->array, sizeof (void *) * heap->size);
  }

  heap->array[c=heap->top++] = ptr;

  while (c > 0 &&
	 (*heap->cmp) (heap->array[c], heap->array[p=(c+1)/2-1]) < 0) {
    SWAP_ITEMS (c, p);
  }
}

void _heap_usher (HEAP *heap, int c)
{
  int p;			/* parent */
  void *t;			/* temporary */

  while (c > 0 &&
	 (*heap->cmp) (heap->array[c], heap->array[p=(c+1)/2-1]) < 0) {
    SWAP_ITEMS (c, p);
  }
}

void *heap_pop (HEAP *heap)
{
  if (heap->top > 0) {
    void *t, *r = heap->array[0]; /* temporary, return */
    int c, ch1, ch2;		  /* current, childs */
    heap->array[c=0] = heap->array[--heap->top];
    for (;;) {
      ch1 = (c+1)*2-1;
      ch2 = ch1+1;
      if (ch1 < heap->top) {
	if (ch2 < heap->top) {
	  if ((*heap->cmp) (heap->array[ch1], heap->array[ch2]) < 0) {
	    if ((*heap->cmp) (heap->array[c], heap->array[ch1]) > 0) {
	      SWAP_ITEMS (c, ch1);
	    }
	    else
	      break;
	  }
	  else {
	    if ((*heap->cmp) (heap->array[c], heap->array[ch2]) > 0) {
	      SWAP_ITEMS (c, ch2);
	    }
	    else
	      break;
	  }
	}
	else if ((*heap->cmp) (heap->array[c], heap->array[ch1]) > 0) {
	  SWAP_ITEMS (c, ch1);
	}
	else
	  break;
      }
      else
	break;
    }
    return r;
  }
  else
    return NULL;
}

void heap_foreach (HEAP *heap, void (*func) (void *p))
{
  int c;

  for (c=0; c<heap->top; c++)
    (*func) (heap->array[c]);
}
