/* Path Finding Demo
   Copyright (C) 2004 by David A. Capello

   See LICENSE for more information.
*/

#ifndef PATH_H
#define PATH_H

/* tile size */
#define TW (8)
#define TH (8)

/* map width and height */
#define W  (320/TW)
#define H  (240/TH)

/* global variables */
extern char map[H][W];

extern int map_x1, map_y1;
extern int map_x2, map_y2;

extern int use_diag;

/* a node in the path (a tiled to pass through) */
typedef struct NODE
{
  int x, y;			/* position of this node */
  int g, h;			/* movement and heuristic cost */
  struct NODE *parent;		/* parent node */
} NODE;

/* a path (opened list, closed list, and finally last node to arrive
   to destination position) */
typedef struct PATH
{
  HEAP open;
  HEAP close;
  NODE *dest_node;
} PATH;

PATH *find_path (void);
void destroy_path (PATH *path);

#endif	/* PATH_H */
