/* Path Finding Demo
   Copyright (C) 2004 by David A. Capello

   See LICENSE for more information.
*/

#ifndef HEAP_H
#define HEAP_H

typedef struct HEAP
{
  int size;
  void **array;
  int top;
  int (*cmp) (const void *p1, const void *p2);
} HEAP;

void heap_init (HEAP *heap, int (*cmp) (const void *p1, const void *p2));
void heap_fini (HEAP *heap);
void heap_push (HEAP *heap, void *ptr);
void _heap_usher (HEAP *heap, int c);
void *heap_pop (HEAP *heap);
void heap_foreach (HEAP *heap, void (*func) (void *p));

#endif /* HEAP_H */
