
#include "allegro.h"
#include <math.h>
#include <fstream>

#include "orbit.h"

using namespace std;

const float G= 0.0003;
const int S_N=3;
const int BLACK = makecol(0,0,0);
           
// create the double buffer
   BITMAP* buffer;
   BITMAP* menu ;
   FONT* menu_f;
   FONT* small;
   DATAFILE* data;
   int iround;
   
   
double distance(double x1,double y1,double x2,double y2) {
       return sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
       }

int sign(double x) {
    int i;
    if (x>=0) {i=1;}
    else {i=-1;}
    return i;
}


int play();
void set_menu_bmp();
void load();
bool level_ok();
void draw_begin(int s);
void load_options();
int color_line(int pos);
void main_menu();
void end_screen();

//classes list
class Cstar;
class Cbullet;
class Cplayer;
class Ctarget;
class Cmaker;

struct S_options {
       int level_switch; //can or can't switch levels
       int rounds_number; //best of what?
       int bullet_speed; //how fast the bullets go
       int music_volume;  
       int sfx_volume;
       };
S_options options;


class Cstar {
      public:
             int r,x,y;
             
             Cstar(int rr,int xx,int yy) {
                       r=rr;
                       x=xx;
                       y=yy;
                       }
             
             void draw() {
                  for (int i=0;i<r/2;i++) {
                      circlefill(buffer,x,y,r/2-i,makecol(255,255-2*i*255/r,100));
                      }
                  }
             
                          
             };
 
//globals
Cstar star[S_N] ={Cstar(60,250,400),Cstar(100,50,100),Cstar(80,400,300)/*,Cstar(80,500,100)*/};  

             
class Cbullet {
      public:
             double x,y,vx,vy,xp,yp;
             bool active;
             int orbit;
             int t,n;
             int px,py,palpha;
             void init(double xx,double yy,double dir,double power) {
                         t=0;
                         vx=power*cos(dir*3.141592/128);
                         vy=power*sin(dir*3.141592/128);
                         x=xx;
                         y=yy;
                         orbit=0;
                         }
             void set_a(Cstar *star) {
                  double alpha;
                  double a;
                  
                  if ((int) (x-star->x)!=0) {
                                    alpha=atan((y-star->y)/(x-star->x));
                                    }
                  else {
                       alpha=1.5707;
                       }
                  a=2*star->r*G/distance(x,y,(double)star->x,(double)star->y)*distance(x,y,(double)star->x,(double)star->y);
                  
                  vx+=sign(star->x-x)*cos(alpha)*a;
                  vy+=sign(star->x-x)*sin(alpha)*a;
                  }
             
             bool check_shield() {
                  double a,b,x1,del,cx,cy,theta;
                  int i;
                  a=(yp-y)/(xp-x);
                  b=y-py-a*(x-px);
                  
                  del=4*a*a*b*b-4*(a*a+1)*(b*b-40*40);
                  
                  if (del<0)      {return false;}
                  //if ((x-px)*(x-px)+(y-py)*(y-py)-40*40<2) {return true;}
                  for (i=-1;i<4;i+=2) {
                      if (i<3) {
                               cx=(-2*a*b+i*sqrt(del))/(2*(a*a+1));
                               cy=a*cx+b;
                               if (abs((int)(distance(x-px,y-py,cx,cy)+distance(xp-px,yp-py,cx,cy)-distance(xp-px,yp-py,x-px,y-py)))<1) {
                                                                                          break;
                                                                                          }
                               }
                      if (i==3) {return false;}
                      }
                  double alpha;
                  int malpha,plalpha;
                  
                  alpha=atan(-cy/cx)/3.14*128;
                  if (cx<0) {alpha+=128;}
                  if (alpha<0) {alpha+=256;}
                  malpha=palpha-40;
                  plalpha=palpha+40;
                  
                  if (!(malpha>0&&plalpha>0&&alpha<plalpha&&alpha>malpha)) {
                  if (!(malpha<0&&plalpha>0&&(alpha<plalpha||alpha>malpha+256))) {
                  if (!(malpha>0&&plalpha>256&&(alpha<plalpha-256||alpha>malpha))) {return false;}}}
                  
                  
                  return true;
                  }
                  
             void step() {
                  int i;
                  if (active) {
                              

                           
                              for (i=0;i<S_N;i++) {
                                  set_a(&star[i]);
                                  }
                              xp=x;
                              yp=y;
                              x=x+vx;
                              y=y+vy;
                              }
                              
                  //check for stars
                  for (i=0;i<S_N;i++) {
                      if (distance(x,y,star[i].x,star[i].y)<star[i].r/2+3&&active) {
                                                                       play_sample((SAMPLE *)data[hit_planet].dat,150,128,1000,false);
                                                                       active=false;
                                                                       }
                      }
                  //check for shield
                  if (check_shield()&&active) {active=false;
                                      play_sample((SAMPLE *)data[shield].dat,250,128,1000,false);
                                      } 
                  
                                    
                  if (t<1200) {t+=1;}
                  if (t==1200&&orbit==0&&active) {
                                     double fx,fy,fvx,fvy;
                                     int j;
                                     fx=x;
                                     fy=y;
                                     fvx=vx;
                                     fvy=vy;
                                     j=0;
                                     while(j<5000&&active) {
                                                           j++;
                                                           for (i=0;i<S_N;i++) {
                                                               set_a(&star[i]);
                                                               }
                                                           xp=x;
                                                           yp=y;
                                                           x=x+vx;
                                                           y=y+vy;
                                                           
                              
                                                           //check for stars
                                                           for (i=0;i<S_N;i++) {
                                                           if (distance(x,y,star[i].x,star[i].y)<star[i].r/2+3) {
                                                                       active=false;
                                                                       }
                                                                       }
                                                                       //check for shield
                                                                       if (check_shield()) {active=false;} 
                                                           }
                              x=fx;
                              y=fy;
                              vx=fvx;
                              vy=fvy;
                              if (active) {orbit=2;}
                              else {orbit=1;}
                              active=true;
                              }
                                          
                                     
                                     
                  
                  }
             void draw() {
                  if (active) {
                              if (orbit<2) {circlefill(buffer,(int) x,(int) y,3,makecol(255,200-(int)(t/6),0));}
                              else {circlefill(buffer,(int) x,(int) y,3,makecol(100,0,0));}
                              }
                  }
                  
             
                  
             };

class Cplayer {
      public:
             int x,y,n,color,alpha;
             int wins;
             int clip; //empty sound
             double dir;
             BITMAP *sprite;
             Cbullet bullet[3],fb;
             int shot;
             double power;
             
             void start_game() {
                  wins=0;
                  color = makecol(0,255-n*255,n*255);
                  }
             void init(int nn) {
                       power = 4.0;
                       dir=rand()%4*64;
                       shot=0;
                       clip=0;
                       n=nn;
                       
                       
                       for (int i=0;i<3;i++) {
                           bullet[i].active=false;
                           bullet[i].n=n;
                           bullet[i].orbit=0;
                           }
                       
                       //create the sprite
                       sprite=create_bitmap(40,40);
                       clear_to_color(sprite,makecol(255,0,255));
                       draw_sprite(sprite,(BITMAP*)data[cannon].dat,0,0);
                       
                       }
             
             
             void draw() {
                  int bn=0;
                  int on=0;
                  int i,j;
                  circlefill(buffer,x,y,10,color);
                  rotate_sprite(buffer,sprite,x-20,y-20,itofix((int)dir));
                  for (i=0;i<3;i++) {
                      if (!bullet[i].active) {bn++;}
                      if (bullet[i].orbit==2) {on++;}
                      }
                  for (i=0;i<3;i++) {
                      bullet[i].draw();
                      circlefill(menu,30+i*40,n*250+250,15,BLACK);
                      if (i<bn) {circlefill(menu,30+i*40,n*250+250,12,color);}
                      }
                  for (i=0;i<3;i++) {
                      if (i<on) {circlefill(menu,110-i*40,n*250+250,12,makecol(100,0,0));}
                      }
                  //draw bar
                  rect(menu,19,n*250+310,181,n*250+340,BLACK);
                  for (i=0;i<(int)(( power-1.0)*20.0);i++) {
                      line(menu,20+i,n*250+311,20+i,n*250+339,makecol(0,255-i,95+i));
                      }
                  char buf[80];
                  sprintf(buf, "wins:%d",wins);
                  textout(menu,small,buf,10,160+n*250,color); 
                  sprintf(buf, "angle:%d",(int)(360-dir/256*360)%360);
                  textout(menu,small,buf,10,190+n*250,color); 
                  //draw_aim();
                   
                   arc(buffer,x,y,itofix(alpha-40),itofix(alpha+40),40,color);
                   
                   
                  }
             void step() {
                  int i,j;
                  shot+=1;
                  clip+=1;
                  
                  if ((key[KEY_LEFT]&&n==0)||(key[KEY_G]&&n==1)) {dir=dir/256*360;
                                                                  dir=(dir-1)/360*256;
                                                                  if (dir<0) {dir+=256;}}
                  if ((key[KEY_RIGHT]&&n==0)||(key[KEY_J]&&n==1)) {dir=dir/256*360;
                                                                  dir=(dir+1)/360*256;
                                                                  if (dir>256) {dir-=256;}}
                  if ((key[KEY_UP]&&n==0)||(key[KEY_Y]&&n==1)) {
                                   power+=0.05;
                                   if (power>9) {power=9;}
                                   }
                  if ((key[KEY_DOWN]&&n==0)||(key[KEY_H]&&n==1)) {
                                   power-=0.05;
                                   if (power<1) {power=1;}
                                   }
                                    
                  
                  
                  //shoot
                  if (((key[KEY_RSHIFT]&&n==0)||(key[KEY_A]&&n==1))&&shot>30) {
                                      for (i=0;i<3;i++) {
                                          if (!bullet[i].active) {
                                                                 
                                                                 bullet[i].init(x,y,dir,power);
                                                                 bullet[i].active=true;
                                                                 shot=0;
                                                                 play_sample((SAMPLE *)data[shoot].dat,200,128,1000,false);
                                      
                                                                 break;
                                                                 }
                                          }
                                      if (i==3&&clip>60) {play_sample((SAMPLE *)data[empty].dat,200,128,1000,false);
                                                           clip=0;}
                                      }
                 for (j=0;j<options.bullet_speed;j++) {
                  for (i=0;i<3;i++) {
                      bullet[i].step();
                      }
                    }
                  }
                  
             void draw_aim() {
                  int tt=0;   
                  fb.init(x,y,dir,power);
                  fb.active=true;
                  fb.px=bullet[0].px;
                  fb.py=bullet[0].py;
                  fb.palpha=bullet[0].palpha;
                  while(fb.active&&tt<10000) {
                                   tt++;
                                   fb.step();
                                   putpixel(buffer,(int)fb.x,(int)fb.y,color);
                                   }
                                        
                 
                 }
                 
                      
             };
        Cplayer player[2];      

             
class Ctarget {
      public:
             
      int x,y;
      
      void init() {
                  x=rand()%600;
                  y=rand()%600;
                  }
      
      void draw() {
           circlefill(buffer,x,y,10,makecol(255,0,0));
           circlefill(buffer,x,y,8,makecol(255,255,255));
           circlefill(buffer,x,y,6,makecol(255,0,0));
           circlefill(buffer,x,y,4,makecol(255,255,255));
           circlefill(buffer,x,y,2,makecol(255,0,0));
           }
           
      };
                               
Ctarget target;

   
   


volatile int game_time = 0;

void Timer(void)
{
     game_time++;
}
END_OF_FUNCTION(Timer); // end Timer()



// and here's the main loop
int main(int argc, char *argv[])
{
   // standard Allegro initialization
   allegro_init();
   install_keyboard();
   install_mouse();
   set_color_depth(16);
   set_gfx_mode(GFX_AUTODETECT, 800,600, 0, 0);
   srand( (unsigned)time( NULL ) );
      /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]) != 0) {
      allegro_message("Error initialising sound system\n%s\n", allegro_error);
      return 1;
   }
 // install the timer. We will use this to regulate game speed
   LOCK_VARIABLE(game_time);
   LOCK_FUNCTION((void*)Timer);
   install_int_ex(Timer, BPS_TO_TIMER(80));
   
   load_options();
   
buffer = create_bitmap(600,600);
menu=create_bitmap(200,600);
   ///load stuff
   data = load_datafile("orbit.dat");
   menu_f = (FONT *)data[m_font].dat;   
   small = (FONT *)data[small_f].dat;  
   
  


   
   player[0].start_game();  player[1].start_game(); 
   play_midi((MIDI *)data[music1].dat,1);
   
  main_menu();
   destroy_bitmap(buffer);
   return 1;
    }
END_OF_MAIN();

int play() {
    int i,j;
    int choose=-40;
    int level_s=0;
 for (i=0;i<2;i++) {
    player[i].init(i);
    }   
    int sx[250];
    int sy[250];
    
    for (i=0;i<250;i++) {
        sx[i]=rand()%600;
        sy[i]=rand()%600;
        }
        
    load();

for (i=0;i<2;i++) {
    for (j=0;j<3;j++) {
        player[i].bullet[j].px=player[1-i].x;
        player[i].bullet[j].py=player[1-i].y;
        player[i].bullet[j].palpha=player[1-i].alpha;
        }
    }
    target.init();

    
    
    
    while(!key[KEY_ESC]) {
            
             choose+=1;
             if (choose<240) {
                                                                                          
                             if (choose>0&&(level_s<3)&&((iround%2==0&&(key[KEY_LEFT]||key[KEY_RIGHT]))||(iround%2==1&&(key[KEY_G]||key[KEY_J])))) {
                                      choose=-40;
                                      level_s++;
                                      for (i=0;i<2;i++) {
                                         player[i].init(i);
                                         }   
                                                                             
                                         for (i=0;i<250;i++) {
                                             sx[i]=rand()%600;
                                             sy[i]=rand()%600;
                                             }
        
                                         load();

                                     for (i=0;i<2;i++) {
                                         for (j=0;j<3;j++) {
                                             player[i].bullet[j].px=player[1-i].x;
                                             player[i].bullet[j].py=player[1-i].y;
                                             player[i].bullet[j].palpha=player[1-i].alpha;
                                             }
                                     play_sample((SAMPLE *)data[cursor].dat,200,128,1000,false);
                                         }
                                         
                                         }
               }
                                                                                                                               
             
         else {    
             
             
             player[0].step();
             player[1].step();
             }
            
            for (i=0;i<2;i++) {
                for (j=0;j<3;j++) {
                    if (distance(player[i].bullet[j].x,player[i].bullet[j].y,player[1-i].x,player[1-i].y)<15) {
                                                                                                              player[i].wins++;
                                                                                                            return i;
                                                                                                            }
                    }
                }
            
            
             game_time--;
             while(game_time <= 0){}  
             poll_mouse();       
          ///drawing
          	clear_to_color(buffer,makecol(0,0,0));
          	clear_to_color(menu,makecol(0,0,0));
          	set_menu_bmp();
          	for (i=0;i<250;i++) {putpixel(buffer,sx[i],sy[i],makecol(255,255,255));}
            for (i=0;i<S_N;i++) {star[i].draw();}
            player[0].draw();
            player[1].draw();
            
            if (choose<240) {draw_begin(choose);}
            acquire_screen();
          	blit(buffer,screen,0,0,0,0,600,600);
          	blit(menu,screen,0,0,600,0,200,600);
	        release_screen();


   
   

}   
   
   return 2;
}
END_OF_FUNCTION(play)



void set_menu_bmp() {
     int i;
     char buf[80];
     clear_to_color(menu,makecol(100,100,100));
     for (i=0;i<4;i++) {
         hline(menu,0,100+i,200,BLACK);
         hline(menu,0,350+i,200,BLACK);
         rect(menu,0+i,0+i,200-i,600-i,BLACK);
         }
         
     textout(menu,menu_f,"player 1",10,110,player[0].color);    
     textout(menu,menu_f,"player 2",10,360,player[1].color);  
     sprintf(buf,"round %d",iround+1); 
     textout(menu,small,buf,10,10,BLACK); 
     }

void load() {
     
     int i;
     for (i=0;i<2;i++) {
         player[i].x=rand()%500+50;
         player[i].y=rand()%500+50;
         }
     for (i=0;i<S_N;i++) {
         star[i].x=rand()%(600-star[i].r)+star[i].r/2;
         star[i].y=rand()%(600-star[i].r)+star[i].r/2;
         }    
     
     while(!level_ok()) {
                        for (i=0;i<2;i++) {
                            player[i].x=rand()%500+50;
                            player[i].y=rand()%500+50;
                            }
                        for (i=0;i<S_N;i++) {
                            star[i].x=rand()%(600-star[i].r)+star[i].r/2;
                            star[i].y=rand()%(600-star[i].r)+star[i].r/2;
                            }    
         
         }
     for(i=0;i<2;i++) {
                  player[i].alpha=(int)(atan((player[0].y-player[1].y)/(player[1].x-player[0].x))/3.14*128);
                  if (player[i].x>player[1-i].x) {player[i].alpha+=128;}
                  if (player[i].alpha<0) {player[i].alpha+=256;}
                  }
                        
     }    


bool level_ok() {
     bool f=true;
     int i,j;
     for (i=0;i<2;i++) {
         for (j=0;j<S_N;j++) {
             if (distance(star[j].x,star[j].y,player[i].x,player[i].y)<star[j].r+20) {
                                                                                  f=false;
                                                                                  }
             }
         }
     for (i=0;i<S_N;i++) {
         for (j=i+1;j<S_N;j++) {
             if (distance(star[i].x,star[i].y,star[j].x,star[j].y)<star[i].r+star[j].r) {
                                                                                        f=false;
                                                                                        }
             }
         }
     if (distance(player[0].x,player[0].y,player[1].x,player[1].y)<90) {f=false;}
     
     return f;
     
     }
     
void draw_begin(int s) {
     char buf[80];

     text_mode(-1);
     if (s<0) {s=0;}
     sprintf(buf, "player %d choose the level",iround%2+1);
     textout_centre(buffer,menu_f,buf,300,210,player[iround%2].color);
     s=3-(int)(s/80);
     sprintf(buf, "%d",s);
     textout_centre(buffer,menu_f,buf,300,240,player[iround%2].color);
     }
     
     
void load_options() {
     options.bullet_speed=1;
     options.level_switch=true;
     options.music_volume=255;
     options.sfx_volume=255;
     options.rounds_number=11;
     }

int color_line(int pos) {
 
    if (pos<50) {return makecol(250,pos*5,0);}
    if (pos<100) {return makecol(500-pos*5,250,0);}
    if (pos<150) {return makecol(0,250,pos*5-500);}
    if (pos<200) {return makecol(0,1000-pos*5,250);}
    if (pos<250) {return makecol(pos*5-1000,0,250);}
    return makecol(250,0,1500-pos*5);
}
    
void main_menu() {
     int max,c,w;
     int pcolor[2];
     int logo=0;
     int i=0;
     int ilogo=0;
     bool exit=false;
     char buf[80];
     BITMAP *m_buffer;
     w=1;
     c=0;
     max=4;
     pcolor[0]=100;
     pcolor[1]=200;
     player[1].color=color_line(200);
     m_buffer=create_bitmap(800,600);
       int sx[450];
    int sy[450];
    
    for (i=0;i<450;i++) {
        sx[i]=rand()%800;
        sy[i]=rand()%600;
        }
        
        
     while (!exit) {
           i=1;
           ilogo=(ilogo+1)%1800;
     if (key[KEY_DOWN]&&w<3) {while(key[KEY_DOWN]) {}
                         c=(c+1)%max;
                         play_sample((SAMPLE *)data[cursor].dat,200,128,1000,false);
                                     
                         }
     if (key[KEY_UP]&&w<3) {while(key[KEY_UP]) {}
                         c=(c-1+max)%max;
                         play_sample((SAMPLE *)data[cursor].dat,200,128,1000,false);
                                     
                         }
     
     if (key[KEY_SPACE]) {
                         while (key[KEY_SPACE]) {}
                         
                                     
                         if (w==1) {
                                   if (c==0) {//play
                                              int n;
                                              play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                              n=play();
                                              while (n<2&&iround<options.rounds_number-1) {iround++;
                                                                                          n=play();}
                                              while(key[KEY_ESC]) {}
                                              if (n<2) {end_screen();}
                                              while(key[KEY_ESC]) {}
                                              iround=0;
                                              player[0].wins=0;
                                              player[1].wins=0;
                                              play_midi((MIDI *)data[music1].dat,1);
                                              }
                                   if (c==1&&i>0) {w=2;
                                              c=0;
                                              max=7;
                                              i=0;
                                              play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);}
                                   if (c==2&&i>0) {
                                                  w=3;
                                                  i=0;
                                                   play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);}
                                                   
                                   if (c==3) {exit=true;}
                                   }
                         if (w==2) {
                                   if (c==0&&i>0) {play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                                   max=4;
                                                   w=1;
                                                   }
                                   }
                        if (w==3&&i>0) {play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                                   max=4;
                                                   w=1;
                                                   }
                                                                 
                                   
                         i=0;
                         }
                                   
      if (key[KEY_RIGHT]&&w==2) {
                                if (c==1) {
                                          play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                          options.rounds_number+=2;
                                          while(key[KEY_RIGHT]) {}
                                          }
                                if (c==2) {
                                          play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                          options.bullet_speed=(options.bullet_speed)%3+1;
                                          while(key[KEY_RIGHT]) {}
                                          }
                                if (c==3||c==4) {
                                                pcolor[c-3]=(pcolor[c-3]+1)%300;
                                                player[c-3].color=color_line(pcolor[c-3]);
                                                }
                                if (c==5) {
                                          options.music_volume+=1;
                                          if (options.music_volume>255) {options.music_volume=255;}
                                          set_volume(-1,options.music_volume);
                                          }
                                if (c==6) {
                                          play_sample((SAMPLE *)data[knock].dat,200,128,1000,false);
                                          options.sfx_volume+=1;
                                          if (options.sfx_volume>255) {options.sfx_volume=255;}
                                          set_volume(options.sfx_volume,-1);
                                          }
                                
                                }
      if (key[KEY_LEFT]&&w==2) {
                                if (c==1) {
                                          play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                          options.rounds_number-=2;
                                          if (options.rounds_number<1) {options.rounds_number=1;}
                                          while(key[KEY_LEFT]) {}
                                          }
                                if (c==2) {
                                          play_sample((SAMPLE *)data[cursor2].dat,200,128,1000,false);
                                          if (options.bullet_speed==1) {options.bullet_speed=3;}
                                          else {options.bullet_speed-=1;}
                                          while(key[KEY_LEFT]) {}
                                          }
                                if (c==3||c==4) {
                                                pcolor[c-3]=(pcolor[c-3]+299)%300;
                                                player[c-3].color=color_line(pcolor[c-3]);
                                                }
                                if (c==5) {
                                          options.music_volume-=1;
                                          if (options.music_volume<0) {options.music_volume=0;}
                                          set_volume(-1,options.music_volume);
                                          }
                                if (c==6) {
                                          play_sample((SAMPLE *)data[knock].dat,200,128,1000,false);
                                          options.sfx_volume-=1;
                                          if (options.sfx_volume<0) {options.sfx_volume=0;}
                                          set_volume(options.sfx_volume,-1);
                                          }
                                
                                }
                                                                                             
     
     
     
     if (key[KEY_ESC]) {exit=true;}                    
          
     //drawing
     clear_to_color(m_buffer,BLACK);
     for (i=0;i<450;i++) {putpixel(m_buffer,sx[i],sy[i],makecol(255,255,255));}
            textout_centre(m_buffer,(FONT *)data[big_f].dat,"ORBIT",400,50,color_line((int)(ilogo/6)));
     if (w!=3) {draw_sprite(m_buffer,(BITMAP *)data[arrow].dat,180,265+c*40);}
     if (w==1) {
               textout(m_buffer,menu_f,"new game",200,250,makecol(255,255,255));
               textout(m_buffer,menu_f,"options",200,290,makecol(255,255,255));
               textout(m_buffer,menu_f,"help",200,330,makecol(255,255,255));
               textout(m_buffer,menu_f,"quit",200,370,makecol(255,255,255));
               }
     if (w==2) {
               textout(m_buffer,menu_f,"back",200,250,makecol(255,255,255));
               
               sprintf(buf,"round number:%d",options.rounds_number);
               textout(m_buffer,menu_f,buf,200,290,makecol(255,255,255));
               
               if (options.bullet_speed==1) {textout(m_buffer,menu_f,"speed: normal",200,330,makecol(255,255,255));}
               if (options.bullet_speed==2) {textout(m_buffer,menu_f,"speed: fast",200,330,makecol(255,255,255));}
               if (options.bullet_speed==3) {textout(m_buffer,menu_f,"speed: ultra fast",200,330,makecol(255,255,255));}
               
               textout(m_buffer,menu_f,"player 1",200,370,makecol(255,255,255));
               rectfill(m_buffer,350,387,650,393,color_line(pcolor[0]));
               rectfill(m_buffer,350+pcolor[0]-5,380,350+pcolor[0]+5,400,makecol(127,127,127));
               
               textout(m_buffer,menu_f,"player 2",200,410,makecol(255,255,255));
               rectfill(m_buffer,350,427,650,433,color_line(pcolor[1]));
               rectfill(m_buffer,350+pcolor[1]-5,420,350+pcolor[1]+5,440,makecol(127,127,127));
               
               textout(m_buffer,menu_f,"music volume",200,450,makecol(255,255,255));
               rectfill(m_buffer,395,467,650,473,makecol(200,200,200));
               rectfill(m_buffer,395+options.music_volume-5,460,395+options.music_volume+5,480,makecol(127,127,127));
               
               textout(m_buffer,menu_f,"sfx volume",200,490,makecol(255,255,255));
               rectfill(m_buffer,395,507,650,513,makecol(200,200,200));
               rectfill(m_buffer,395+options.sfx_volume-5,500,395+options.sfx_volume+5,520,makecol(127,127,127));
               
               }
               
     if (w==3) {
              textout(m_buffer,small,"the goal is to hit your opponent with bullets by using the stars gravity.",100,250,makecol(255,255,255));
              textout(m_buffer,small,"each player can fire only 3 bullets at a time. if your bullet is stuck ",100,270,makecol(255,255,255));
              textout(m_buffer,small,"on it's course you won't be able to use it again.",100,290,makecol(255,255,255));
              textout(m_buffer,small,"each round ends when someone hits his rival's ship.",100,310,makecol(255,255,255));

              textout(m_buffer,small,"keys:",100,370,makecol(255,255,255));
              textout(m_buffer,small,"player 1-",100,390,makecol(255,255,255));
              textout(m_buffer,small,"        left&right-change direction",100,410,makecol(255,255,255));
              textout(m_buffer,small,"        up&down-change power",100,430,makecol(255,255,255));
              textout(m_buffer,small,"        left shift-shoot",100,450,makecol(255,255,255));
              textout(m_buffer,small,"player 2-",100,470,makecol(255,255,255));
              textout(m_buffer,small,"        G&J-change direction",100,490,makecol(255,255,255));
              textout(m_buffer,small,"        Y&H-change power",100,510,makecol(255,255,255));
              textout(m_buffer,small,"        A-shoot",100,530,makecol(255,255,255));
              }
               
     blit(m_buffer,screen,0,0,0,0,800,600);
     }
        destroy_bitmap(m_buffer);
     }
     
void end_screen() {
     BITMAP *end;
     char buf[80];
     int w;
     end=create_bitmap(600,600);
     clear_to_color(end,makecol(255,0,255));
     
     if (player[0].wins>player[1].wins) {    
                                        w=1;
                                        }
     else {w=2;}
     
     sprintf(buf,"player %d is the winner!!!",w);
     textout_centre(end,menu_f,buf,300,200,player[w-1].color);
     textout_centre(end,small,"press esc to return",300,260,player[w-1].color);     
     draw_sprite(screen,end,0,0);
     
     play_midi((MIDI *)data[end_game].dat,0);
     while(!key[KEY_ESC]) {}
     
        destroy_bitmap(end);
                         
                         
}                
                                       
               
     
    
    
