/******************************************************
 * Kill The Barney v1.0
 * Andrew Deren 5/28/97
 ******************************************************/

// include files
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <allegro.h>
#include "ktb.h"               // by grabber

#define GRIDCOLOR 32				  //color of grid

//used by windows
#define WHITE 8					  //pseudo white color
#define LIGHTGRAY 7				  //pseudo lightgray color
#define DARKGRAY 6				  //pseudo darkgray color

//frames
#define NORMAL 1					  //normal frame
#define INVERSE -1				  //inverse frame

//types defined, used on the map
#define START_EATERS 5			  //number of eaters in first level
#define MAP_SIZE 18				  //size of the map MAP_SIZE * MAP_SIZE
#define MAX_HIGHSCORES 10		  //number of high scores displayed

typedef struct {					  //highscore structure
	int score;						  //score
	int level;						  //level
	char name[21];					  //name
} HIGH_SCORE;

void Error (char *string);		  //display error and exit program

int Random (int x);				  //get random number from 0 to x

void ClearMap (void);			  //clear the map

void GoNextLevel (void);		  //go to next level

void DrawMap (void);				  //draw the map

void StartGameGraphics (void);  //initilize game graphics

void PlaySound (int);			  //play the sound from data file

void Animation (int, int, BITMAP *);	//do the animation for droping bitmap to x, and y

void DrawFrame (BITMAP *, int, int, int, int, int);	//draw the frame

int MoveYou (int, int);			  //move player

void MoveThem (void);			  //move all eaters

void TelePort (void);			  //teleport

void StartLevel (void);			  //start level

void GameInit (void);			  //initilize game

int CheckBomb (int, int);		  //used by drop bomb

void DropBomb (void);			  //put bomb at players location

int UpdateHighScores (void);	  //update highscores

void PlayGame (void);			  //play the game

void Welcome (void);				  //welcome screen

//Draw Message box with title and 4 messages
void DrawMsgbox (char *title, char *string1, char *string2, char *string3, char *string4);

void DrawGraves (void);			  //draw graves on the right side

void DrawScoreBox (void);		  //draw score box (score, no. graves, level, high scre)

int ShootBarney (int);			  //shooting the barney

void ShootingTest (int);		  //shooting practice

int ExitPrompt(void);           //prompt if player wants to exit

void Help(void);                //display help

void ViewHighScores(int);       //view high scores

void GotHighScore(int);         //player got highscore

void NewGame(void);             //start new game

void GameOver(void);            //game is over

void FrameAnimation(int, int, int, int, int);  //do animation from data file

//global variables
int map[MAP_SIZE][MAP_SIZE];	  //actual map with values
int GridOn;							  //is grid on?
int x_loc, y_loc;					  //players location
int bomb_x, bomb_y;				  //location of bomb
int num_eaters;					  //number of barneys in level
int level = 1;						  //current level
int score;							  //current score
int bombs;							  //number of bombs
int game_over;						  //is game over?
int alive;							  //number of eaters alive
int graves;							  //number of graves
HIGH_SCORE high_scores[MAX_HIGHSCORES];	//high scores
BITMAP *map_bitmap;				  //bitmap of map
DATAFILE *data;					  //data file

//display message box with welcome screen
void Welcome (void)
{
	clear_keybuf ();				  //clear key buffer
	PlaySound (LOVE);				  //play sound "I love you, you love me"

	//display message box
	DrawMsgbox ("W E L C O M E", "Kill The Barney", "Andrew Deren 1997", "aderen@eecs.uic.edu", "Press a key to continue");
	readkey ();						  //wait for key press
	StartGameGraphics ();		  //draw graphics
	DrawMap ();
	clear_keybuf ();				  //clear key buffer
}

//exit allegro, print error message and exit program
void Error (char *string)
{
	allegro_exit ();				  //exit allegro
	printf ("Error: %s\n", string);	//print message
	exit (1);						  //exit with error code 1
}

//shortcut for playing sound from data file. which is the sound number
// from data file played at frequency 1000, volume 250 and panning 125
void PlaySound (int which)
{
	play_sample ((SAMPLE *) data[which].dat, 250, 125, 1000, FALSE);
}

//returns random number up to x-1
int Random (int x)
{
	return random () % x;
}

//clear the values of the map to 0
void ClearMap (void)
{
	int i, j;
	for (i = 0; i < MAP_SIZE; i++)
		for (j = 0; j < MAP_SIZE; j++)
			map[i][j] = 0;
}

//do the animation for the animation bitmap, drop him down to the x and y
// location decreasing its size
void Animation (int x, int y, BITMAP * animation)
{
	int size = 384;				  //size of the animation. 384 at the beginning
	BITMAP *bmp = create_bitmap (size, size);		//used for drawing the stretched barney

   //do not draw outside playing area
	set_clip (screen, 24, 24, 24 * MAP_SIZE + 24, 24 * MAP_SIZE + 24);
	clear_keybuf ();				  //clear keybuffer
	do {
		clear (bmp);				  //clear to black the bitmap
		//draw stretched barney on it
		stretch_sprite (bmp, animation, 0, 0, size, size);
		vsync ();					  //wait for vertical retrace
		vsync ();
		DrawMap ();					  //draw the map
		size = size / 2;			  //decrease the size of barney

		//draw the barney
		draw_sprite (screen, bmp, x * 24 + 24 - size / 2, y * 24 + 24 - size / 2);
		rest (125);					  //rest some time
	} while (size >= 24);		  //do it until barney is at its original size: 24

	destroy_bitmap (bmp);		  //destroy bitmap

	//set clip of the screen to whole screen
	set_clip (screen, 0, 0, SCREEN_W - 1, SCREEN_H - 1);
	DrawMap ();						  //draw map
}

//draw the frame to bmp at passed locations
//if frame is NORMAL its drawn like windows button frame
//if its INVERSE its like pressed button
void DrawFrame (BITMAP * bmp, int x1, int y1, int x2, int y2, int frame)
{
	int upcolor, locolor;		  //colors used
	if (frame == NORMAL) {		  //if its normal
		upcolor = WHITE;			  //upper and left color is WHITE
		locolor = DARKGRAY;		  //down and right color is DARKGRAY
	}
	else {							  //if it is INVERSE
   	upcolor = DARKGRAY;		  //upcolor is DARKGRAY
		locolor = WHITE;			  //locolor is WHITE
	}
	hline (bmp, x1, y1, x2, upcolor);	//top line
	hline (bmp, x1 + 1, y1 + 1, x2 - 1, upcolor);	//double
	hline (bmp, x1, y2, x2, locolor);	//bottom line
	hline (bmp, x1 + 1, y2 - 1, x2 - 1, locolor);	//double
	vline (bmp, x1, y1, y2, upcolor);	//left line
	vline (bmp, x1 + 1, y1 + 1, y2 - 1, upcolor);	//double
	vline (bmp, x2, y1, y2, locolor);	//right line
	vline (bmp, x2 - 1, y1 + 1, y2 - 1, locolor);	//double
}

//do the shooting the barney, shooting_level is the level to be shot at
//the higher the level the faster it goes and more points is given
//it returns number of points gathered
int ShootBarney (int shooting_level)
{
	int x_off, y_off;				  //offsets of the barney for each move
	int add = 0;					  //number of points
	int x, y;						  //location of barney
	int killed = 0;				  //number of barneys killed
	int missed = 0;				  //number of barneys missed
	int gx = -20, gy = -20;		  //location of the grave
	int mouse = MOUSE6;			  //mouse BITMAP from the data file
	int mouse_increment = 0;	  //mouse bitmap is changed every 8 frames; used as counter
	int shot = FALSE;				  //has shot been fired?
	int sound_played = FALSE;	  //is sound played for current shot?
	char text1[25];				  //texts for different
	char text2[25];				  //purposes
	char text3[25];
	char text4[25];

	//map bitmap is used for all drawing to screen
	clear_to_color (map_bitmap, 0);	//clear map_bitmap
	blit (map_bitmap, screen, 0, 0, 24, 24, 24 * MAP_SIZE, 24 * MAP_SIZE);
	DrawGraves ();					  //draw the graves
	x = 0;							  //location of barney is initialy 0;
	y = Random (334) + 74;		  //y is random(334) + 74
	x_off = shooting_level + 3;  //x offset (speed) is shooting_level + 3
	y_off = Random (3) - 1;		  //y offset is Random(3) - 1
	set_mouse_range (0, 0, 432, 432);	//mouse moves on the playing area only
	position_mouse (432 / 2, 432 / 2);	//position mouse on the center
	DrawFrame (screen, 24, 5, 124, 18, INVERSE);		//frame for kills
	DrawFrame (screen, 130, 5, 230, 18, INVERSE);	//frame for missed
	DrawFrame (screen, 236, 5, 336, 18, INVERSE);	//frame for level
	DrawFrame (screen, 342, 5, 455, 18, INVERSE);	//frame for score
	text_mode (LIGHTGRAY);		  //text mode LIGHTGRAY         //set text mode

	//fill the boxes with kills, misses, level, and score
	sprintf (text1, "Kills: %3d", killed);
	sprintf (text2, "Misses: %3d", missed);
	sprintf (text3, "Level: %3d", shooting_level);
	sprintf (text4, "Score: %5d", add);
	textout (screen, font, text1, 30, 8, 15);
	textout (screen, font, text2, 135, 8, 15);
	textout (screen, font, text3, 242, 8, 15);
	textout (screen, font, text4, 348, 8, 15);

	clear_keybuf ();				  //clear key buffer
	do {
		if (key[KEY_ESC])			  //if ESC pressed exit shooing
			break;
		clear_to_color (map_bitmap, 0);	//clear map_bitmap
		if (mouse_b & 1) {		  //if left mouse button pressed
			if (!sound_played) {	  //if sound hasn't been played for this shot
				sound_played = TRUE;		//set sound to was played
				if (!shot) {		  //if shot hasn't been fired
					PlaySound (SHOT);		//play sound of shot
					shot = TRUE;	  //set shot fired to TRUE

					//check if barney was hit
					if ((mouse_x > x && mouse_x < x + 24) && (mouse_y > y && mouse_y < y + 24)) {
						PlaySound (BARNEY_SHOT);	//play sound of barney shot
						gx = x;		  //x location of grave
						gy = y;		  //y location of grave

						//increment score
						add += shooting_level * 50 - shooting_level * (x / 10);
						x = 500;		  //barney is done
					}
					else				  //if barney was not shot draw it on map_bitmap
						draw_sprite (map_bitmap, (BITMAP *) data[BARNEY].dat, x, y);

				   //draw sprite of the shot
					draw_sprite (map_bitmap, (BITMAP *) data[SHOT_BMP].dat, mouse_x - 7, mouse_y - 7);

					//blit map_bitmap to screen
					blit (map_bitmap, screen, 0, 0, 24, 24, 24 * MAP_SIZE, 24 * MAP_SIZE);
				}
				else					  //if shot was already fired and it is shot again
					PlaySound (ERROR);	//play error sound
			}							  //end if sound played
		}								  //end if button pressed
		else
			sound_played = FALSE;  //sound is not played

		//draw barney at x and y location
		draw_sprite (map_bitmap, (BITMAP *) data[BARNEY].dat, x, y);
		//draw grave
		draw_sprite (map_bitmap, (BITMAP *) data[BARNEY_DEAD].dat, gx, gy);
		//draw mouse pointer
		draw_sprite (map_bitmap, (BITMAP *) data[mouse].dat, mouse_x - 12, mouse_y - 12);
		//wait for vertical retrace
		vsync ();
		vsync ();
		//blit double buffer
		blit (map_bitmap, screen, 0, 0, 24, 24, 24 * MAP_SIZE, 24 * MAP_SIZE);
		mouse_increment++;		  //increment mouse_increment
		if (mouse_increment > 8) {		//if mouse increment is greater than 8
			mouse--;					  //mouse frame is decremented
			if (mouse < MOUSE1)	  //if last first mouse frame was used
				mouse = MOUSE6;	  //change it to last
			mouse_increment = 0;	  //mouse increment is 0
		}
		x += x_off;					  //increment barney x location
		y += y_off;					  //increment barney y location
		if (x > 432 || y < 0 || y > 432) {	//if barney is outside screen
			if (x > 500)			  //if its greater than 500 it got shot
				killed++;
			else						  //escaped
				missed++;
			y = Random (334) + 74; //get new y location
			shot = FALSE;			  //get new shot
			graves--;				  //decrease graved
			x = 0;					  //x location of barney is 0
			y_off = Random (5) - 2;		//set y offset
			//print info in boxes on top
			sprintf (text1, "Kills: %3d", killed);
			sprintf (text2, "Misses: %3d", missed);
			textout (screen, font, text1, 30, 8, 15);
			textout (screen, font, text2, 135, 8, 15);
			sprintf (text4, "Score: %5d", add);
			textout (screen, font, text4, 348, 8, 15);
			DrawGraves ();			  //draw graves on right side
			DrawScoreBox ();		  //draw score box
		}
      if (key[KEY_F10]) {  //if F10 pressed save screen to file
         //create temp bitmap
         BITMAP *tbmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
         //save the picture with game pallete
         save_pcx("ktb.pcx", tbmp, (RGB*)data[GAME_PALLETE].dat);
         destroy_bitmap(tbmp);     //destroy bitmap
         while (key[KEY_F10]) {};  //wait until f10 is released
      }
	} while (graves > 0);		  //keep shooting until all barneys have run

	//do exit message box
	sprintf (text1, "Kills: %d", killed);
	sprintf (text2, "Missed: %d", missed);
	if (killed + missed != 0)
		sprintf (text3, "Accuracy: %d %%", (killed * 100) / (killed + missed));
	else
		sprintf (text3, "Accuracy: 0 %%");
	sprintf (text4, "Shooting Score: %d", add);
	clear_keybuf ();
	DrawMsgbox ("Performence", text1, text2, text3, text4);
	readkey ();
	clear_keybuf ();
	StartGameGraphics ();		  //redraw screen
	return add;						  //return score
}

//shootingtest is used for practice of shooting
//test_level is the level to test; the greater the faster
void ShootingTest (int test_level)
{
	int old_graves = graves;	  //save number of graves
	graves = 16;					  //give 16 barneys to shoot at
	ShootBarney (test_level);	  //shoot barney at test_level
	graves = old_graves;			  //restore number of graves
	StartGameGraphics ();		  //redraw screen
	DrawMap ();
}

//draw graphics for the screen
void StartGameGraphics (void)
{
	clear_to_color (screen, LIGHTGRAY);
	//frame around playing area
	DrawFrame (screen, 22, 22, 26 + 24 * MAP_SIZE, 26 + 24 * MAP_SIZE, INVERSE);
	//frame around screen
	DrawFrame (screen, 0, 0, 469, 479, NORMAL);
	DrawFrame (screen, 470, 0, 639, 479, NORMAL);
	//frame around score box
	DrawFrame (screen, 480, 24, 625, 120, INVERSE);
	//Draw help box
	DrawFrame (screen, 480, 425, 625, 455, INVERSE);
	text_mode (-1);
	//fill help box
	textout (screen, font, "Andrew Deren 1997", 485, 430, GRIDCOLOR);
	textout (screen, font, "Press F1 for Help", 485, 445, GRIDCOLOR);
	//draw barney
	draw_sprite (screen, (BITMAP *) data[BIG_BARNEY].dat, 480, 286);
	//draw frame around graves
	DrawFrame (screen, 480, 140, 625, 285, INVERSE);
	DrawGraves ();
}

//draw graves on the right side
void DrawGraves (void)
{
	//erase previous graves
	solid_mode ();
	rectfill (screen, 483, 143, 622, 282, LIGHTGRAY);
	int y = 144;					  //y position of graves to be drawn
	int x = 484;					  //x position
	//draw graves
	for (int i = 0; i < graves; i++, x += 34) {
		if (i > 15)					  //only 16 graves can be drawn
			break;
		if (x > 590) {				  //if x > 590; full row
			x = 484;					  //go to next column
			y += 34;
		}
		//draw grave
		draw_sprite (screen, (BITMAP *) data[BARNEY_DEAD].dat, x, y);
	}									  //end for loop
}

//draw message box and ask if player wants to exit
//return true or false
int ExitPrompt (void)
{
	int exit_code;					  //return value to be returned

	clear_keybuf ();
	//draw message box
	DrawMsgbox ("A l e r t", "Are you sure you want to exit?", "[ Y / N ]", NULL, NULL);
	//get keypress
	exit_code = readkey ();
	if ((exit_code >> 8) == KEY_Y)	//if y was pressed
		exit_code = TRUE;			  //exit code is true
	else								  //else
		exit_code = FALSE;		  //exit code is false
	StartGameGraphics ();		  //redraw screen
	DrawMap ();
	clear_keybuf ();
	return exit_code;				  //return exit code
}

//draw help box
void Help (void)
{
	BITMAP *bmp = create_bitmap (400, 300);	//help bitmap

	clear_to_color (bmp, LIGHTGRAY);
	text_mode (-1);
	clear_keybuf ();
	//Draw frame around help bitmap
	DrawFrame (bmp, 0, 0, bmp->w - 1, bmp->h - 1, NORMAL);
	//frame around title
	DrawFrame (bmp, 100, 20, bmp->w - 100, 50, INVERSE);
	textout_centre (bmp, font, "H E L P", 200, 35, 15);
	//frame around text
	DrawFrame (bmp, 20, 70, bmp->w - 20, bmp->h - 30, INVERSE);

	//fill box with text
	textout (bmp, font, "K E Y S: ", 30, 80, 0);
   textout (bmp, font, "ESC         - Exit", 30, 100, 0);
   textout (bmp, font, "F1          - Help", 30, 115, 0);
   textout (bmp, font, "F2          - New Game", 30, 130, 0);
   textout (bmp, font, "H           - View high scores", 30, 145, 0);
   textout (bmp, font, "G           - Toggle grid On/Off", 30, 160, 0);
   textout (bmp, font, "B           - Release bomb", 30, 175, 0);
   textout (bmp, font, "T           - Teleport", 30, 190, 0);
	textout (bmp, font, "KeyPad keys - Move", 30, 205, 0);
   textout (bmp, font, "1-0         - Shooting Test", 30, 220, 0);
   textout (bmp, font, "Read readme.txt for more info", 30, 245, 0);
	textout_centre (bmp, font, "Press any key exit", 200, bmp->h - 20, 0);

	//blit bitmap to screen
	blit (bmp, screen, 0, 0, 120, 90, bmp->w, bmp->h);
	readkey ();						  //wait for key press
	destroy_bitmap (bmp);		  //destroy bitmap
	clear_keybuf ();
	StartGameGraphics ();		  //redraw screen
	DrawMap ();
}

//draw the map
void DrawMap (void)
{
	int i, j;						  //loop counters
	BITMAP *bitmap;				  //pointer to sprite to be drawn
	clear (map_bitmap);			  //clear map_bitmap

	//go through all the tiles of map
	for (i = 0; i < MAP_SIZE; i++) {
		for (j = 0; j < MAP_SIZE; j++) {
			bitmap = NULL;			  //set bitmap to null
			if (map[i][j] == -1)	  //if map is -1; debris
				bitmap = (BITMAP *) data[BARNEY_DEAD].dat;	//bitmap is grave
			else if (map[i][j] > 0)		//if map is > 0 bitmap is barney
				bitmap = (BITMAP *) data[BARNEY].dat;
			if (bitmap)				  //if bitmap is not null; either barney or grave
				draw_sprite (map_bitmap, bitmap, i * 24, j * 24);	//draw it
		}								  //end for j
	}									  //end for i
	//draw player
	draw_sprite (map_bitmap, (BITMAP *) data[YOU].dat, x_loc * 24, y_loc * 24);
	//draw bomb
	if (bomb_x != -1)
		draw_sprite (map_bitmap, (BITMAP *) data[BMP_BOMB].dat, bomb_x * 24, bomb_y * 24);
	if (GridOn) {					  //if grid is on draw it
		for (i = 1; i <= MAP_SIZE; i++) {
			//vertical lines
			vline (map_bitmap, i * 24, 0, 24 * MAP_SIZE, GRIDCOLOR);
			//horizontal lines
			hline (map_bitmap, 0, i * 24, 24 * MAP_SIZE, GRIDCOLOR);
		}								  //end for i
	}									  //end if gridon
	vsync ();						  //wait for vertical retrace
	vsync ();
	//blit map_bitmap to screen
	blit (map_bitmap, screen, 0, 0, 24, 24, 24 * MAP_SIZE, 24 * MAP_SIZE);
	DrawScoreBox ();				  //draw score, level, etc.
}

//fill score box with score,level, no. graves etc.
void DrawScoreBox (void)
{
	char text[24];					  //temp text
	text_mode (LIGHTGRAY);
	//print score
	sprintf (text, "Score: %5d", score);
	textout (screen, font, text, 485, 30, GRIDCOLOR);
	//print level
	sprintf (text, "Level: %5d", level);
	textout (screen, font, text, 485, 45, GRIDCOLOR);
	//print number of bombs
	sprintf (text, "Bombs: %5d", bombs);
	textout (screen, font, text, 485, 60, GRIDCOLOR);
	//print no. of remainint barneys
	sprintf (text, "Alive: %5d", alive);
	textout (screen, font, text, 485, 75, GRIDCOLOR);
	//print highscore
	sprintf (text, "HighScore: %d", high_scores[0].score);
	textout (screen, font, text, 485, 90, GRIDCOLOR);
	//print number of graves
	sprintf (text, "Graves: %4d", graves);
	textout (screen, font, text, 485, 105, GRIDCOLOR);
}

//draw message box with title and four lines of text
void DrawMsgbox (char *title, char *string1, char *string2, char *string3, char *string4)
{
	BITMAP *bmp;					  //bitmap of window
	int number = 0;				  //current y position
	int size = 0;					  //width

	//figure out width of box
	if (title)
		size = text_length (font, title) + 40;
	else
		size = 0;
	//find the longest string
	if (string1)
		if (text_length (font, string1) > size)
			size = text_length (font, string1);
	if (string2)
		if (text_length (font, string2) > size)
			size = text_length (font, string2);
	if (string3)
		if (text_length (font, string3) > size)
			size = text_length (font, string3);
	if (string4)
		if (text_length (font, string4) > size)
			size = text_length (font, string4);

	//figure our height
	if (string1)
		number += 25;
	if (string2)
		number += 25;
	if (string3)
		number += 25;
	if (string4)
		number += 25;

	text_mode (-1);
	bmp = create_bitmap (size + 40, 125 + number);	//creat bitmap
	clear_to_color (bmp, LIGHTGRAY);		//clear it to LIGHTGRAY

	//draw frame around bitmap
	DrawFrame (bmp, 0, 0, bmp->w - 1, bmp->h - 1, NORMAL);
	if (title) {					  //if it has title
		//draw frame around title area
		DrawFrame (bmp, 20, 20, bmp->w - 20, 40, INVERSE);
		//print title
		textout_centre (bmp, font, title, bmp->w / 2, 27, 15);
	}
	//text lines start at 90
	number = 90;
	if (string1) {					  //if line 1
		//print it
		textout_centre (bmp, font, string1, bmp->w / 2, number, 0);
		number += 25;				  //incrment y location
	}
	if (string2) {
		textout_centre (bmp, font, string2, bmp->w / 2, number, 0);
		number += 25;
	}
	if (string3) {
		textout_centre (bmp, font, string3, bmp->w / 2, number, 0);
		number += 25;
	}
	if (string4) {
		textout_centre (bmp, font, string4, bmp->w / 2, number, 0);
		number += 25;
	}
	vsync ();						  //wait for vertical retrace
	vsync ();
	//blit message box to screen
	blit (bmp, screen, 0, 0, 320 - bmp->w / 2, 240 - bmp->h / 2, bmp->w, bmp->h);
	destroy_bitmap (bmp);		  //destroy bitmap
}

//move player; x_change and y_change are values by how much
//the player is moved; returns TRUE if can move there or FALSE 
//if can't (outside playing area)
int MoveYou (int x_change, int y_change)
{
	int tx, ty;						  //temporary current position of player
	tx = x_loc + x_change;		  //set new position
	ty = y_loc + y_change;
	//check if it's not outside playing area
	if (tx < 0 || tx >= MAP_SIZE || ty < 0 || ty >= MAP_SIZE) {
		PlaySound (ERROR);		  //if it is play error sound
		return FALSE;				  //return false
	}
	else {							  //can move there
		PlaySound (MOVE);			  //play move sound
		x_loc = tx;					  //set actual position
		y_loc = ty;
		if (x_loc == bomb_x && y_loc == bomb_y) {		//player found bomb
			bombs++;					  //increment number of bombs
			bomb_x = bomb_y = -1;  //disable bomb
			PlaySound (FINDBOMB);
		}
		return TRUE;				  //return true
	}
}

//move all eaters and figure out collisions
void MoveThem (void)
{
	int i, j;						  //loop counters
	int xoff, yoff;				  //offsets to move
	alive = 0;						  //number of eaters alive
	int tmap[MAP_SIZE][MAP_SIZE];		//copy of map used to figure out collisions
	//clear tmap and copy the values from map if it is <= 0
	for (i = 0; i < MAP_SIZE; i++) {
		for (j = 0; j < MAP_SIZE; j++) {
			if (map[i][j] > 0)	  //if map is > 0; barney is there
				tmap[i][j] = 0;	  //don't put it on tmap
			else
				tmap[i][j] = map[i][j];		//else copy map to tmap
		}								  //end for i
	}									  //end for j
	// move eaters
	for (i = 0; i < MAP_SIZE; i++) {
		for (j = 0; j < MAP_SIZE; j++) {
			if (map[i][j] > 0) {	  //eater exists on map
				if (i < x_loc)
					xoff = 1;		  //get new x coordinate
				else if (i > x_loc)
					xoff = -1;
				else
					xoff = 0;
				if (j < y_loc)
					yoff = 1;		  //get new y coordinate
				else if (j > y_loc)
					yoff = -1;
				else
					yoff = 0;

				// eater bumped into debris
				if (tmap[i + xoff][j + yoff] == -1) {
					PlaySound (COLLIDE);		//play collide sound
					//drop barney down
					Animation (i + xoff, j + yoff, (BITMAP *) data[BARNEY].dat);
					//tmap is -1; debris
					tmap[i + xoff][j + yoff] = -1;
					score += 50;	  //increment score by 50
				}
				//move eater to new position
				else if (tmap[i + xoff][j + yoff] >= 0)
					//add one to tmap so that when eater hasnot moved
					//and moved eater is put in there, collision does not occur
					tmap[i + xoff][j + yoff] = tmap[i + xoff][j + yoff] + 1;
			}							  //end if map is > 0
		}								  //end for j
	}									  //end for i

	//check if barneys collide
	for (i = 0; i < MAP_SIZE; i++) {
		for (j = 0; j < MAP_SIZE; j++) {
			if (tmap[i][j] > 1) {  //if tmap is > 1 then 2 or move eaters are there
				score += tmap[i][j] * 80;	//score += 80 * number of colliding eaters
				graves++;			  //incrment number of graves
				DrawGraves ();		  //draw graves
				PlaySound (COLLIDE);		//play collide sound
				//drop barney down
				Animation (i, j, (BITMAP *) data[BARNEY].dat);
				DrawMap ();			  //draw map
				tmap[i][j] = -1;	  //map at that space is not grave
			}
			else if (tmap[i][j] == 1)	//if there is one barney
				alive++;				  //incrment number of barneys alive
		}								  //end for j
	}									  //end for i
	//copy tmap to map
	for (i = 0; i < MAP_SIZE; i++) {
		for (j = 0; j < MAP_SIZE; j++) {
			map[i][j] = tmap[i][j];
		}								  //end for j
	}									  //end for i
	DrawMap ();						  //draw the map
	//barney stepped on the bomb
	if (map[bomb_x][bomb_y] == 1) {
		PlaySound (BOMB);			  //play BOMB sound
		Animation (bomb_x, bomb_y, (BITMAP *) data[BMP_BOMB].dat);	//drop bomb
		score += 100;				  //increment score
		map[bomb_x][bomb_y] = 0;  //barney does not exist
		alive--;						  //barney killed
      FrameAnimation(bomb_x-1, bomb_y-1, EXP1, EXP4, 250);
		bomb_x = bomb_y = -1;	  //disable bomb
	}
	if (alive == 0) {				  //level finished
		GoNextLevel ();			  //go to next level
		score += ShootBarney (level - 1);	//do shooting
	}									  //end if
}										  //end move them

//teleport player to random position
void TelePort (void)
{
	int x, y;						  //temp x and y positions
 	PlaySound (TELEPORT);		  //play teleport sound
   FrameAnimation(x_loc, y_loc, TELE1, TELE6, 200); //dissolve player
   x_loc = y_loc = -3;          //delete player form map
   DrawMap();                   //draw map
	while (1 == 1) {				  //repeat until found empty spot
		x = Random (MAP_SIZE);	  //new x
		y = Random (MAP_SIZE);	  //new y
		if (map[x][y] == 0)		  //check if new position is empty
			break;
	}
	//drop player down
	Animation (x, y, (BITMAP *) data[YOU].dat);
	x_loc = x;						  //set x_loc
	y_loc = y;						  //set y_loc
	if (score > 5)					  //is score > 5
		score -= 5;					  //decrement score
}

//start new level; put barneys on the map and put player on the map
void StartLevel (void)
{
	int i, x, y;					  //temp values
	ClearMap ();					  //clear map to 0's
	//figure out new barneys locations
	for (i = 0; i < num_eaters; i++) {
		while (1 == 1) {			  //do until empty map place found
			x = Random (MAP_SIZE);
			y = Random (MAP_SIZE);
			if (map[x][y] == 0)
				break;
		}								  //end while
		map[x][y] = 1;				  //set map x,y to barney
	}									  //end for
	while (1 == 1) {				  //find player location
		x_loc = Random (MAP_SIZE);
		y_loc = Random (MAP_SIZE);
		if (map[x_loc][y_loc] == 0)
			break;
	}
	while (1 == 1) {				  //find empty space and put bomb in there
		bomb_x = Random (MAP_SIZE);
		bomb_y = Random (MAP_SIZE);
		if (map[bomb_x][bomb_y] == 0)
			break;
	}									  //end while
}										  //end startlevel

//go to next level
void GoNextLevel (void)
{
	char text[50];					  //temp text
	char text1[50];				  //temp text
	num_eaters++;					  //increment number of barneys
	alive = num_eaters;			  //number of alive barneys at the beginning of level
	bombs++;							  //add one bomb
	score += level * 200;		  //increment score
	level++;							  //increment level
	PlaySound (ENDLEVEL);		  //play end level sound
	//do end level message box
	sprintf (text, "You just finished level: %d", level - 1);
	sprintf (text1, "Your score: %d", score);
	DrawMsgbox ("Level Finished", text, text1, "Press any key to coninue", NULL);
	clear_keybuf ();
	readkey ();
	clear_keybuf ();
	StartGameGraphics ();		  //redraw screen
	DrawMap ();
	StartLevel ();					  //start new level
}

//initialize game stuff
void GameInit (void)
{
	printf ("Initializing allegro...\n");
	allegro_init ();				  //initialize allegro

	printf ("installing keyboard handler...\n");
	install_keyboard ();			  //install keyboard handler

	printf ("installing timer...\n");
	install_timer ();				  //install timer

	printf ("installing mouse...\n");
	install_mouse ();				  //install mouse

	printf ("installing sound and music drivers...\n");
	if (install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
		Error ("Error initializing sound.");

   if (!exists ("ktb.dat"))    //check if data file exists
      Error ("Cannot find ktb.dat file.");

	//load data file
	printf ("loading data file(s)...\n");
   data = load_datafile ("ktb.dat");

	//set graphics mode
	set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);	//set graphics mode to 640x480x256

	//set black pallete (all color black)
	set_pallete (black_pallete);
	clear (screen);				  //clear the screen

	//draw RVAD logo
	blit ((BITMAP *) data[BMP_WELCOME].dat, screen, 0, 0, 120, 65, 400, 350);
	//fade in slowly
	fade_in ((RGB *) data[GAME_PALLETE].dat, 1);

	clear_keybuf ();
	textout_centre (screen, font, "Press a key to continue.", 320, 460, 15);
	readkey ();						  //wait for keypress

	srandom ((int) time (NULL)); //randomize random seed

	ClearMap ();					  //clear map

	GridOn = FALSE;				  //grid on is false

	//get memory for map_bitmap
	map_bitmap = create_bitmap (24 * MAP_SIZE, 24 * MAP_SIZE);

	//number of eaters is START_EATERS in first level
	num_eaters = alive = START_EATERS;

	//open file with highscores
	FILE *file = fopen ("game1.hsc", "rb");
	if (file) {						  //if it exists
		//read highscores
		fread (&high_scores, sizeof (HIGH_SCORE), MAX_HIGHSCORES, file);
		fclose (file);
	}									  //end if
	else {							  //if it does not exist put default highscores
		for (int i = 0; i < MAX_HIGHSCORES; i++) {
			high_scores[i].score = 0;
			high_scores[i].level = 0;
			strcpy (high_scores[i].name, "....................");
		}								  //end for
	}									  //end else
}										  //end game init

//check if bomb kills barney at x and y location
//and if barney is there kill it
int CheckBomb (int x, int y)
{
	//check if x and y is on the map
	if (x < 0 || y < 0 || x >= MAP_SIZE || y >= MAP_SIZE)
		return FALSE;
	//check if barney is there
	if (map[x][y] > 0) {
		//drop bomb down
		Animation (x, y, (BITMAP *) data[BMP_BOMB].dat);	//drop bomb
  		map[x][y] = 0;				  //empty that space
		FrameAnimation (x-1, y-1, EXP1, EXP4, 250);	  //do explosion
		return TRUE;				  //barney killed
	}
	else								  //barney is not there
		return FALSE;
}

//update highscores, using current score check if it makes to top highscores
//and if it does put it there, return which place or 0 if it did not
//make it to top list
int UpdateHighScores (void)
{
	int i;							  //loop counter
	//check if score is > than last highscore
	if (score <= high_scores[MAX_HIGHSCORES - 1].score)
		return 0;					  //did not make it

	//figure out which place
	for (i = MAX_HIGHSCORES - 1; i >= 0; i--) {
		if (score > high_scores[i].score) {		//score is > current highscore
			//copy highscores from above to lower position
			if (i > 0) {
				high_scores[i].score = high_scores[i - 1].score;
				strcpy (high_scores[i].name, high_scores[i - 1].name);
				high_scores[i].level = high_scores[i - 1].level;
			}
		}
		else							  //found highscores position for score
			break;
	}
	high_scores[i + 1].score = score;	//put score
	high_scores[i + 1].level = level;	//put level
	return i + 2;					  //return place
}

//view highscores; lite is highscore to be displayed in white
//used when highscore is played to show it
void ViewHighScores (int lite)
{
	int i, color;
	char text[128];
	//creat bitmap
	BITMAP *bmp = create_bitmap (400, 100 + MAX_HIGHSCORES * 15);
	clear_to_color (bmp, LIGHTGRAY);
	//draw frame aroudn bitmap
	DrawFrame (bmp, 0, 0, bmp->w - 1, bmp->h - 1, NORMAL);
	//draw frame aroudn title
	DrawFrame (bmp, 20, 15, bmp->w - 20, 35, INVERSE);
	//put title
	textout_centre (bmp, font, "H I G H   S C O R E S", bmp->w / 2, 22, 15);
	//print headings
	textout (bmp, font, "No.", 20, 55, 0);
	textout (bmp, font, "Name:", 70, 55, 0);
	textout (bmp, font, "Level:", 230, 55, 0);
	textout (bmp, font, "Score:", 300, 55, 0);
	//print highscore info
	for (i = 0; i < MAX_HIGHSCORES; i++) {
		if (i + 1 == lite)		  //if i is lite color is white
			color = 15;
		else							  //else color is black
			color = 0;
		//print place
		sprintf (text, "%2d", i + 1);
		textout (bmp, font, text, 20, 75 + i * 15, color);
		//print name
		textout (bmp, font, high_scores[i].name, 70, 75 + i * 15, color);
		//print level
		sprintf (text, "%2d", high_scores[i].level);
		textout (bmp, font, text, 240, 75 + i * 15, color);
		//print score
		sprintf (text, "%5d", high_scores[i].score);
		textout (bmp, font, text, 300, 75 + i * 15, color);
	}
	textout_centre (bmp, font, "Press any key to exit", bmp->w / 2, bmp->h - 20, 0);
	//blit bitmap
	blit (bmp, screen, 0, 0, 320 - bmp->w / 2, 240 - bmp->h / 2, bmp->w, bmp->h);
	destroy_bitmap (bmp);		  //free memory
	clear_keybuf ();
	readkey ();						  //wait for keypress
	clear_keybuf ();
	StartGameGraphics ();		  //redraw screen
	DrawMap ();
}

//display input box and get highscore; put it in highscores
//structure in passed place
void GotHighScore (int place)
{
	char text[23];					  //name
	int ch;							  //character entered
	int l = 0;						  //current length of text
	int x, y;						  //temp locations
	//bitmap of the input box
	BITMAP *bmp = create_bitmap (250, 150);
	clear_to_color (bmp, LIGHTGRAY);
	//draw frame around box
	DrawFrame (bmp, 0, 0, bmp->w - 1, bmp->h - 1, NORMAL);
	//draw frame aroudn title
	DrawFrame (bmp, 20, 20, bmp->w - 20, 40, INVERSE);
	//draw title
	textout_centre (bmp, font, "H I G H  S C O R E", bmp->w / 2, 27, 15);
	//print message
	textout_centre (bmp, font, "Enter your name: ", bmp->w / 2, 70, 0);
	//draw frame around typing area
	DrawFrame (bmp, 30, 90, bmp->w - 30, 110, INVERSE);
	//center bitmap
	x = 320 - bmp->w / 2;
	y = 240 - bmp->h / 2;
	//blit it to screen
	blit (bmp, screen, 0, 0, x, y, bmp->w, bmp->h);
	text[0] = '\0';				  //initialize text
	clear_keybuf ();
	text_mode (LIGHTGRAY);
	textout (screen, font, text, 40, 97, 15);
	//draw cursor
	textout (screen, font, "_", x + text_length (font, text) + 40, y + 97, 15);
	do {								  //do the loop
		if (keypressed ()) {		  //if keypressed
			ch = readkey () & 0x00ff;	//get the key
			if ((ch > 31) && (ch < 127) && (l < 20)) {	//if it is valid character
				text[l + 1] = '\0'; //next character is '\0'
				text[l] = ch;		  //current character is ch
				l++;					  //incrment number of letters typed
				PlaySound (TYPE);	  //play TYPE sound
			}							  //end if
			//backspace pressed
			else if ((key[KEY_BACKSPACE]) && (l > 0)) {
				l--;					  //decrement number of characters
				text[l] = '\0';	  //terminate text
				PlaySound (TYPE);	  //play TYPE sound
			}							  //end else if
			//player is finished typing
			else if (key[KEY_ENTER] || key[KEY_ESC])
				break;
			else						  //invalid key pressed or too many characters
				PlaySound (ERROR);  //play error sound
			//erase previous text
			rectfill (screen, x + 32, y + 92, x + bmp->w - 32, y + 108, LIGHTGRAY);
			//put text
			textout (screen, font, text, x + 40, y + 97, 15);
			//put cursor
			textout (screen, font, "_", x + text_length (font, text) + 40, y + 97, 15);
		}								  //end if keypressed

	} while (1 == 1);				  //loop terminated by break when ENTER or ESC pressed
	//copy text to highscores structure
	strcpy (high_scores[place - 1].name, text);
}

//animate sprites from data file at x and y; start with start and end
//with end frames from data file; x and y are between 1..18
void FrameAnimation (int x, int y, int start, int end, int delay)
{
	//do 4 frames
	for (int i = start; i <= end; i++) {
		//current frame is EXP1 + 1 from data file
      blit((BITMAP*)data[EMPTY].dat, map_bitmap, 0, 0, x * 24+1, y * 24+1, 23, 23);
		draw_sprite (map_bitmap, (BITMAP *) data[i].dat, x * 24, y * 24);
		rest (delay);					  //rest some time
		vsync ();					  //vertical retrace
		vsync ();
		//blit the map_bitmap
		blit (map_bitmap, screen, 0, 0, 24, 24, 24 * MAP_SIZE, 24 * MAP_SIZE);
	}									  //end for
}


//user wants to use the bomb; check all the squares around player and
//kill barneys in there
void DropBomb (void)
{
	if (bombs <= 0)				  //player has no bombs
		return;
	int killed = 0;				  //count how many banrneys got killed
	PlaySound (BOMB);				  //play explosion sound
	if (CheckBomb (x_loc - 1, y_loc - 1))	//upper left
		killed++;
	if (CheckBomb (x_loc, y_loc - 1))	//up center
		killed++;
	if (CheckBomb (x_loc + 1, y_loc - 1))	//up right
		killed++;
	if (CheckBomb (x_loc + 1, y_loc))	//left center
		killed++;
	if (CheckBomb (x_loc + 1, y_loc + 1))	//lower right
		killed++;
	if (CheckBomb (x_loc, y_loc + 1))	//lower center
		killed++;
	if (CheckBomb (x_loc - 1, y_loc + 1))	//lower left
		killed++;
	if (CheckBomb (x_loc - 1, y_loc))	//right center
		killed++;
	bombs--;							  //decrement number of bombs
	score += killed * 50;		  //for each killed barney add 50 points
}

//start a new game
void NewGame (void)
{
	score = 0;						  //score is 0
	bombs = 1;						  //initialy player has 1 bomb
	graves = 0;						  //number of graves is 0
	level = 1;						  //level is 1
	num_eaters = alive = START_EATERS;	//set number of barneys
	StartLevel ();					  //start level
	StartGameGraphics ();		  //draw screen graphics
	DrawMap ();						  //draw map
}

//player died
void GameOver (void)
{
	char text[25];
	PlaySound (GAMEOVER);		  //play game over sound
   FrameAnimation(x_loc, y_loc, DIE1, DIE6, 200);     //do dying animation
	int temp = UpdateHighScores ();	//update highscores
	//temp is which place the player is in. 0 did not make it
	if (temp) {						  //made it to top
		//do message box
		sprintf (text, "You are number %d", temp);
		clear_keybuf ();
		DrawMsgbox ("You got high score", "Congratulations you made it",
						"to the top 10 list", text, "Press a key to exit");
		readkey ();					  //wait for key press
		clear_keybuf ();
		GotHighScore (temp);		  //get name
	}									  //end if
	else {							  //player did not make it to highscores list
		//do messgage box
		sprintf (text, "Score: %d", score);
		DrawMsgbox ("Game Over", "You Died!!!!!", "Barney Got You!!!", "Press any key to start new game", text);
		temp = -1;					  //do not highlite any place

		clear_keybuf ();
		readkey ();					  //wait for keypress
		clear_keybuf ();
	}
	ViewHighScores (temp);		  //view highscores
	NewGame ();						  //start new game
}

//play game; game loop;
void PlayGame (void)
{
	int ch;							  //key pressed
	GridOn = TRUE;					  //when first time game started grid is on
	NewGame ();						  //start new game
	Welcome ();						  //show welcome message box
	while (1 == 1) {				  //loop terminated by break when ESC pressed
		ch = readkey ();			  //wait for key press
		ch = ch >> 8;
		if (ch == KEY_ESC) {		  //esc pressed
			if (ExitPrompt ())	  //exit prompt
				break;				  //exit program
		}
		else if (ch == KEY_F1)	  //F1 pressed
			Help ();					  //show help
		else if (ch == KEY_F2)	  //F2 pressed
			NewGame ();				  //new game
		else if (ch == KEY_T) {	  //t pressed teleport
			TelePort ();
			MoveThem ();
		}
		else if (ch == KEY_HOME) {		//move up left
			if (MoveYou (-1, -1))
				MoveThem ();
		}
		else if (ch == KEY_UP) {  //move up
			if (MoveYou (0, -1))
				MoveThem ();
		}
		else if (ch == KEY_PGUP) {		//move up right
			if (MoveYou (1, -1))
				MoveThem ();
		}
		else if (ch == KEY_RIGHT) {	//move right
			if (MoveYou (1, 0))
				MoveThem ();
		}
		else if (ch == KEY_PGDN) {		//move down right
			if (MoveYou (1, 1))
				MoveThem ();
		}
		else if (ch == KEY_DOWN) {		//move down
			if (MoveYou (0, 1))
				MoveThem ();
		}
		else if (ch == KEY_END) { //move down left
			if (MoveYou (-1, 1))
				MoveThem ();
		}
		else if (ch == KEY_LEFT) {		//move left
			if (MoveYou (-1, 0))
				MoveThem ();
		}
		else if (ch == KEY_5_PAD) {	//stay in same place
			if (MoveYou (0, 0))
				MoveThem ();
		}
		else if (ch == KEY_G) {	  //toggle grid
			if (GridOn)
				GridOn = FALSE;
			else
				GridOn = TRUE;
		}
		else if (ch == KEY_1)	  //shooting practice level 1
			ShootingTest (1);
		else if (ch == KEY_2)	  //shooting practice level 2
			ShootingTest (2);
		else if (ch == KEY_3)	  //shooting practice level 3
			ShootingTest (3);
		else if (ch == KEY_4)	  //shooting practice level 4
			ShootingTest (4);
		else if (ch == KEY_5)	  //shooting practice level 5
			ShootingTest (5);
		else if (ch == KEY_6)	  //shooting practice level 6
			ShootingTest (6);
		else if (ch == KEY_7)	  //shooting practice level 7
			ShootingTest (7);
		else if (ch == KEY_8)	  //shooting practice level 8
			ShootingTest (8);
		else if (ch == KEY_9)	  //shooting practice level 9
			ShootingTest (9);
		else if (ch == KEY_0)	  //shooting practice level 10
			ShootingTest (10);
		else if (ch == KEY_B) {	  //put bomb
			if (bombs > 0) {
				DropBomb ();
				MoveThem ();
			}
		}
		else if (ch == KEY_H)	  //display highscores
			ViewHighScores (1);
		DrawMap ();					  //draw the map
		if (map[x_loc][y_loc] != 0)	//barney is on player
			GameOver ();			  //game over
	}									  //end if keypressed
}										  //end PlayGame()

//main function
main ()
{
	GameInit ();					  //initialize game
	PlayGame ();					  //start game
	allegro_exit ();				  //exit allegro
	FILE *file;						  //save high scores
	file = fopen ("game1.hsc", "wb");
	if (file) {
		fwrite (&high_scores, sizeof (HIGH_SCORE), MAX_HIGHSCORES, file);
		fclose (file);
	}
	//display goodbye screen
   printf ("                         R V A D  S o f t w a r e                      \n");
	printf ("                           Kill The Barney  v1.0                       \n");
	printf ("                                May 27, 1997                           \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("                         Programing and Graphics by                    \n");
	printf ("                               Andrew Deren                            \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("                            Special Thanks To:                         \n");
	printf ("                      DJ Delorie - for making DJGPP                    \n");
	printf ("           Shawn Hargreaves - for making allegro game library          \n");
   printf ("                 Jerremy Penner (ArmPitMan) - For the idea             \n");  
	printf ("              and all the other people who contributed to              \n");
	printf ("                 DJGPP development tools and utilities.                \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("\n\n\n");
}
