#define RES_X				640
#define RES_Y				480

#define HALF_RES_X			320
#define HALF_RES_Y			240

#define FRICTION			0.5
#define BOUNCE				0.01
#define GRAVITY				0.098

#define MAX_JETS			49
#define USE_JETS			0.083
#define GET_JETS			5

#define JOE_COLOUR			5
#define JOE_OUTLINE			15

#define JUMP_STRENGTH		        5

#define JET_STRENGTH			0.2
#define JOE_SPEED			1.5
#define START_LIVES			3

#define MAX_SPRINGS			100
#define SPRING_SPEED			2

#include <allegro.h>

#include "fontsprites.c"
#include "map.c"

void init_map();
void exit_system( int n );
void load_next_level();
void load_level();
void new_game();

volatile int game_timer = 0;
void inc_game_timer()
{
	game_timer++;
} END_OF_FUNCTION( inc_game_timer );



typedef struct JOETYPE
{
	float x, y;
	float vx, vy;
	int dir;
	int jetpack_on;

	float jets_left;
	int got_coins;
	int lives;
} JOETYPE;


typedef struct SPRINGTYPE
{
	int x, y;
	int axis;			// 0 for y, 1 for x
	int v;
} SPRINGTYPE;

JOETYPE joe;
SPRINGTYPE spring[ MAX_SPRINGS ];

int num_coins;
int num_springs;

int scroll_x, scroll_y;
int gameover;
int on_level;
int continue_lev;			//Level to continue from after GameOver

BITMAP *buffer;

int is_a_block( int n )
{
	if ( (n == 1) || (n == 9) || (n == 10) || (n == 11) )
		return 1;
	else
		return 0;
}

int pt_on_block( int x, int y )
{
	int cx, cy;
	cx = (int)( x / 31 );
	cy = (int)( y / 31 );
	return is_a_block( map.square[ cx ][ cy ].type );
}

void do_title_screen()
{
	clear( screen );
	textout_centre( screen, data[ 1 ].dat, "Jetpack Joe!", HALF_RES_X, 50, 14 );

	textout( screen, font, "Collect All         To Pass The Level ", 								20, 100, 15 );
	textout( screen, font, "Collect         To Gain Jetpack", 										20, 120, 15 );
	textout( screen, font, "Watch out for        ,        , and        They will kill you", 	20, 140, 15 );



	textout( screen, font, "TIPS", 20, 200, 15 );
	textout( screen, font, "-Don't collect jetpacks if you don't need them.", 					20, 210, 15 );
	textout( screen, font, " You have a very limited supply", 										20, 220, 15 );
	textout( screen, font, "-Try to \"Walk\" in the air to reduce fuel usage", 				20, 230, 15 );
	textout( screen, font, "-Try to back-track as little as possible", 							20, 240, 15 );

	textout( screen, font, "Keys:",																			20, 300, 15 );
	textout( screen, font, "Up - Use Jetpack (or jump if out of jetpack)", 						20, 310, 15 );
	textout( screen, font, "Space - Jump", 																20, 320, 15 );
	textout( screen, font, "Left/Right - Move Left/Right", 											20, 330, 15 );
	textout( screen, font, "K - Kill yourself in an impossible situation", 						20, 340, 15 );
	textout( screen, font, "J - Sometimes Joe's Jetpack Melts things and he gets stuck,", 	20, 350, 15 );
	textout( screen, font, "    use this to jar joe a bit and make him unstuck", 				20, 360, 15 );

	textout_centre( screen, data[ 1 ].dat, "Press Space To Start!", HALF_RES_X, RES_Y - 50, 1);

	draw_font_sprite( screen, 6, 120, 85, 14, -1);
	draw_font_sprite( screen, 7, 100, 105, 11, -1 );

	draw_font_sprite( screen, 20, 135, 125, 15, -1 );
	draw_font_sprite( screen, 21, 215, 125, 15, -1 );
	draw_font_sprite( screen, 14, 315, 125, 7, -1 );

	while ( !key[ KEY_SPACE ] );
	while ( key[ KEY_SPACE ] );

}

void do_death()
{
	joe.lives--;

	clear( screen );
	textout_centre( screen, data[ 1 ].dat, "Joe Died", HALF_RES_X, HALF_RES_Y, 14 );
	textprintf_centre( screen, data[ 1 ].dat, HALF_RES_X, HALF_RES_Y + 30, 14, "%i Lives Remaining", joe.lives );
	textout_centre( screen, data[ 1 ].dat, "Press Space", HALF_RES_X, RES_Y - 100, 1 );

	if (joe.lives <= 0 )
	{
		clear( screen );
		textout_centre( screen, data[ 1 ].dat, "Game Over!", HALF_RES_X, HALF_RES_Y, 4 );
		textout_centre( screen, data[ 1 ].dat, "Press Space", HALF_RES_X, RES_Y - 100, 1 );
		while ( !key[ KEY_SPACE ] );
		while ( key[ KEY_SPACE ] );
		new_game();
	}

	while ( !key[ KEY_SPACE ] );
	while ( key[ KEY_SPACE ] );

	load_level();
}

void do_win()
{
	clear( screen );
	textprintf_centre( screen, data[ 1 ].dat, HALF_RES_X, HALF_RES_Y, 15, "Level %i Compelte!", on_level );
	textout_centre( screen, data[ 1 ].dat, "Press Space", HALF_RES_X, RES_Y - 100, 1 );
	while ( !key[ KEY_SPACE ] );
	while ( key[ KEY_SPACE ] );

	load_next_level();

}

//Do Fancy Ending Screen with a bouncing / colourfull text displaying "You Win!"
void do_ending()
{
	int x, y, vx, vy;

	x = 100;
	y = 100;

	vx = 10;
	vy = 10;

	while ( !key[ KEY_ENTER ] )
	{
		while ( game_timer > 0 )
		{
			x += vx;
			y += vy;

			if ( (x > RES_X - 100) || (x < 100 ) ) vx *= -1;
			if ( (y > RES_Y - 100) || (y < 100 ) ) vy *= -1;
			game_timer--;
		}

		clear( buffer );
		textout_centre( buffer, data[ 1 ].dat, "You Win!", x, y, (int)(rand()%255) );
		textout_centre( buffer, data[ 1 ].dat, "Congradulations", HALF_RES_X, 50, 9 );
		textout_centre( buffer, data[ 1 ].dat, "Press Enter", HALF_RES_X, RES_Y - 50, 1 );
		blit( buffer, screen, 0, 0, 0, 0, RES_X, RES_Y );
	}

	new_game();
}

















void draw_game()
{
	int scx, scy;
	int x, y;


	//Draw Map
	scx = (int)(scroll_x / 31 );		//Which block to draw first
	scy = (int)(scroll_y / 31 );

	for ( x = -1; x < 22; x++ )
		for ( y = -1; y < 17; y++ )
			if ( ((scx + x) < MAP_SIZE_X) && ((scy + y) < MAP_SIZE_Y) && ((scx + x) >= 0 ) && ((scy + y) >= 0 ) )
				draw_font_sprite( buffer, map.square[ scx + x ][ scy + y ].type, ((x + scx) * 31) - scroll_x, ((y + scy) * 31) - scroll_y , map.square[ scx + x ][ scy + y ].primary_colour, map.square[ scx + x ][ scy + y ].secondary_colour );

	//Draw Joe
	if ( joe.jetpack_on )
	{
		draw_font_sprite( buffer, 5 - joe.dir, joe.x - scroll_x, joe.y - scroll_y, JOE_OUTLINE, -1 );
		draw_font_sprite( buffer, 13 - joe.dir, joe.x - scroll_x, joe.y - scroll_y, JOE_COLOUR, -1 );
	}
	else
	{
		draw_font_sprite( buffer, 3 - joe.dir, joe.x - scroll_x, joe.y - scroll_y, JOE_OUTLINE, -1 );
		draw_font_sprite( buffer, 13 - joe.dir, joe.x - scroll_x, joe.y - scroll_y, JOE_COLOUR, -1 );
	}


	//Draw Springs
	for ( x = 0; x <= num_springs; x++ )
		draw_font_sprite( buffer, 20 + spring[ x ].axis, spring[ x ].x - scroll_x, spring[ x ].y - scroll_y, 15, -1 );

	//Draw Jet Meter
        /* The old Jet Meter was done using a rectfill,  which is prohibited by the FONTHACK competition,
           so it is now done with a bunch of jetpack sprites at the top of the screen */
        textout( buffer, font, "Jets:", 10, 0, 15 );
        //Draw Max jets
        for ( x = 0; x <= (int)(MAX_JETS / 5); x++ )
              draw_font_sprite( buffer, 7, 20 + (x * 15), 0, 8, -1 );
        
        //Draw jets left
        for ( x = 0; x <= (int)(joe.jets_left / 5); x++ )
              draw_font_sprite( buffer, 7, 20 + (x * 15), 0, 11, -1 );
              
	//Draw Coinage
	draw_font_sprite( buffer, 6, 4, 15, 14, -1 );
	textprintf( buffer, font, 30, 26, 14, "%i of %i", joe.got_coins, num_coins );
	//Put the double buffer onto the screen
	blit( buffer, screen, 0, 0, 0, 0, RES_X, RES_Y );

}

int block_climbable( int x, int y )
{
	int a = map.square[x][y].type;
	if (  (a == 17) || (a == 18 ) )
		return 1;
	else
		return 0;
}

void jump_joe()
{
	if ( pt_on_block( joe.x + 15, joe.y + 32 ) )
		joe.vy = -JUMP_STRENGTH;
}
void game_logic()
{
	int cx, cy;
	int wall;
	float oldx, oldy;
	int i;

	//Save Joe's Old Position
	oldx = joe.x;
	oldy = joe.y;

	//Do Joe's Jetpack
	if ( joe.jetpack_on )
		if ( joe.jets_left > 0 )
		{
			joe.vy -= JET_STRENGTH;
			joe.jets_left -= USE_JETS;
		}
		else	//If joe is on the ground then let him jump only
			jump_joe();

	//Move Joe
	joe.x += joe.vx;
	joe.y += joe.vy;

	joe.vx *= FRICTION;
	joe.vy += GRAVITY;


	//Collision Detection With Map

	//Check ever pixel on the left hand side and right hand side of joe to see if there is a block
	wall = 0;
	for ( cx = joe.x + 0; cx < joe.x + 31; cx++ )
		if ( pt_on_block( cx, joe.y + 1) || pt_on_block( cx, joe.y + 30 ) )
			wall = 1;
	//If there is blockage then restrict Joe's X-axis movement
	if ( wall )
	{
		joe.x = oldx;
		joe.vx *= -BOUNCE;
	}

	//Check every pixel on the top and bottom of joe to see if there is a block
	wall = 0;
	for ( cy = joe.y + 0; cy < joe.y + 31; cy++ )
		if ( pt_on_block( joe.x + 1, cy) || pt_on_block( joe.x + 30, cy) )
			wall = 1;
	//If there is a block then restric Joe's Y-Axis movements
	if ( wall )
	{
		joe.y = oldy;
		joe.vy *= -BOUNCE;
	}

	//Check the tile that joe is currently on
	cx = (int)( (joe.x + 15) / 31 );
	cy = (int)( (joe.y + 15) / 31 );
	switch( map.square[ cx ][ cy ].type )
	{
		case 6:	map.square[ cx ][ cy ].type = 0;			//A Coin
					joe.got_coins++;
					play_sample( data[ 2 ].dat, 255, 128, 1000, 0 );
					break;
		case 7:	map.square[ cx ][ cy ].type = 0;			//A Jetpack
					joe.jets_left += GET_JETS;
					play_sample( data[ 3 ].dat, 255, 128, 1000, 0 );
					break;

		case 14:	do_death();										//Spikes
					break;
		case 15:	do_death();										//Spikes
					break;
		case 29: do_death();										//Spikes
					break;
		case 30:	do_death();										//Spikes
					break;
		case 28:	joe.lives++;									//A 1 Up!
					map.square[ cx ][ cy ].type = 0;
					play_sample( data[ 4 ].dat, 255, 128, 1000, 0 );
					break;
	}

	//Limit Jetfuel
	if ( joe.jets_left > MAX_JETS )
		joe.jets_left = MAX_JETS;

	//Check to see if joe has collected all Coins
	if ( joe.got_coins >= num_coins )
		do_win();


	//Do Springs
	for ( i = 0; i <= num_springs; i++ )
	{
		if ( spring[ i ].axis == 0 )
		{
			//Move Spring
			spring[ i ].y += spring[ i ].v;
			//Check Collisions
			if ( pt_on_block( spring[ i ].x + 15, spring[ i ].y - 1 ) || pt_on_block( spring[ i ].x + 15, spring[ i ].y + 32) )
				spring[ i ].v *= -1;
		}
		else
		{
			//Move Spring
			spring[ i ].x += spring[ i ].v;
			//Check Collisions
			if ( pt_on_block( spring[ i ].x - 1, spring[ i ].y + 15 ) || pt_on_block( spring[ i ].x + 32, spring[ i ].y + 15 ) )
				spring[ i ].v *= -1;
		}

		//Check to see if it hit joe!
		cx = joe.x + 15;
		cy = joe.y + 15;
		if (  (cx >= spring[ i ].x) && (cx <= spring[ i ].x + 31) &&
				(cy >= spring[ i ].y) && (cy <= spring[ i ].y + 31) )
			do_death();
	}

	//Do Scrolling
	scroll_x = joe.x - HALF_RES_X;
	scroll_y = joe.y - HALF_RES_Y;
	if ( scroll_x < 0 )
		scroll_x = 0;
	if ( scroll_y < 0 )
		scroll_y = 0;
	if ( scroll_x > (MAP_SIZE_X * 31) - RES_X )
		scroll_x = (MAP_SIZE_X * 31) - RES_X;
	if ( scroll_y > (MAP_SIZE_Y * 31) - RES_Y )
		scroll_y = (MAP_SIZE_Y * 31) - RES_Y;

}


void game_input()
{
	if ( key[ KEY_ESC ] )
		gameover = 1;
	if ( key[ KEY_LEFT ] )
	{
		joe.dir = 0;
		joe.vx -= JOE_SPEED;
	}
	if ( key[ KEY_RIGHT ] )
	{
		joe.dir = 1;
		joe.vx += JOE_SPEED;
	}

	if ( key[ KEY_UP ] )
		joe.jetpack_on = 1;
	else
		joe.jetpack_on = 0;

	if ( key[ KEY_J ] )
		joe.x += (int)(rand()%3) - 1;

	if ( key[ KEY_K ] )
		do_death();
	if ( key[ KEY_F12] )
		save_bmp("screen.bmp", buffer, default_palette );

	if ( key[ KEY_SPACE ] )
		jump_joe();

}
void do_game()
{
	LOCK_VARIABLE( game_timer );
	LOCK_FUNCTION( inc_game_timer );

	install_int_ex( inc_game_timer, BPS_TO_TIMER( 60 ) );
	gameover = 0;
	while ( !gameover )
	{
		while ( game_timer > 0 )
		{
			game_input();
			game_logic();
			game_timer--;
		}
		draw_game();
	}

	exit_system( 1 );
}


void init_map()
{
	int x,y;

	joe.jets_left = MAX_JETS;
	joe.got_coins = 0;

	num_coins = 0;
	num_springs = -1;

	for ( x = 0; x < MAP_SIZE_X; x++ )
		for ( y = 0; y < MAP_SIZE_Y; y++ )
		{
			switch ( map.square[ x ][ y ].type )
			{
				case 2:	joe.x = x * 31;
							joe.y = y * 31;
							joe.dir = 1;
							map.square[ x ][ y ].type = 0;
							break;
				case 3:	joe.x = x * 31;
							joe.y = y * 31;
							joe.dir = 0;
							map.square[ x ][ y ].type = 0;
							break;
				case 6:	num_coins++;
							break;
				case 20: num_springs++;
							spring[ num_springs ].x = x * 31;
							spring[ num_springs ].y = y * 31;
							spring[ num_springs ].axis = 0;
							spring[ num_springs ].v = -SPRING_SPEED;
							map.square[ x ][ y ].type = 0;
							break;
				case 21: num_springs++;
							spring[ num_springs ].x = x * 31;
							spring[ num_springs ].y = y * 31;
							spring[ num_springs ].axis = 1;
							spring[ num_springs ].v = -SPRING_SPEED;
							map.square[ x ][ y ].type = 0;
							break;
			}
		}
}

void init_joe()
{
	joe.lives = START_LIVES;
}


void load_level()
{
	switch( on_level )
	{
		case 1: 	continue_lev = 1;
					load_map( "joe1.lev" );
					break;
		case 2:	load_map( "joe2.lev" );
					break;
		case 3:	load_map( "joe3.lev" );
					break;
		case 4:	continue_lev = 4;
					load_map( "joe4.lev" );
					break;
		case 5:	load_map( "joe5.lev" );
                                        break;
		case 6:	load_map( "joe6.lev" );
					break;
		case 7:	continue_lev = 7;
					load_map( "joe7.lev" );
					break;
		case 8:	load_map( "joe8.lev" );
					break;
		case 9:	load_map( "joe9.lev" );
					break;
		case 10:	do_ending();
					break;
	}
	init_map();
}
void load_next_level()
{
	on_level++;
	load_level();
}



void exit_system( int n )
{
	destroy_bitmap( buffer );
	deinit_font_sprites();
	allegro_exit();

	exit( n );
}


void new_game()
{
	do_title_screen();
	init_joe();

	on_level = continue_lev - 1;
	load_next_level();

	do_game();

}

int main(void)
{

	allegro_init();
	install_keyboard();

	set_color_depth( 8 );
	if ( set_gfx_mode( GFX_AUTODETECT, RES_X, RES_Y, 0, 0 ) < 0 )
		exit_system( 1 );

	//Install Sound Drivers
	if ( detect_digi_driver( DIGI_AUTODETECT ) )
	{
			reserve_voices( 5, 0 );
			install_sound( DIGI_AUTODETECT, MIDI_NONE, "" );
	}


	buffer = create_bitmap( RES_X, RES_Y );
	init_font_sprites( "joe.dat" );
	continue_lev = 1;

	new_game();

} END_OF_MAIN();

