#define RES_X				640
#define RES_Y				480

#define MAP_SIZE_X		250
#define MAP_SIZE_Y		50

#include <allegro.h>

#include "fontsprites.c"
#include "map.c"

void exit_system( int num )
{
	deinit_font_sprites();
	allegro_exit();
}


void do_save()
{
	char f[ 255 ];
	sprintf( f, "./" );
	if ( file_select_ex( "Save As...", f, "LEV", sizeof( MAPTYPE ), 320, 240 ) )
		save_map( f );

}

void do_load()
{
	char f[ 255 ];
	sprintf( f, "./" );
	if ( file_select_ex( "Load File...", f, "LEV", sizeof( MAPTYPE ), 320, 240 ) )
		load_map( f );

}

int main(void)
{
	BITMAP *buffer;

	int x, y;

	int scroll_x, scroll_y;
	int pos_x, pos_y;
	int bg_colour;

	int sprite_choice, sprite_colour1, sprite_colour2;

	sprite_choice = 1;
	sprite_colour1 = 8;
	sprite_colour2 = 7;

	scroll_x = 0;
	scroll_y = 0;
	allegro_init();
	install_keyboard();
	install_mouse();
	install_timer();

	init_font_sprites( "joe.dat" );

	set_color_depth( 8 );
        if ( set_gfx_mode( GFX_AUTODETECT, RES_X, RES_Y, 0, 0 ) < 0 )
	{
		printf("Couldn't Init Graphics\n");
		exit_system( 1 );
	}

	buffer = create_bitmap( RES_X, RES_Y );
        show_mouse( screen );

	while ( !key[ KEY_ESC ] )
	{
		if ( key[ KEY_UP ] )
			scroll_y--;
		if ( key[ KEY_DOWN ] )
			scroll_y++;
		if ( key[ KEY_LEFT ] )
			scroll_x--;
		if ( key[ KEY_RIGHT ] )
			scroll_x++;

		if ( key[ KEY_1 ] )
			sprite_choice--;
		if ( key[ KEY_2 ] )
			sprite_choice++;

		if ( key[ KEY_Q ] )
			sprite_colour1--;
		if ( key[ KEY_W ] )
			sprite_colour1++;
		if ( key[ KEY_A ] )
			sprite_colour2--;
		if ( key[ KEY_S ] )
			sprite_colour2++;

		if ( scroll_x < 0 )
			scroll_x = 0;
		if ( scroll_x > MAP_SIZE_X - 20 )
			scroll_x = MAP_SIZE_X - 20;
		if ( scroll_y < 0 )
			scroll_y = 0;
		if ( scroll_y > MAP_SIZE_Y - 15 )
			scroll_y = MAP_SIZE_Y - 15;

		if ( key[ KEY_F2 ] )
			do_save();
		if ( key[ KEY_F3 ] )
			do_load();

		if ( key[ KEY_0 ] )
			for ( x = 0; x < MAP_SIZE_X; x++ )
				for ( y = 0; y < MAP_SIZE_Y; y++ )
				{
					bg_colour = sprite_colour2;
					map.square[ x ][ y ].type = 0;
					map.square[ x ][ y ].primary_colour = 0;
					map.square[ x ][ y ].secondary_colour = bg_colour;
				}
    if ( key[ KEY_B ] )
    	map.bg_colour = sprite_colour2;
    if ( key[ KEY_C ] )
    	sprite_colour2 = map.bg_colour;

		//Wait for no key to be pressed
		while (  (key[KEY_1]) || (key[KEY_2]) || (key[KEY_Q]) || (key[KEY_W]) ||
					(key[KEY_A]) || (key[KEY_S]) );

		pos_x = scroll_x + (int)(mouse_x / 31);
		pos_y = scroll_y + (int)(mouse_y / 31);

		if ( (pos_x >= 0) && (pos_y >= 0) && (pos_x < MAP_SIZE_X) && (pos_y < MAP_SIZE_Y) )
			if ( mouse_b == 1 )
			{
				map.square[ pos_x ][ pos_y ].type = sprite_choice;
				map.square[ pos_x ][ pos_y ].primary_colour = sprite_colour1;
				map.square[ pos_x ][ pos_y ].secondary_colour = sprite_colour2;
			}
			else if ( mouse_b == 2 )
			{
				map.square[ pos_x ][ pos_y ].type = 0;
				map.square[ pos_x ][ pos_y ].primary_colour = 0;
                                map.square[ pos_x ][ pos_y ].secondary_colour = map.bg_colour;
			}


		clear( buffer );
		//Draw Map
		for ( x = 0; x < 21; x++ )
			for ( y = 0; y < 16; y++ )
				if ( ((scroll_x + x) < MAP_SIZE_X) && ((scroll_y + y) < MAP_SIZE_Y) && ((scroll_x + x) >= 0 ) && ((scroll_y + y) >= 0 ) )
					draw_font_sprite( buffer, map.square[ scroll_x + x ][ scroll_y + y ].type, x * 31, y * 31 , map.square[ scroll_x + x ][ scroll_y + y ].primary_colour, map.square[ scroll_x + x ][ scroll_y + y ].secondary_colour );

		draw_font_sprite( buffer, sprite_choice, (pos_x - scroll_x) * 31, (pos_y - scroll_y) * 31, sprite_colour1, sprite_colour2 );
		blit( buffer, screen, 0, 0, 0, 0, RES_X, RES_Y );
	}

	exit_system( 0 );
} END_OF_MAIN();

